/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteAuthTokenRequest
extends BmcRequest<Void> {
    private String userId;
    private String authTokenId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "authTokenId", "ifMatch"})
    DeleteAuthTokenRequest(String userId, String authTokenId, String ifMatch) {
        this.userId = userId;
        this.authTokenId = authTokenId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthTokenId() {
        return this.authTokenId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAuthTokenRequest, Void> {
        private String userId;
        private String authTokenId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAuthTokenRequest o) {
            this.userId(o.getUserId());
            this.authTokenId(o.getAuthTokenId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAuthTokenRequest build() {
            DeleteAuthTokenRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder authTokenId(String authTokenId) {
            this.authTokenId = authTokenId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteAuthTokenRequest buildWithoutInvocationCallback() {
            return new DeleteAuthTokenRequest(this.userId, this.authTokenId, this.ifMatch);
        }

        public String toString() {
            return "DeleteAuthTokenRequest.Builder(userId=" + this.userId + ", authTokenId=" + this.authTokenId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

