/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDynamicGroupRequest
extends BmcRequest<Void> {
    private String dynamicGroupId;
    private String ifMatch;

    @ConstructorProperties(value={"dynamicGroupId", "ifMatch"})
    DeleteDynamicGroupRequest(String dynamicGroupId, String ifMatch) {
        this.dynamicGroupId = dynamicGroupId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDynamicGroupId() {
        return this.dynamicGroupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDynamicGroupRequest, Void> {
        private String dynamicGroupId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDynamicGroupRequest o) {
            this.dynamicGroupId(o.getDynamicGroupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDynamicGroupRequest build() {
            DeleteDynamicGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dynamicGroupId(String dynamicGroupId) {
            this.dynamicGroupId = dynamicGroupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteDynamicGroupRequest buildWithoutInvocationCallback() {
            return new DeleteDynamicGroupRequest(this.dynamicGroupId, this.ifMatch);
        }

        public String toString() {
            return "DeleteDynamicGroupRequest.Builder(dynamicGroupId=" + this.dynamicGroupId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

