/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteOAuthClientCredentialRequest
extends BmcRequest<Void> {
    private String userId;
    private String oauth2ClientCredentialId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "oauth2ClientCredentialId", "ifMatch"})
    DeleteOAuthClientCredentialRequest(String userId, String oauth2ClientCredentialId, String ifMatch) {
        this.userId = userId;
        this.oauth2ClientCredentialId = oauth2ClientCredentialId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteOAuthClientCredentialRequest, Void> {
        private String userId;
        private String oauth2ClientCredentialId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteOAuthClientCredentialRequest build() {
            DeleteOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            return new DeleteOAuthClientCredentialRequest(this.userId, this.oauth2ClientCredentialId, this.ifMatch);
        }

        public String toString() {
            return "DeleteOAuthClientCredentialRequest.Builder(userId=" + this.userId + ", oauth2ClientCredentialId=" + this.oauth2ClientCredentialId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

