/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNetworkSourceRequest
extends BmcRequest<Void> {
    private String networkSourceId;

    @ConstructorProperties(value={"networkSourceId"})
    GetNetworkSourceRequest(String networkSourceId) {
        this.networkSourceId = networkSourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkSourceId() {
        return this.networkSourceId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNetworkSourceRequest, Void> {
        private String networkSourceId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNetworkSourceRequest o) {
            this.networkSourceId(o.getNetworkSourceId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNetworkSourceRequest build() {
            GetNetworkSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkSourceId(String networkSourceId) {
            this.networkSourceId = networkSourceId;
            return this;
        }

        public GetNetworkSourceRequest buildWithoutInvocationCallback() {
            return new GetNetworkSourceRequest(this.networkSourceId);
        }

        public String toString() {
            return "GetNetworkSourceRequest.Builder(networkSourceId=" + this.networkSourceId + ")";
        }
    }
}

