/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPolicyRequest
extends BmcRequest<Void> {
    private String policyId;

    @ConstructorProperties(value={"policyId"})
    GetPolicyRequest(String policyId) {
        this.policyId = policyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPolicyRequest, Void> {
        private String policyId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPolicyRequest build() {
            GetPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public GetPolicyRequest buildWithoutInvocationCallback() {
            return new GetPolicyRequest(this.policyId);
        }

        public String toString() {
            return "GetPolicyRequest.Builder(policyId=" + this.policyId + ")";
        }
    }
}

