/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagDefaultsRequest
extends BmcRequest<Void> {
    private String page;
    private Integer limit;
    private String id;
    private String compartmentId;
    private String tagDefinitionId;
    private TagDefaultSummary.LifecycleState lifecycleState;

    @ConstructorProperties(value={"page", "limit", "id", "compartmentId", "tagDefinitionId", "lifecycleState"})
    ListTagDefaultsRequest(String page, Integer limit, String id, String compartmentId, String tagDefinitionId, TagDefaultSummary.LifecycleState lifecycleState) {
        this.page = page;
        this.limit = limit;
        this.id = id;
        this.compartmentId = compartmentId;
        this.tagDefinitionId = tagDefinitionId;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public TagDefaultSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagDefaultsRequest, Void> {
        private String page;
        private Integer limit;
        private String id;
        private String compartmentId;
        private String tagDefinitionId;
        private TagDefaultSummary.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagDefaultsRequest o) {
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.id(o.getId());
            this.compartmentId(o.getCompartmentId());
            this.tagDefinitionId(o.getTagDefinitionId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagDefaultsRequest build() {
            ListTagDefaultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder tagDefinitionId(String tagDefinitionId) {
            this.tagDefinitionId = tagDefinitionId;
            return this;
        }

        public Builder lifecycleState(TagDefaultSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagDefaultsRequest buildWithoutInvocationCallback() {
            return new ListTagDefaultsRequest(this.page, this.limit, this.id, this.compartmentId, this.tagDefinitionId, this.lifecycleState);
        }

        public String toString() {
            return "ListTagDefaultsRequest.Builder(page=" + this.page + ", limit=" + this.limit + ", id=" + this.id + ", compartmentId=" + this.compartmentId + ", tagDefinitionId=" + this.tagDefinitionId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

