/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.UpdateAuthenticationPolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateAuthenticationPolicyRequest
extends BmcRequest<UpdateAuthenticationPolicyDetails> {
    private String compartmentId;
    private UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails;
    private String ifMatch;

    @InternalSdk
    public UpdateAuthenticationPolicyDetails getBody$() {
        return this.updateAuthenticationPolicyDetails;
    }

    @ConstructorProperties(value={"compartmentId", "updateAuthenticationPolicyDetails", "ifMatch"})
    UpdateAuthenticationPolicyRequest(String compartmentId, UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails, String ifMatch) {
        this.compartmentId = compartmentId;
        this.updateAuthenticationPolicyDetails = updateAuthenticationPolicyDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public UpdateAuthenticationPolicyDetails getUpdateAuthenticationPolicyDetails() {
        return this.updateAuthenticationPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAuthenticationPolicyRequest, UpdateAuthenticationPolicyDetails> {
        private String compartmentId;
        private UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAuthenticationPolicyRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.updateAuthenticationPolicyDetails(o.getUpdateAuthenticationPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAuthenticationPolicyRequest build() {
            UpdateAuthenticationPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAuthenticationPolicyDetails body) {
            this.updateAuthenticationPolicyDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder updateAuthenticationPolicyDetails(UpdateAuthenticationPolicyDetails updateAuthenticationPolicyDetails) {
            this.updateAuthenticationPolicyDetails = updateAuthenticationPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateAuthenticationPolicyRequest buildWithoutInvocationCallback() {
            return new UpdateAuthenticationPolicyRequest(this.compartmentId, this.updateAuthenticationPolicyDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateAuthenticationPolicyRequest.Builder(compartmentId=" + this.compartmentId + ", updateAuthenticationPolicyDetails=" + this.updateAuthenticationPolicyDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

