/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIntegrationInstanceRequest
extends BmcRequest<Void> {
    private String integrationInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"integrationInstanceId", "opcRequestId"})
    GetIntegrationInstanceRequest(String integrationInstanceId, String opcRequestId) {
        this.integrationInstanceId = integrationInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIntegrationInstanceRequest, Void> {
        private String integrationInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIntegrationInstanceRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIntegrationInstanceRequest build() {
            GetIntegrationInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetIntegrationInstanceRequest buildWithoutInvocationCallback() {
            return new GetIntegrationInstanceRequest(this.integrationInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetIntegrationInstanceRequest.Builder(integrationInstanceId=" + this.integrationInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

