/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsManagementAsync;
import com.oracle.bmc.keymanagement.KmsManagementAsyncClientBuilder;
import com.oracle.bmc.keymanagement.internal.http.BackupKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.CancelKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.CancelKeyVersionDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeKeyCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.DisableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.EnableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.GetWrappingKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.ImportKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.ImportKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeyVersionsConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeysConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreKeyFromFileConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreKeyFromObjectStoreConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleKeyVersionDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateKeyConverter;
import com.oracle.bmc.keymanagement.requests.BackupKeyRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.BackupKeyResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsManagementAsyncClient
implements KmsManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(KmsManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSMANAGEMENT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public KmsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static KmsManagementAsyncClientBuilder builder() {
        return new KmsManagementAsyncClientBuilder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<BackupKeyResponse> backupKey(BackupKeyRequest request, AsyncHandler<BackupKeyRequest, BackupKeyResponse> handler) {
        LOG.trace("Called async backupKey");
        BackupKeyRequest interceptedRequest = BackupKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BackupKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BackupKeyResponse> transformer = BackupKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BackupKeyRequest, BackupKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BackupKeyRequest, BackupKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelKeyDeletionResponse> cancelKeyDeletion(CancelKeyDeletionRequest request, AsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResponse> handler) {
        LOG.trace("Called async cancelKeyDeletion");
        CancelKeyDeletionRequest interceptedRequest = CancelKeyDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelKeyDeletionResponse> transformer = CancelKeyDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CancelKeyDeletionRequest, CancelKeyDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelKeyDeletionRequest, CancelKeyDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelKeyVersionDeletionResponse> cancelKeyVersionDeletion(CancelKeyVersionDeletionRequest request, AsyncHandler<CancelKeyVersionDeletionRequest, CancelKeyVersionDeletionResponse> handler) {
        LOG.trace("Called async cancelKeyVersionDeletion");
        CancelKeyVersionDeletionRequest interceptedRequest = CancelKeyVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelKeyVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelKeyVersionDeletionResponse> transformer = CancelKeyVersionDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CancelKeyVersionDeletionRequest, CancelKeyVersionDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelKeyVersionDeletionRequest, CancelKeyVersionDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeKeyCompartmentResponse> changeKeyCompartment(ChangeKeyCompartmentRequest request, AsyncHandler<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> handler) {
        LOG.trace("Called async changeKeyCompartment");
        ChangeKeyCompartmentRequest interceptedRequest = ChangeKeyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeKeyCompartmentResponse> transformer = ChangeKeyCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeKeyCompartmentRequest, ChangeKeyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateKeyResponse> createKey(CreateKeyRequest request, AsyncHandler<CreateKeyRequest, CreateKeyResponse> handler) {
        LOG.trace("Called async createKey");
        CreateKeyRequest interceptedRequest = CreateKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateKeyResponse> transformer = CreateKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateKeyRequest, CreateKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateKeyRequest, CreateKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateKeyVersionResponse> createKeyVersion(CreateKeyVersionRequest request, AsyncHandler<CreateKeyVersionRequest, CreateKeyVersionResponse> handler) {
        LOG.trace("Called async createKeyVersion");
        CreateKeyVersionRequest interceptedRequest = CreateKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateKeyVersionResponse> transformer = CreateKeyVersionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateKeyVersionRequest, CreateKeyVersionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateKeyVersionRequest, CreateKeyVersionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DisableKeyResponse> disableKey(DisableKeyRequest request, AsyncHandler<DisableKeyRequest, DisableKeyResponse> handler) {
        LOG.trace("Called async disableKey");
        DisableKeyRequest interceptedRequest = DisableKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DisableKeyResponse> transformer = DisableKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DisableKeyRequest, DisableKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DisableKeyRequest, DisableKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EnableKeyResponse> enableKey(EnableKeyRequest request, AsyncHandler<EnableKeyRequest, EnableKeyResponse> handler) {
        LOG.trace("Called async enableKey");
        EnableKeyRequest interceptedRequest = EnableKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableKeyResponse> transformer = EnableKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<EnableKeyRequest, EnableKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EnableKeyRequest, EnableKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetKeyResponse> getKey(GetKeyRequest request, AsyncHandler<GetKeyRequest, GetKeyResponse> handler) {
        LOG.trace("Called async getKey");
        GetKeyRequest interceptedRequest = GetKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetKeyResponse> transformer = GetKeyConverter.fromResponse();
        AsyncHandler<GetKeyRequest, GetKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetKeyRequest, GetKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetKeyVersionResponse> getKeyVersion(GetKeyVersionRequest request, AsyncHandler<GetKeyVersionRequest, GetKeyVersionResponse> handler) {
        LOG.trace("Called async getKeyVersion");
        GetKeyVersionRequest interceptedRequest = GetKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetKeyVersionResponse> transformer = GetKeyVersionConverter.fromResponse();
        AsyncHandler<GetKeyVersionRequest, GetKeyVersionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetKeyVersionRequest, GetKeyVersionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWrappingKeyResponse> getWrappingKey(GetWrappingKeyRequest request, AsyncHandler<GetWrappingKeyRequest, GetWrappingKeyResponse> handler) {
        LOG.trace("Called async getWrappingKey");
        GetWrappingKeyRequest interceptedRequest = GetWrappingKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWrappingKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWrappingKeyResponse> transformer = GetWrappingKeyConverter.fromResponse();
        AsyncHandler<GetWrappingKeyRequest, GetWrappingKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWrappingKeyRequest, GetWrappingKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportKeyResponse> importKey(ImportKeyRequest request, AsyncHandler<ImportKeyRequest, ImportKeyResponse> handler) {
        LOG.trace("Called async importKey");
        ImportKeyRequest interceptedRequest = ImportKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportKeyResponse> transformer = ImportKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ImportKeyRequest, ImportKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportKeyRequest, ImportKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportKeyVersionResponse> importKeyVersion(ImportKeyVersionRequest request, AsyncHandler<ImportKeyVersionRequest, ImportKeyVersionResponse> handler) {
        LOG.trace("Called async importKeyVersion");
        ImportKeyVersionRequest interceptedRequest = ImportKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportKeyVersionResponse> transformer = ImportKeyVersionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ImportKeyVersionRequest, ImportKeyVersionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportKeyVersionRequest, ImportKeyVersionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListKeyVersionsResponse> listKeyVersions(ListKeyVersionsRequest request, AsyncHandler<ListKeyVersionsRequest, ListKeyVersionsResponse> handler) {
        LOG.trace("Called async listKeyVersions");
        ListKeyVersionsRequest interceptedRequest = ListKeyVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListKeyVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListKeyVersionsResponse> transformer = ListKeyVersionsConverter.fromResponse();
        AsyncHandler<ListKeyVersionsRequest, ListKeyVersionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListKeyVersionsRequest, ListKeyVersionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListKeysResponse> listKeys(ListKeysRequest request, AsyncHandler<ListKeysRequest, ListKeysResponse> handler) {
        LOG.trace("Called async listKeys");
        ListKeysRequest interceptedRequest = ListKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListKeysResponse> transformer = ListKeysConverter.fromResponse();
        AsyncHandler<ListKeysRequest, ListKeysResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListKeysRequest, ListKeysResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreKeyFromFileResponse> restoreKeyFromFile(RestoreKeyFromFileRequest request, AsyncHandler<RestoreKeyFromFileRequest, RestoreKeyFromFileResponse> handler) {
        LOG.trace("Called async restoreKeyFromFile");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (RestoreKeyFromFileRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)RestoreKeyFromFileRequest.builder());
        }
        final RestoreKeyFromFileRequest interceptedRequest = RestoreKeyFromFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreKeyFromFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreKeyFromFileResponse> transformer = RestoreKeyFromFileConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreKeyFromFileRequest, RestoreKeyFromFileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getRestoreKeyFromFileDetails(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreKeyFromObjectStoreResponse> restoreKeyFromObjectStore(RestoreKeyFromObjectStoreRequest request, AsyncHandler<RestoreKeyFromObjectStoreRequest, RestoreKeyFromObjectStoreResponse> handler) {
        LOG.trace("Called async restoreKeyFromObjectStore");
        RestoreKeyFromObjectStoreRequest interceptedRequest = RestoreKeyFromObjectStoreConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreKeyFromObjectStoreConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreKeyFromObjectStoreResponse> transformer = RestoreKeyFromObjectStoreConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestoreKeyFromObjectStoreRequest, RestoreKeyFromObjectStoreResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreKeyFromObjectStoreRequest, RestoreKeyFromObjectStoreResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScheduleKeyDeletionResponse> scheduleKeyDeletion(ScheduleKeyDeletionRequest request, AsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> handler) {
        LOG.trace("Called async scheduleKeyDeletion");
        ScheduleKeyDeletionRequest interceptedRequest = ScheduleKeyDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleKeyDeletionResponse> transformer = ScheduleKeyDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScheduleKeyDeletionRequest, ScheduleKeyDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScheduleKeyVersionDeletionResponse> scheduleKeyVersionDeletion(ScheduleKeyVersionDeletionRequest request, AsyncHandler<ScheduleKeyVersionDeletionRequest, ScheduleKeyVersionDeletionResponse> handler) {
        LOG.trace("Called async scheduleKeyVersionDeletion");
        ScheduleKeyVersionDeletionRequest interceptedRequest = ScheduleKeyVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleKeyVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleKeyVersionDeletionResponse> transformer = ScheduleKeyVersionDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ScheduleKeyVersionDeletionRequest, ScheduleKeyVersionDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScheduleKeyVersionDeletionRequest, ScheduleKeyVersionDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateKeyResponse> updateKey(UpdateKeyRequest request, AsyncHandler<UpdateKeyRequest, UpdateKeyResponse> handler) {
        LOG.trace("Called async updateKey");
        UpdateKeyRequest interceptedRequest = UpdateKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateKeyResponse> transformer = UpdateKeyConverter.fromResponse();
        AsyncHandler<UpdateKeyRequest, UpdateKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateKeyRequest, UpdateKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }
}

