/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.keymanagement.model.Key;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreKeyFromFileConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreKeyFromFileConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RestoreKeyFromFileRequest interceptRequest(RestoreKeyFromFileRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RestoreKeyFromFileRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRestoreKeyFromFileDetails(), (String)"restoreKeyFromFileDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("20180608").path("keys").path("actions").path("restoreFromFile");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getContentLength() != null) {
            ib.header("content-length", (Object)request.getContentLength());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getContentMd5() != null) {
            ib.header("content-md5", (Object)request.getContentMd5());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, RestoreKeyFromFileResponse> fromResponse() {
        Function<Response, RestoreKeyFromFileResponse> transformer = new Function<Response, RestoreKeyFromFileResponse>(){

            public RestoreKeyFromFileResponse apply(Response rawResponse) {
                Optional opcWorkRequestIdHeader;
                Optional opcRequestIdHeader;
                Optional opcContentMd5Header;
                LOG.trace("Transform function invoked for com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Key.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RestoreKeyFromFileResponse.Builder builder = RestoreKeyFromFileResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.key((Key)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcContentMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-content-md5")).isPresent()) {
                    builder.opcContentMd5((String)HeaderUtils.toValue((String)"opc-content-md5", (String)((String)((List)opcContentMd5Header.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                RestoreKeyFromFileResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

