/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DecryptDataDetails {
    @JsonProperty(value="associatedData")
    private final Map<String, String> associatedData;
    @JsonProperty(value="ciphertext")
    private final String ciphertext;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="loggingContext")
    private final Map<String, String> loggingContext;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().associatedData(this.associatedData).ciphertext(this.ciphertext).keyId(this.keyId).loggingContext(this.loggingContext).keyVersionId(this.keyVersionId).encryptionAlgorithm(this.encryptionAlgorithm);
    }

    public Map<String, String> getAssociatedData() {
        return this.associatedData;
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, String> getLoggingContext() {
        return this.loggingContext;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptDataDetails)) {
            return false;
        }
        DecryptDataDetails other = (DecryptDataDetails)o;
        Map<String, String> this$associatedData = this.getAssociatedData();
        Map<String, String> other$associatedData = other.getAssociatedData();
        if (this$associatedData == null ? other$associatedData != null : !((Object)this$associatedData).equals(other$associatedData)) {
            return false;
        }
        String this$ciphertext = this.getCiphertext();
        String other$ciphertext = other.getCiphertext();
        if (this$ciphertext == null ? other$ciphertext != null : !this$ciphertext.equals(other$ciphertext)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        Map<String, String> this$loggingContext = this.getLoggingContext();
        Map<String, String> other$loggingContext = other.getLoggingContext();
        if (this$loggingContext == null ? other$loggingContext != null : !((Object)this$loggingContext).equals(other$loggingContext)) {
            return false;
        }
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        EncryptionAlgorithm this$encryptionAlgorithm = this.getEncryptionAlgorithm();
        EncryptionAlgorithm other$encryptionAlgorithm = other.getEncryptionAlgorithm();
        if (this$encryptionAlgorithm == null ? other$encryptionAlgorithm != null : !((Object)((Object)this$encryptionAlgorithm)).equals((Object)other$encryptionAlgorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $associatedData = this.getAssociatedData();
        result = result * 59 + ($associatedData == null ? 43 : ((Object)$associatedData).hashCode());
        String $ciphertext = this.getCiphertext();
        result = result * 59 + ($ciphertext == null ? 43 : $ciphertext.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        Map<String, String> $loggingContext = this.getLoggingContext();
        result = result * 59 + ($loggingContext == null ? 43 : ((Object)$loggingContext).hashCode());
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        EncryptionAlgorithm $encryptionAlgorithm = this.getEncryptionAlgorithm();
        result = result * 59 + ($encryptionAlgorithm == null ? 43 : ((Object)((Object)$encryptionAlgorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "DecryptDataDetails(associatedData=" + this.getAssociatedData() + ", ciphertext=" + this.getCiphertext() + ", keyId=" + this.getKeyId() + ", loggingContext=" + this.getLoggingContext() + ", keyVersionId=" + this.getKeyVersionId() + ", encryptionAlgorithm=" + (Object)((Object)this.getEncryptionAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"associatedData", "ciphertext", "keyId", "loggingContext", "keyVersionId", "encryptionAlgorithm"})
    @Deprecated
    public DecryptDataDetails(Map<String, String> associatedData, String ciphertext, String keyId, Map<String, String> loggingContext, String keyVersionId, EncryptionAlgorithm encryptionAlgorithm) {
        this.associatedData = associatedData;
        this.ciphertext = ciphertext;
        this.keyId = keyId;
        this.loggingContext = loggingContext;
        this.keyVersionId = keyVersionId;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public static enum EncryptionAlgorithm {
        Aes256Gcm("AES_256_GCM"),
        RsaOaepSha1("RSA_OAEP_SHA_1"),
        RsaOaepSha256("RSA_OAEP_SHA_256");

        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EncryptionAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="associatedData")
        private Map<String, String> associatedData;
        @JsonProperty(value="ciphertext")
        private String ciphertext;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="loggingContext")
        private Map<String, String> loggingContext;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder associatedData(Map<String, String> associatedData) {
            this.associatedData = associatedData;
            this.__explicitlySet__.add("associatedData");
            return this;
        }

        public Builder ciphertext(String ciphertext) {
            this.ciphertext = ciphertext;
            this.__explicitlySet__.add("ciphertext");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder loggingContext(Map<String, String> loggingContext) {
            this.loggingContext = loggingContext;
            this.__explicitlySet__.add("loggingContext");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public DecryptDataDetails build() {
            DecryptDataDetails __instance__ = new DecryptDataDetails(this.associatedData, this.ciphertext, this.keyId, this.loggingContext, this.keyVersionId, this.encryptionAlgorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DecryptDataDetails o) {
            Builder copiedBuilder = this.associatedData(o.getAssociatedData()).ciphertext(o.getCiphertext()).keyId(o.getKeyId()).loggingContext(o.getLoggingContext()).keyVersionId(o.getKeyVersionId()).encryptionAlgorithm(o.getEncryptionAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "DecryptDataDetails.Builder(associatedData=" + this.associatedData + ", ciphertext=" + this.ciphertext + ", keyId=" + this.keyId + ", loggingContext=" + this.loggingContext + ", keyVersionId=" + this.keyVersionId + ", encryptionAlgorithm=" + (Object)((Object)this.encryptionAlgorithm) + ")";
        }
    }
}

