/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportKeyDetails {
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="loggingContext")
    private final Map<String, String> loggingContext;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).keyVersionId(this.keyVersionId).algorithm(this.algorithm).publicKey(this.publicKey).loggingContext(this.loggingContext);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Map<String, String> getLoggingContext() {
        return this.loggingContext;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportKeyDetails)) {
            return false;
        }
        ExportKeyDetails other = (ExportKeyDetails)o;
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        Map<String, String> this$loggingContext = this.getLoggingContext();
        Map<String, String> other$loggingContext = other.getLoggingContext();
        if (this$loggingContext == null ? other$loggingContext != null : !((Object)this$loggingContext).equals(other$loggingContext)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        Map<String, String> $loggingContext = this.getLoggingContext();
        result = result * 59 + ($loggingContext == null ? 43 : ((Object)$loggingContext).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "ExportKeyDetails(keyId=" + this.getKeyId() + ", keyVersionId=" + this.getKeyVersionId() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ", publicKey=" + this.getPublicKey() + ", loggingContext=" + this.getLoggingContext() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"keyId", "keyVersionId", "algorithm", "publicKey", "loggingContext"})
    @Deprecated
    public ExportKeyDetails(String keyId, String keyVersionId, Algorithm algorithm, String publicKey, Map<String, String> loggingContext) {
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.algorithm = algorithm;
        this.publicKey = publicKey;
        this.loggingContext = loggingContext;
    }

    public static enum Algorithm {
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256"),
        RsaOaepSha256("RSA_OAEP_SHA256");

        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Algorithm: " + key);
        }

        static {
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="loggingContext")
        private Map<String, String> loggingContext;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder loggingContext(Map<String, String> loggingContext) {
            this.loggingContext = loggingContext;
            this.__explicitlySet__.add("loggingContext");
            return this;
        }

        public ExportKeyDetails build() {
            ExportKeyDetails __instance__ = new ExportKeyDetails(this.keyId, this.keyVersionId, this.algorithm, this.publicKey, this.loggingContext);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ExportKeyDetails o) {
            Builder copiedBuilder = this.keyId(o.getKeyId()).keyVersionId(o.getKeyVersionId()).algorithm(o.getAlgorithm()).publicKey(o.getPublicKey()).loggingContext(o.getLoggingContext());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "ExportKeyDetails.Builder(keyId=" + this.keyId + ", keyVersionId=" + this.keyVersionId + ", algorithm=" + (Object)((Object)this.algorithm) + ", publicKey=" + this.publicKey + ", loggingContext=" + this.loggingContext + ")";
        }
    }
}

