/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VerifyDataDetails {
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="signature")
    private final String signature;
    @JsonProperty(value="messageType")
    private final MessageType messageType;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="signingAlgorithm")
    private final SigningAlgorithm signingAlgorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).keyVersionId(this.keyVersionId).signature(this.signature).messageType(this.messageType).message(this.message).signingAlgorithm(this.signingAlgorithm);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getSignature() {
        return this.signature;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getMessage() {
        return this.message;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyDataDetails)) {
            return false;
        }
        VerifyDataDetails other = (VerifyDataDetails)o;
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        SigningAlgorithm this$signingAlgorithm = this.getSigningAlgorithm();
        SigningAlgorithm other$signingAlgorithm = other.getSigningAlgorithm();
        if (this$signingAlgorithm == null ? other$signingAlgorithm != null : !((Object)((Object)this$signingAlgorithm)).equals((Object)other$signingAlgorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        SigningAlgorithm $signingAlgorithm = this.getSigningAlgorithm();
        result = result * 59 + ($signingAlgorithm == null ? 43 : ((Object)((Object)$signingAlgorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "VerifyDataDetails(keyId=" + this.getKeyId() + ", keyVersionId=" + this.getKeyVersionId() + ", signature=" + this.getSignature() + ", messageType=" + (Object)((Object)this.getMessageType()) + ", message=" + this.getMessage() + ", signingAlgorithm=" + (Object)((Object)this.getSigningAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"keyId", "keyVersionId", "signature", "messageType", "message", "signingAlgorithm"})
    @Deprecated
    public VerifyDataDetails(String keyId, String keyVersionId, String signature, MessageType messageType, String message, SigningAlgorithm signingAlgorithm) {
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.signature = signature;
        this.messageType = messageType;
        this.message = message;
        this.signingAlgorithm = signingAlgorithm;
    }

    public static enum SigningAlgorithm {
        Sha224RsaPkcsPss("SHA_224_RSA_PKCS_PSS"),
        Sha256RsaPkcsPss("SHA_256_RSA_PKCS_PSS"),
        Sha384RsaPkcsPss("SHA_384_RSA_PKCS_PSS"),
        Sha512RsaPkcsPss("SHA_512_RSA_PKCS_PSS"),
        Sha224RsaPkcs1V15("SHA_224_RSA_PKCS1_V1_5"),
        Sha256RsaPkcs1V15("SHA_256_RSA_PKCS1_V1_5"),
        Sha384RsaPkcs1V15("SHA_384_RSA_PKCS1_V1_5"),
        Sha512RsaPkcs1V15("SHA_512_RSA_PKCS1_V1_5"),
        EcdsaSha256("ECDSA_SHA_256"),
        EcdsaSha384("ECDSA_SHA_384"),
        EcdsaSha512("ECDSA_SHA_512");

        private final String value;
        private static Map<String, SigningAlgorithm> map;

        private SigningAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SigningAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SigningAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, SigningAlgorithm>();
            for (SigningAlgorithm v : SigningAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MessageType {
        Raw("RAW"),
        Digest("DIGEST");

        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MessageType: " + key);
        }

        static {
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="signature")
        private String signature;
        @JsonProperty(value="messageType")
        private MessageType messageType;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="signingAlgorithm")
        private SigningAlgorithm signingAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            this.__explicitlySet__.add("signature");
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            this.__explicitlySet__.add("messageType");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            this.__explicitlySet__.add("signingAlgorithm");
            return this;
        }

        public VerifyDataDetails build() {
            VerifyDataDetails __instance__ = new VerifyDataDetails(this.keyId, this.keyVersionId, this.signature, this.messageType, this.message, this.signingAlgorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(VerifyDataDetails o) {
            Builder copiedBuilder = this.keyId(o.getKeyId()).keyVersionId(o.getKeyVersionId()).signature(o.getSignature()).messageType(o.getMessageType()).message(o.getMessage()).signingAlgorithm(o.getSigningAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "VerifyDataDetails.Builder(keyId=" + this.keyId + ", keyVersionId=" + this.keyVersionId + ", signature=" + this.signature + ", messageType=" + (Object)((Object)this.messageType) + ", message=" + this.message + ", signingAlgorithm=" + (Object)((Object)this.signingAlgorithm) + ")";
        }
    }
}

