/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.keymanagement.model.ImportKeyVersionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ImportKeyVersionRequest
extends BmcRequest<ImportKeyVersionDetails> {
    private String keyId;
    private ImportKeyVersionDetails importKeyVersionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ImportKeyVersionDetails getBody$() {
        return this.importKeyVersionDetails;
    }

    @ConstructorProperties(value={"keyId", "importKeyVersionDetails", "opcRequestId", "opcRetryToken"})
    ImportKeyVersionRequest(String keyId, ImportKeyVersionDetails importKeyVersionDetails, String opcRequestId, String opcRetryToken) {
        this.keyId = keyId;
        this.importKeyVersionDetails = importKeyVersionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public ImportKeyVersionDetails getImportKeyVersionDetails() {
        return this.importKeyVersionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportKeyVersionRequest, ImportKeyVersionDetails> {
        private String keyId;
        private ImportKeyVersionDetails importKeyVersionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportKeyVersionRequest o) {
            this.keyId(o.getKeyId());
            this.importKeyVersionDetails(o.getImportKeyVersionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportKeyVersionRequest build() {
            ImportKeyVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportKeyVersionDetails body) {
            this.importKeyVersionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder importKeyVersionDetails(ImportKeyVersionDetails importKeyVersionDetails) {
            this.importKeyVersionDetails = importKeyVersionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ImportKeyVersionRequest buildWithoutInvocationCallback() {
            return new ImportKeyVersionRequest(this.keyId, this.importKeyVersionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ImportKeyVersionRequest.Builder(keyId=" + this.keyId + ", importKeyVersionDetails=" + this.importKeyVersionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

