/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListKeysRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private ProtectionMode protectionMode;
    private Algorithm algorithm;
    private Integer length;
    private CurveId curveId;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "opcRequestId", "sortBy", "sortOrder", "protectionMode", "algorithm", "length", "curveId"})
    ListKeysRequest(String compartmentId, Integer limit, String page, String opcRequestId, SortBy sortBy, SortOrder sortOrder, ProtectionMode protectionMode, Algorithm algorithm, Integer length, CurveId curveId) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.protectionMode = protectionMode;
        this.algorithm = algorithm;
        this.length = length;
        this.curveId = curveId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Integer getLength() {
        return this.length;
    }

    public CurveId getCurveId() {
        return this.curveId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListKeysRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private ProtectionMode protectionMode;
        private Algorithm algorithm;
        private Integer length;
        private CurveId curveId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListKeysRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.protectionMode(o.getProtectionMode());
            this.algorithm(o.getAlgorithm());
            this.length(o.getLength());
            this.curveId(o.getCurveId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListKeysRequest build() {
            ListKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder curveId(CurveId curveId) {
            this.curveId = curveId;
            return this;
        }

        public ListKeysRequest buildWithoutInvocationCallback() {
            return new ListKeysRequest(this.compartmentId, this.limit, this.page, this.opcRequestId, this.sortBy, this.sortOrder, this.protectionMode, this.algorithm, this.length, this.curveId);
        }

        public String toString() {
            return "ListKeysRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", protectionMode=" + (Object)((Object)this.protectionMode) + ", algorithm=" + (Object)((Object)this.algorithm) + ", length=" + this.length + ", curveId=" + (Object)((Object)this.curveId) + ")";
        }
    }

    public static enum CurveId {
        NistP256("NIST_P256"),
        NistP384("NIST_P384"),
        NistP521("NIST_P521");

        private final String value;
        private static Map<String, CurveId> map;

        private CurveId(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CurveId create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CurveId: " + key);
        }

        static {
            map = new HashMap<String, CurveId>();
            for (CurveId v : CurveId.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Algorithm {
        Aes("AES"),
        Rsa("RSA"),
        Ecdsa("ECDSA");

        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Algorithm: " + key);
        }

        static {
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode {
        Hsm("HSM"),
        Software("SOFTWARE");

        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ProtectionMode: " + key);
        }

        static {
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

