/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.keymanagement.model.SignDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class SignRequest
extends BmcRequest<SignDataDetails> {
    private SignDataDetails signDataDetails;
    private String opcRequestId;

    @InternalSdk
    public SignDataDetails getBody$() {
        return this.signDataDetails;
    }

    @ConstructorProperties(value={"signDataDetails", "opcRequestId"})
    SignRequest(SignDataDetails signDataDetails, String opcRequestId) {
        this.signDataDetails = signDataDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SignDataDetails getSignDataDetails() {
        return this.signDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SignRequest, SignDataDetails> {
        private SignDataDetails signDataDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SignRequest o) {
            this.signDataDetails(o.getSignDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SignRequest build() {
            SignRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SignDataDetails body) {
            this.signDataDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder signDataDetails(SignDataDetails signDataDetails) {
            this.signDataDetails = signDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SignRequest buildWithoutInvocationCallback() {
            return new SignRequest(this.signDataDetails, this.opcRequestId);
        }

        public String toString() {
            return "SignRequest.Builder(signDataDetails=" + this.signDataDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

