/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.loadbalancer.LoadBalancerAsync;
import com.oracle.bmc.loadbalancer.internal.http.ChangeLoadBalancerCompartmentConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.CreateSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeletePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.DeleteSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetBackendSetHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetLoadBalancerHealthConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetPathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListBackendsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListCertificatesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListHostnamesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListListenerRulesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancerHealthsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListLoadBalancersConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPathRouteSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListPoliciesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListProtocolsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListRoutingPoliciesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListRuleSetsConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListSSLCipherSuitesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListShapesConverter;
import com.oracle.bmc.loadbalancer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateBackendSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHealthCheckerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateHostnameConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateListenerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateLoadBalancerConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateLoadBalancerShapeConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateNetworkSecurityGroupsConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdatePathRouteSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateRoutingPolicyConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateRuleSetConverter;
import com.oracle.bmc.loadbalancer.internal.http.UpdateSSLCipherSuiteConverter;
import com.oracle.bmc.loadbalancer.requests.ChangeLoadBalancerCompartmentRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.CreateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.CreateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.CreatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.CreateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.CreateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteCertificateRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.DeletePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.DeleteSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.GetHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerHealthRequest;
import com.oracle.bmc.loadbalancer.requests.GetLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.GetPathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.GetRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.GetSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.loadbalancer.requests.ListCertificatesRequest;
import com.oracle.bmc.loadbalancer.requests.ListHostnamesRequest;
import com.oracle.bmc.loadbalancer.requests.ListListenerRulesRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPathRouteSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRoutingPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListRuleSetsRequest;
import com.oracle.bmc.loadbalancer.requests.ListSSLCipherSuitesRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateHostnameRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateLoadBalancerShapeRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.loadbalancer.requests.UpdatePathRouteSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRoutingPolicyRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateRuleSetRequest;
import com.oracle.bmc.loadbalancer.requests.UpdateSSLCipherSuiteRequest;
import com.oracle.bmc.loadbalancer.responses.ChangeLoadBalancerCompartmentResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.CreateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.CreateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.CreatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.CreateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.CreateSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteCertificateResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.DeletePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.DeleteSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.GetHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerHealthResponse;
import com.oracle.bmc.loadbalancer.responses.GetLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.GetPathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.GetRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.GetSSLCipherSuiteResponse;
import com.oracle.bmc.loadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.loadbalancer.responses.ListCertificatesResponse;
import com.oracle.bmc.loadbalancer.responses.ListHostnamesResponse;
import com.oracle.bmc.loadbalancer.responses.ListListenerRulesResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPathRouteSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRoutingPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListRuleSetsResponse;
import com.oracle.bmc.loadbalancer.responses.ListSSLCipherSuitesResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateHostnameResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateLoadBalancerShapeResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.loadbalancer.responses.UpdatePathRouteSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRoutingPolicyResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateRuleSetResponse;
import com.oracle.bmc.loadbalancer.responses.UpdateSSLCipherSuiteResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerAsyncClient
implements LoadBalancerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(LoadBalancerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOADBALANCER").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public LoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeLoadBalancerCompartmentResponse> changeLoadBalancerCompartment(ChangeLoadBalancerCompartmentRequest request, AsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> handler) {
        LOG.trace("Called async changeLoadBalancerCompartment");
        ChangeLoadBalancerCompartmentRequest interceptedRequest = ChangeLoadBalancerCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLoadBalancerCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeLoadBalancerCompartmentResponse> transformer = ChangeLoadBalancerCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLoadBalancerCompartmentRequest, ChangeLoadBalancerCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBackendResponse> createBackend(CreateBackendRequest request, AsyncHandler<CreateBackendRequest, CreateBackendResponse> handler) {
        LOG.trace("Called async createBackend");
        CreateBackendRequest interceptedRequest = CreateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBackendResponse> transformer = CreateBackendConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBackendRequest, CreateBackendResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBackendRequest, CreateBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBackendSetResponse> createBackendSet(CreateBackendSetRequest request, AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handler) {
        LOG.trace("Called async createBackendSet");
        CreateBackendSetRequest interceptedRequest = CreateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBackendSetResponse> transformer = CreateBackendSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBackendSetRequest, CreateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        LOG.trace("Called async createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCertificateRequest, CreateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateHostnameResponse> createHostname(CreateHostnameRequest request, AsyncHandler<CreateHostnameRequest, CreateHostnameResponse> handler) {
        LOG.trace("Called async createHostname");
        CreateHostnameRequest interceptedRequest = CreateHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateHostnameConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateHostnameResponse> transformer = CreateHostnameConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateHostnameRequest, CreateHostnameResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateHostnameRequest, CreateHostnameResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateListenerResponse> createListener(CreateListenerRequest request, AsyncHandler<CreateListenerRequest, CreateListenerResponse> handler) {
        LOG.trace("Called async createListener");
        CreateListenerRequest interceptedRequest = CreateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateListenerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateListenerResponse> transformer = CreateListenerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateListenerRequest, CreateListenerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateListenerRequest, CreateListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest request, AsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse> handler) {
        LOG.trace("Called async createLoadBalancer");
        CreateLoadBalancerRequest interceptedRequest = CreateLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateLoadBalancerResponse> transformer = CreateLoadBalancerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLoadBalancerRequest, CreateLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePathRouteSetResponse> createPathRouteSet(CreatePathRouteSetRequest request, AsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse> handler) {
        LOG.trace("Called async createPathRouteSet");
        CreatePathRouteSetRequest interceptedRequest = CreatePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePathRouteSetResponse> transformer = CreatePathRouteSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePathRouteSetRequest, CreatePathRouteSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePathRouteSetRequest, CreatePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRoutingPolicyResponse> createRoutingPolicy(CreateRoutingPolicyRequest request, AsyncHandler<CreateRoutingPolicyRequest, CreateRoutingPolicyResponse> handler) {
        LOG.trace("Called async createRoutingPolicy");
        CreateRoutingPolicyRequest interceptedRequest = CreateRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateRoutingPolicyResponse> transformer = CreateRoutingPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRoutingPolicyRequest, CreateRoutingPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRoutingPolicyRequest, CreateRoutingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRuleSetResponse> createRuleSet(CreateRuleSetRequest request, AsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse> handler) {
        LOG.trace("Called async createRuleSet");
        CreateRuleSetRequest interceptedRequest = CreateRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateRuleSetResponse> transformer = CreateRuleSetConverter.fromResponse();
        AsyncHandler<CreateRuleSetRequest, CreateRuleSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRuleSetRequest, CreateRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSSLCipherSuiteResponse> createSSLCipherSuite(CreateSSLCipherSuiteRequest request, AsyncHandler<CreateSSLCipherSuiteRequest, CreateSSLCipherSuiteResponse> handler) {
        LOG.trace("Called async createSSLCipherSuite");
        CreateSSLCipherSuiteRequest interceptedRequest = CreateSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateSSLCipherSuiteResponse> transformer = CreateSSLCipherSuiteConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSSLCipherSuiteRequest, CreateSSLCipherSuiteResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSSLCipherSuiteRequest, CreateSSLCipherSuiteResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBackendResponse> deleteBackend(DeleteBackendRequest request, AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handler) {
        LOG.trace("Called async deleteBackend");
        DeleteBackendRequest interceptedRequest = DeleteBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteBackendResponse> transformer = DeleteBackendConverter.fromResponse();
        AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBackendRequest, DeleteBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBackendSetResponse> deleteBackendSet(DeleteBackendSetRequest request, AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handler) {
        LOG.trace("Called async deleteBackendSet");
        DeleteBackendSetRequest interceptedRequest = DeleteBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteBackendSetResponse> transformer = DeleteBackendSetConverter.fromResponse();
        AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBackendSetRequest, DeleteBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        LOG.trace("Called async deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCertificateRequest, DeleteCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteHostnameResponse> deleteHostname(DeleteHostnameRequest request, AsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse> handler) {
        LOG.trace("Called async deleteHostname");
        DeleteHostnameRequest interceptedRequest = DeleteHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHostnameConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteHostnameResponse> transformer = DeleteHostnameConverter.fromResponse();
        AsyncHandler<DeleteHostnameRequest, DeleteHostnameResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteHostnameRequest, DeleteHostnameResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteListenerResponse> deleteListener(DeleteListenerRequest request, AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handler) {
        LOG.trace("Called async deleteListener");
        DeleteListenerRequest interceptedRequest = DeleteListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteListenerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteListenerResponse> transformer = DeleteListenerConverter.fromResponse();
        AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteListenerRequest, DeleteListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest request, AsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> handler) {
        LOG.trace("Called async deleteLoadBalancer");
        DeleteLoadBalancerRequest interceptedRequest = DeleteLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLoadBalancerResponse> transformer = DeleteLoadBalancerConverter.fromResponse();
        AsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePathRouteSetResponse> deletePathRouteSet(DeletePathRouteSetRequest request, AsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse> handler) {
        LOG.trace("Called async deletePathRouteSet");
        DeletePathRouteSetRequest interceptedRequest = DeletePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePathRouteSetResponse> transformer = DeletePathRouteSetConverter.fromResponse();
        AsyncHandler<DeletePathRouteSetRequest, DeletePathRouteSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePathRouteSetRequest, DeletePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRoutingPolicyResponse> deleteRoutingPolicy(DeleteRoutingPolicyRequest request, AsyncHandler<DeleteRoutingPolicyRequest, DeleteRoutingPolicyResponse> handler) {
        LOG.trace("Called async deleteRoutingPolicy");
        DeleteRoutingPolicyRequest interceptedRequest = DeleteRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteRoutingPolicyResponse> transformer = DeleteRoutingPolicyConverter.fromResponse();
        AsyncHandler<DeleteRoutingPolicyRequest, DeleteRoutingPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRoutingPolicyRequest, DeleteRoutingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRuleSetResponse> deleteRuleSet(DeleteRuleSetRequest request, AsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse> handler) {
        LOG.trace("Called async deleteRuleSet");
        DeleteRuleSetRequest interceptedRequest = DeleteRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRuleSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteRuleSetResponse> transformer = DeleteRuleSetConverter.fromResponse();
        AsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRuleSetRequest, DeleteRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSSLCipherSuiteResponse> deleteSSLCipherSuite(DeleteSSLCipherSuiteRequest request, AsyncHandler<DeleteSSLCipherSuiteRequest, DeleteSSLCipherSuiteResponse> handler) {
        LOG.trace("Called async deleteSSLCipherSuite");
        DeleteSSLCipherSuiteRequest interceptedRequest = DeleteSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteSSLCipherSuiteResponse> transformer = DeleteSSLCipherSuiteConverter.fromResponse();
        AsyncHandler<DeleteSSLCipherSuiteRequest, DeleteSSLCipherSuiteResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSSLCipherSuiteRequest, DeleteSSLCipherSuiteResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendResponse> getBackend(GetBackendRequest request, AsyncHandler<GetBackendRequest, GetBackendResponse> handler) {
        LOG.trace("Called async getBackend");
        GetBackendRequest interceptedRequest = GetBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBackendResponse> transformer = GetBackendConverter.fromResponse();
        AsyncHandler<GetBackendRequest, GetBackendResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendRequest, GetBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendHealthResponse> getBackendHealth(GetBackendHealthRequest request, AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handler) {
        LOG.trace("Called async getBackendHealth");
        GetBackendHealthRequest interceptedRequest = GetBackendHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendHealthConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBackendHealthResponse> transformer = GetBackendHealthConverter.fromResponse();
        AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendHealthRequest, GetBackendHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendSetResponse> getBackendSet(GetBackendSetRequest request, AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handler) {
        LOG.trace("Called async getBackendSet");
        GetBackendSetRequest interceptedRequest = GetBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBackendSetResponse> transformer = GetBackendSetConverter.fromResponse();
        AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendSetRequest, GetBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendSetHealthResponse> getBackendSetHealth(GetBackendSetHealthRequest request, AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handler) {
        LOG.trace("Called async getBackendSetHealth");
        GetBackendSetHealthRequest interceptedRequest = GetBackendSetHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetHealthConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBackendSetHealthResponse> transformer = GetBackendSetHealthConverter.fromResponse();
        AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendSetHealthRequest, GetBackendSetHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHealthCheckerResponse> getHealthChecker(GetHealthCheckerRequest request, AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handler) {
        LOG.trace("Called async getHealthChecker");
        GetHealthCheckerRequest interceptedRequest = GetHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetHealthCheckerResponse> transformer = GetHealthCheckerConverter.fromResponse();
        AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHealthCheckerRequest, GetHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHostnameResponse> getHostname(GetHostnameRequest request, AsyncHandler<GetHostnameRequest, GetHostnameResponse> handler) {
        LOG.trace("Called async getHostname");
        GetHostnameRequest interceptedRequest = GetHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHostnameConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetHostnameResponse> transformer = GetHostnameConverter.fromResponse();
        AsyncHandler<GetHostnameRequest, GetHostnameResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHostnameRequest, GetHostnameResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest request, AsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse> handler) {
        LOG.trace("Called async getLoadBalancer");
        GetLoadBalancerRequest interceptedRequest = GetLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLoadBalancerResponse> transformer = GetLoadBalancerConverter.fromResponse();
        AsyncHandler<GetLoadBalancerRequest, GetLoadBalancerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLoadBalancerRequest, GetLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLoadBalancerHealthResponse> getLoadBalancerHealth(GetLoadBalancerHealthRequest request, AsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> handler) {
        LOG.trace("Called async getLoadBalancerHealth");
        GetLoadBalancerHealthRequest interceptedRequest = GetLoadBalancerHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLoadBalancerHealthConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLoadBalancerHealthResponse> transformer = GetLoadBalancerHealthConverter.fromResponse();
        AsyncHandler<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLoadBalancerHealthRequest, GetLoadBalancerHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPathRouteSetResponse> getPathRouteSet(GetPathRouteSetRequest request, AsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse> handler) {
        LOG.trace("Called async getPathRouteSet");
        GetPathRouteSetRequest interceptedRequest = GetPathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPathRouteSetResponse> transformer = GetPathRouteSetConverter.fromResponse();
        AsyncHandler<GetPathRouteSetRequest, GetPathRouteSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPathRouteSetRequest, GetPathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoutingPolicyResponse> getRoutingPolicy(GetRoutingPolicyRequest request, AsyncHandler<GetRoutingPolicyRequest, GetRoutingPolicyResponse> handler) {
        LOG.trace("Called async getRoutingPolicy");
        GetRoutingPolicyRequest interceptedRequest = GetRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRoutingPolicyResponse> transformer = GetRoutingPolicyConverter.fromResponse();
        AsyncHandler<GetRoutingPolicyRequest, GetRoutingPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoutingPolicyRequest, GetRoutingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRuleSetResponse> getRuleSet(GetRuleSetRequest request, AsyncHandler<GetRuleSetRequest, GetRuleSetResponse> handler) {
        LOG.trace("Called async getRuleSet");
        GetRuleSetRequest interceptedRequest = GetRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRuleSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRuleSetResponse> transformer = GetRuleSetConverter.fromResponse();
        AsyncHandler<GetRuleSetRequest, GetRuleSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRuleSetRequest, GetRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSSLCipherSuiteResponse> getSSLCipherSuite(GetSSLCipherSuiteRequest request, AsyncHandler<GetSSLCipherSuiteRequest, GetSSLCipherSuiteResponse> handler) {
        LOG.trace("Called async getSSLCipherSuite");
        GetSSLCipherSuiteRequest interceptedRequest = GetSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetSSLCipherSuiteResponse> transformer = GetSSLCipherSuiteConverter.fromResponse();
        AsyncHandler<GetSSLCipherSuiteRequest, GetSSLCipherSuiteResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSSLCipherSuiteRequest, GetSSLCipherSuiteResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBackendSetsResponse> listBackendSets(ListBackendSetsRequest request, AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handler) {
        LOG.trace("Called async listBackendSets");
        ListBackendSetsRequest interceptedRequest = ListBackendSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendSetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBackendSetsResponse> transformer = ListBackendSetsConverter.fromResponse();
        AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBackendSetsRequest, ListBackendSetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBackendsResponse> listBackends(ListBackendsRequest request, AsyncHandler<ListBackendsRequest, ListBackendsResponse> handler) {
        LOG.trace("Called async listBackends");
        ListBackendsRequest interceptedRequest = ListBackendsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBackendsResponse> transformer = ListBackendsConverter.fromResponse();
        AsyncHandler<ListBackendsRequest, ListBackendsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBackendsRequest, ListBackendsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        LOG.trace("Called async listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCertificatesRequest, ListCertificatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListHostnamesResponse> listHostnames(ListHostnamesRequest request, AsyncHandler<ListHostnamesRequest, ListHostnamesResponse> handler) {
        LOG.trace("Called async listHostnames");
        ListHostnamesRequest interceptedRequest = ListHostnamesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHostnamesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListHostnamesResponse> transformer = ListHostnamesConverter.fromResponse();
        AsyncHandler<ListHostnamesRequest, ListHostnamesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListHostnamesRequest, ListHostnamesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListListenerRulesResponse> listListenerRules(ListListenerRulesRequest request, AsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse> handler) {
        LOG.trace("Called async listListenerRules");
        ListListenerRulesRequest interceptedRequest = ListListenerRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListenerRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListListenerRulesResponse> transformer = ListListenerRulesConverter.fromResponse();
        AsyncHandler<ListListenerRulesRequest, ListListenerRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListListenerRulesRequest, ListListenerRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLoadBalancerHealthsResponse> listLoadBalancerHealths(ListLoadBalancerHealthsRequest request, AsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> handler) {
        LOG.trace("Called async listLoadBalancerHealths");
        ListLoadBalancerHealthsRequest interceptedRequest = ListLoadBalancerHealthsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLoadBalancerHealthsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLoadBalancerHealthsResponse> transformer = ListLoadBalancerHealthsConverter.fromResponse();
        AsyncHandler<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLoadBalancersResponse> listLoadBalancers(ListLoadBalancersRequest request, AsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse> handler) {
        LOG.trace("Called async listLoadBalancers");
        ListLoadBalancersRequest interceptedRequest = ListLoadBalancersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLoadBalancersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLoadBalancersResponse> transformer = ListLoadBalancersConverter.fromResponse();
        AsyncHandler<ListLoadBalancersRequest, ListLoadBalancersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLoadBalancersRequest, ListLoadBalancersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPathRouteSetsResponse> listPathRouteSets(ListPathRouteSetsRequest request, AsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse> handler) {
        LOG.trace("Called async listPathRouteSets");
        ListPathRouteSetsRequest interceptedRequest = ListPathRouteSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPathRouteSetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPathRouteSetsResponse> transformer = ListPathRouteSetsConverter.fromResponse();
        AsyncHandler<ListPathRouteSetsRequest, ListPathRouteSetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPathRouteSetsRequest, ListPathRouteSetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPoliciesResponse> listPolicies(ListPoliciesRequest request, AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handler) {
        LOG.trace("Called async listPolicies");
        ListPoliciesRequest interceptedRequest = ListPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPoliciesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPoliciesResponse> transformer = ListPoliciesConverter.fromResponse();
        AsyncHandler<ListPoliciesRequest, ListPoliciesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPoliciesRequest, ListPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProtocolsResponse> listProtocols(ListProtocolsRequest request, AsyncHandler<ListProtocolsRequest, ListProtocolsResponse> handler) {
        LOG.trace("Called async listProtocols");
        ListProtocolsRequest interceptedRequest = ListProtocolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProtocolsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProtocolsResponse> transformer = ListProtocolsConverter.fromResponse();
        AsyncHandler<ListProtocolsRequest, ListProtocolsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProtocolsRequest, ListProtocolsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRoutingPoliciesResponse> listRoutingPolicies(ListRoutingPoliciesRequest request, AsyncHandler<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse> handler) {
        LOG.trace("Called async listRoutingPolicies");
        ListRoutingPoliciesRequest interceptedRequest = ListRoutingPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoutingPoliciesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRoutingPoliciesResponse> transformer = ListRoutingPoliciesConverter.fromResponse();
        AsyncHandler<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRuleSetsResponse> listRuleSets(ListRuleSetsRequest request, AsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse> handler) {
        LOG.trace("Called async listRuleSets");
        ListRuleSetsRequest interceptedRequest = ListRuleSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRuleSetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRuleSetsResponse> transformer = ListRuleSetsConverter.fromResponse();
        AsyncHandler<ListRuleSetsRequest, ListRuleSetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRuleSetsRequest, ListRuleSetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSSLCipherSuitesResponse> listSSLCipherSuites(ListSSLCipherSuitesRequest request, AsyncHandler<ListSSLCipherSuitesRequest, ListSSLCipherSuitesResponse> handler) {
        LOG.trace("Called async listSSLCipherSuites");
        ListSSLCipherSuitesRequest interceptedRequest = ListSSLCipherSuitesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSSLCipherSuitesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSSLCipherSuitesResponse> transformer = ListSSLCipherSuitesConverter.fromResponse();
        AsyncHandler<ListSSLCipherSuitesRequest, ListSSLCipherSuitesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSSLCipherSuitesRequest, ListSSLCipherSuitesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        LOG.trace("Called async listShapes");
        ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        AsyncHandler<ListShapesRequest, ListShapesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListShapesRequest, ListShapesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBackendResponse> updateBackend(UpdateBackendRequest request, AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handler) {
        LOG.trace("Called async updateBackend");
        UpdateBackendRequest interceptedRequest = UpdateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBackendResponse> transformer = UpdateBackendConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBackendRequest, UpdateBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBackendSetResponse> updateBackendSet(UpdateBackendSetRequest request, AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handler) {
        LOG.trace("Called async updateBackendSet");
        UpdateBackendSetRequest interceptedRequest = UpdateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBackendSetResponse> transformer = UpdateBackendSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBackendSetRequest, UpdateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHealthCheckerResponse> updateHealthChecker(UpdateHealthCheckerRequest request, AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handler) {
        LOG.trace("Called async updateHealthChecker");
        UpdateHealthCheckerRequest interceptedRequest = UpdateHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateHealthCheckerResponse> transformer = UpdateHealthCheckerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHostnameResponse> updateHostname(UpdateHostnameRequest request, AsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse> handler) {
        LOG.trace("Called async updateHostname");
        UpdateHostnameRequest interceptedRequest = UpdateHostnameConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHostnameConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateHostnameResponse> transformer = UpdateHostnameConverter.fromResponse();
        AsyncHandler<UpdateHostnameRequest, UpdateHostnameResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHostnameRequest, UpdateHostnameResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateListenerResponse> updateListener(UpdateListenerRequest request, AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handler) {
        LOG.trace("Called async updateListener");
        UpdateListenerRequest interceptedRequest = UpdateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateListenerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateListenerResponse> transformer = UpdateListenerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateListenerRequest, UpdateListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLoadBalancerResponse> updateLoadBalancer(UpdateLoadBalancerRequest request, AsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> handler) {
        LOG.trace("Called async updateLoadBalancer");
        UpdateLoadBalancerRequest interceptedRequest = UpdateLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLoadBalancerResponse> transformer = UpdateLoadBalancerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLoadBalancerRequest, UpdateLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLoadBalancerShapeResponse> updateLoadBalancerShape(UpdateLoadBalancerShapeRequest request, AsyncHandler<UpdateLoadBalancerShapeRequest, UpdateLoadBalancerShapeResponse> handler) {
        LOG.trace("Called async updateLoadBalancerShape");
        UpdateLoadBalancerShapeRequest interceptedRequest = UpdateLoadBalancerShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLoadBalancerShapeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLoadBalancerShapeResponse> transformer = UpdateLoadBalancerShapeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateLoadBalancerShapeRequest, UpdateLoadBalancerShapeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLoadBalancerShapeRequest, UpdateLoadBalancerShapeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupsResponse> updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request, AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handler) {
        LOG.trace("Called async updateNetworkSecurityGroups");
        UpdateNetworkSecurityGroupsRequest interceptedRequest = UpdateNetworkSecurityGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateNetworkSecurityGroupsResponse> transformer = UpdateNetworkSecurityGroupsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePathRouteSetResponse> updatePathRouteSet(UpdatePathRouteSetRequest request, AsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> handler) {
        LOG.trace("Called async updatePathRouteSet");
        UpdatePathRouteSetRequest interceptedRequest = UpdatePathRouteSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePathRouteSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdatePathRouteSetResponse> transformer = UpdatePathRouteSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePathRouteSetRequest, UpdatePathRouteSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRoutingPolicyResponse> updateRoutingPolicy(UpdateRoutingPolicyRequest request, AsyncHandler<UpdateRoutingPolicyRequest, UpdateRoutingPolicyResponse> handler) {
        LOG.trace("Called async updateRoutingPolicy");
        UpdateRoutingPolicyRequest interceptedRequest = UpdateRoutingPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoutingPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateRoutingPolicyResponse> transformer = UpdateRoutingPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateRoutingPolicyRequest, UpdateRoutingPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRoutingPolicyRequest, UpdateRoutingPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRuleSetResponse> updateRuleSet(UpdateRuleSetRequest request, AsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse> handler) {
        LOG.trace("Called async updateRuleSet");
        UpdateRuleSetRequest interceptedRequest = UpdateRuleSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRuleSetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateRuleSetResponse> transformer = UpdateRuleSetConverter.fromResponse();
        AsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRuleSetRequest, UpdateRuleSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSSLCipherSuiteResponse> updateSSLCipherSuite(UpdateSSLCipherSuiteRequest request, AsyncHandler<UpdateSSLCipherSuiteRequest, UpdateSSLCipherSuiteResponse> handler) {
        LOG.trace("Called async updateSSLCipherSuite");
        UpdateSSLCipherSuiteRequest interceptedRequest = UpdateSSLCipherSuiteConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSSLCipherSuiteConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateSSLCipherSuiteResponse> transformer = UpdateSSLCipherSuiteConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateSSLCipherSuiteRequest, UpdateSSLCipherSuiteResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSSLCipherSuiteRequest, UpdateSSLCipherSuiteResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoadBalancerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LoadBalancerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LoadBalancerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

