/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendSetHealth {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="warningStateBackendNames")
    private final List<String> warningStateBackendNames;
    @JsonProperty(value="criticalStateBackendNames")
    private final List<String> criticalStateBackendNames;
    @JsonProperty(value="unknownStateBackendNames")
    private final List<String> unknownStateBackendNames;
    @JsonProperty(value="totalBackendCount")
    private final Integer totalBackendCount;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().status(this.status).warningStateBackendNames(this.warningStateBackendNames).criticalStateBackendNames(this.criticalStateBackendNames).unknownStateBackendNames(this.unknownStateBackendNames).totalBackendCount(this.totalBackendCount);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<String> getWarningStateBackendNames() {
        return this.warningStateBackendNames;
    }

    public List<String> getCriticalStateBackendNames() {
        return this.criticalStateBackendNames;
    }

    public List<String> getUnknownStateBackendNames() {
        return this.unknownStateBackendNames;
    }

    public Integer getTotalBackendCount() {
        return this.totalBackendCount;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BackendSetHealth)) {
            return false;
        }
        BackendSetHealth other = (BackendSetHealth)o;
        Integer this$totalBackendCount = this.getTotalBackendCount();
        Integer other$totalBackendCount = other.getTotalBackendCount();
        if (this$totalBackendCount == null ? other$totalBackendCount != null : !((Object)this$totalBackendCount).equals(other$totalBackendCount)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<String> this$warningStateBackendNames = this.getWarningStateBackendNames();
        List<String> other$warningStateBackendNames = other.getWarningStateBackendNames();
        if (this$warningStateBackendNames == null ? other$warningStateBackendNames != null : !((Object)this$warningStateBackendNames).equals(other$warningStateBackendNames)) {
            return false;
        }
        List<String> this$criticalStateBackendNames = this.getCriticalStateBackendNames();
        List<String> other$criticalStateBackendNames = other.getCriticalStateBackendNames();
        if (this$criticalStateBackendNames == null ? other$criticalStateBackendNames != null : !((Object)this$criticalStateBackendNames).equals(other$criticalStateBackendNames)) {
            return false;
        }
        List<String> this$unknownStateBackendNames = this.getUnknownStateBackendNames();
        List<String> other$unknownStateBackendNames = other.getUnknownStateBackendNames();
        if (this$unknownStateBackendNames == null ? other$unknownStateBackendNames != null : !((Object)this$unknownStateBackendNames).equals(other$unknownStateBackendNames)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $totalBackendCount = this.getTotalBackendCount();
        result = result * 59 + ($totalBackendCount == null ? 43 : ((Object)$totalBackendCount).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<String> $warningStateBackendNames = this.getWarningStateBackendNames();
        result = result * 59 + ($warningStateBackendNames == null ? 43 : ((Object)$warningStateBackendNames).hashCode());
        List<String> $criticalStateBackendNames = this.getCriticalStateBackendNames();
        result = result * 59 + ($criticalStateBackendNames == null ? 43 : ((Object)$criticalStateBackendNames).hashCode());
        List<String> $unknownStateBackendNames = this.getUnknownStateBackendNames();
        result = result * 59 + ($unknownStateBackendNames == null ? 43 : ((Object)$unknownStateBackendNames).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "BackendSetHealth(status=" + (Object)((Object)this.getStatus()) + ", warningStateBackendNames=" + this.getWarningStateBackendNames() + ", criticalStateBackendNames=" + this.getCriticalStateBackendNames() + ", unknownStateBackendNames=" + this.getUnknownStateBackendNames() + ", totalBackendCount=" + this.getTotalBackendCount() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"status", "warningStateBackendNames", "criticalStateBackendNames", "unknownStateBackendNames", "totalBackendCount"})
    @Deprecated
    public BackendSetHealth(Status status, List<String> warningStateBackendNames, List<String> criticalStateBackendNames, List<String> unknownStateBackendNames, Integer totalBackendCount) {
        this.status = status;
        this.warningStateBackendNames = warningStateBackendNames;
        this.criticalStateBackendNames = criticalStateBackendNames;
        this.unknownStateBackendNames = unknownStateBackendNames;
        this.totalBackendCount = totalBackendCount;
    }

    public static enum Status {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="warningStateBackendNames")
        private List<String> warningStateBackendNames;
        @JsonProperty(value="criticalStateBackendNames")
        private List<String> criticalStateBackendNames;
        @JsonProperty(value="unknownStateBackendNames")
        private List<String> unknownStateBackendNames;
        @JsonProperty(value="totalBackendCount")
        private Integer totalBackendCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder warningStateBackendNames(List<String> warningStateBackendNames) {
            this.warningStateBackendNames = warningStateBackendNames;
            this.__explicitlySet__.add("warningStateBackendNames");
            return this;
        }

        public Builder criticalStateBackendNames(List<String> criticalStateBackendNames) {
            this.criticalStateBackendNames = criticalStateBackendNames;
            this.__explicitlySet__.add("criticalStateBackendNames");
            return this;
        }

        public Builder unknownStateBackendNames(List<String> unknownStateBackendNames) {
            this.unknownStateBackendNames = unknownStateBackendNames;
            this.__explicitlySet__.add("unknownStateBackendNames");
            return this;
        }

        public Builder totalBackendCount(Integer totalBackendCount) {
            this.totalBackendCount = totalBackendCount;
            this.__explicitlySet__.add("totalBackendCount");
            return this;
        }

        public BackendSetHealth build() {
            BackendSetHealth __instance__ = new BackendSetHealth(this.status, this.warningStateBackendNames, this.criticalStateBackendNames, this.unknownStateBackendNames, this.totalBackendCount);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(BackendSetHealth o) {
            Builder copiedBuilder = this.status(o.getStatus()).warningStateBackendNames(o.getWarningStateBackendNames()).criticalStateBackendNames(o.getCriticalStateBackendNames()).unknownStateBackendNames(o.getUnknownStateBackendNames()).totalBackendCount(o.getTotalBackendCount());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "BackendSetHealth.Builder(status=" + (Object)((Object)this.status) + ", warningStateBackendNames=" + this.warningStateBackendNames + ", criticalStateBackendNames=" + this.criticalStateBackendNames + ", unknownStateBackendNames=" + this.unknownStateBackendNames + ", totalBackendCount=" + this.totalBackendCount + ")";
        }
    }
}

