/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LoadBalancerHealth {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="warningStateBackendSetNames")
    private final List<String> warningStateBackendSetNames;
    @JsonProperty(value="criticalStateBackendSetNames")
    private final List<String> criticalStateBackendSetNames;
    @JsonProperty(value="unknownStateBackendSetNames")
    private final List<String> unknownStateBackendSetNames;
    @JsonProperty(value="totalBackendSetCount")
    private final Integer totalBackendSetCount;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().status(this.status).warningStateBackendSetNames(this.warningStateBackendSetNames).criticalStateBackendSetNames(this.criticalStateBackendSetNames).unknownStateBackendSetNames(this.unknownStateBackendSetNames).totalBackendSetCount(this.totalBackendSetCount);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<String> getWarningStateBackendSetNames() {
        return this.warningStateBackendSetNames;
    }

    public List<String> getCriticalStateBackendSetNames() {
        return this.criticalStateBackendSetNames;
    }

    public List<String> getUnknownStateBackendSetNames() {
        return this.unknownStateBackendSetNames;
    }

    public Integer getTotalBackendSetCount() {
        return this.totalBackendSetCount;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadBalancerHealth)) {
            return false;
        }
        LoadBalancerHealth other = (LoadBalancerHealth)o;
        Integer this$totalBackendSetCount = this.getTotalBackendSetCount();
        Integer other$totalBackendSetCount = other.getTotalBackendSetCount();
        if (this$totalBackendSetCount == null ? other$totalBackendSetCount != null : !((Object)this$totalBackendSetCount).equals(other$totalBackendSetCount)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<String> this$warningStateBackendSetNames = this.getWarningStateBackendSetNames();
        List<String> other$warningStateBackendSetNames = other.getWarningStateBackendSetNames();
        if (this$warningStateBackendSetNames == null ? other$warningStateBackendSetNames != null : !((Object)this$warningStateBackendSetNames).equals(other$warningStateBackendSetNames)) {
            return false;
        }
        List<String> this$criticalStateBackendSetNames = this.getCriticalStateBackendSetNames();
        List<String> other$criticalStateBackendSetNames = other.getCriticalStateBackendSetNames();
        if (this$criticalStateBackendSetNames == null ? other$criticalStateBackendSetNames != null : !((Object)this$criticalStateBackendSetNames).equals(other$criticalStateBackendSetNames)) {
            return false;
        }
        List<String> this$unknownStateBackendSetNames = this.getUnknownStateBackendSetNames();
        List<String> other$unknownStateBackendSetNames = other.getUnknownStateBackendSetNames();
        if (this$unknownStateBackendSetNames == null ? other$unknownStateBackendSetNames != null : !((Object)this$unknownStateBackendSetNames).equals(other$unknownStateBackendSetNames)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $totalBackendSetCount = this.getTotalBackendSetCount();
        result = result * 59 + ($totalBackendSetCount == null ? 43 : ((Object)$totalBackendSetCount).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<String> $warningStateBackendSetNames = this.getWarningStateBackendSetNames();
        result = result * 59 + ($warningStateBackendSetNames == null ? 43 : ((Object)$warningStateBackendSetNames).hashCode());
        List<String> $criticalStateBackendSetNames = this.getCriticalStateBackendSetNames();
        result = result * 59 + ($criticalStateBackendSetNames == null ? 43 : ((Object)$criticalStateBackendSetNames).hashCode());
        List<String> $unknownStateBackendSetNames = this.getUnknownStateBackendSetNames();
        result = result * 59 + ($unknownStateBackendSetNames == null ? 43 : ((Object)$unknownStateBackendSetNames).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "LoadBalancerHealth(status=" + (Object)((Object)this.getStatus()) + ", warningStateBackendSetNames=" + this.getWarningStateBackendSetNames() + ", criticalStateBackendSetNames=" + this.getCriticalStateBackendSetNames() + ", unknownStateBackendSetNames=" + this.getUnknownStateBackendSetNames() + ", totalBackendSetCount=" + this.getTotalBackendSetCount() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"status", "warningStateBackendSetNames", "criticalStateBackendSetNames", "unknownStateBackendSetNames", "totalBackendSetCount"})
    @Deprecated
    public LoadBalancerHealth(Status status, List<String> warningStateBackendSetNames, List<String> criticalStateBackendSetNames, List<String> unknownStateBackendSetNames, Integer totalBackendSetCount) {
        this.status = status;
        this.warningStateBackendSetNames = warningStateBackendSetNames;
        this.criticalStateBackendSetNames = criticalStateBackendSetNames;
        this.unknownStateBackendSetNames = unknownStateBackendSetNames;
        this.totalBackendSetCount = totalBackendSetCount;
    }

    public static enum Status {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="warningStateBackendSetNames")
        private List<String> warningStateBackendSetNames;
        @JsonProperty(value="criticalStateBackendSetNames")
        private List<String> criticalStateBackendSetNames;
        @JsonProperty(value="unknownStateBackendSetNames")
        private List<String> unknownStateBackendSetNames;
        @JsonProperty(value="totalBackendSetCount")
        private Integer totalBackendSetCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder warningStateBackendSetNames(List<String> warningStateBackendSetNames) {
            this.warningStateBackendSetNames = warningStateBackendSetNames;
            this.__explicitlySet__.add("warningStateBackendSetNames");
            return this;
        }

        public Builder criticalStateBackendSetNames(List<String> criticalStateBackendSetNames) {
            this.criticalStateBackendSetNames = criticalStateBackendSetNames;
            this.__explicitlySet__.add("criticalStateBackendSetNames");
            return this;
        }

        public Builder unknownStateBackendSetNames(List<String> unknownStateBackendSetNames) {
            this.unknownStateBackendSetNames = unknownStateBackendSetNames;
            this.__explicitlySet__.add("unknownStateBackendSetNames");
            return this;
        }

        public Builder totalBackendSetCount(Integer totalBackendSetCount) {
            this.totalBackendSetCount = totalBackendSetCount;
            this.__explicitlySet__.add("totalBackendSetCount");
            return this;
        }

        public LoadBalancerHealth build() {
            LoadBalancerHealth __instance__ = new LoadBalancerHealth(this.status, this.warningStateBackendSetNames, this.criticalStateBackendSetNames, this.unknownStateBackendSetNames, this.totalBackendSetCount);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(LoadBalancerHealth o) {
            Builder copiedBuilder = this.status(o.getStatus()).warningStateBackendSetNames(o.getWarningStateBackendSetNames()).criticalStateBackendSetNames(o.getCriticalStateBackendSetNames()).unknownStateBackendSetNames(o.getUnknownStateBackendSetNames()).totalBackendSetCount(o.getTotalBackendSetCount());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "LoadBalancerHealth.Builder(status=" + (Object)((Object)this.status) + ", warningStateBackendSetNames=" + this.warningStateBackendSetNames + ", criticalStateBackendSetNames=" + this.criticalStateBackendSetNames + ", unknownStateBackendSetNames=" + this.unknownStateBackendSetNames + ", totalBackendSetCount=" + this.totalBackendSetCount + ")";
        }
    }
}

