/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteLoadBalancerRequest
extends BmcRequest<Void> {
    private String loadBalancerId;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "opcRequestId"})
    DeleteLoadBalancerRequest(String loadBalancerId, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteLoadBalancerRequest, Void> {
        private String loadBalancerId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteLoadBalancerRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteLoadBalancerRequest build() {
            DeleteLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteLoadBalancerRequest buildWithoutInvocationCallback() {
            return new DeleteLoadBalancerRequest(this.loadBalancerId, this.opcRequestId);
        }

        public String toString() {
            return "DeleteLoadBalancerRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

