/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String loadBalancerId;
    private String opcRequestId;
    private Long limit;
    private String page;

    @ConstructorProperties(value={"loadBalancerId", "opcRequestId", "limit", "page"})
    ListWorkRequestsRequest(String loadBalancerId, String opcRequestId, Long limit, String page) {
        this.loadBalancerId = loadBalancerId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private String loadBalancerId;
        private String opcRequestId;
        private Long limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestsRequest(this.loadBalancerId, this.opcRequestId, this.limit, this.page);
        }

        public String toString() {
            return "ListWorkRequestsRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

