/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.loganalytics.LogAnalyticsAsync;
import com.oracle.bmc.loganalytics.internal.http.AddEntityAssociationConverter;
import com.oracle.bmc.loganalytics.internal.http.AppendLookupDataConverter;
import com.oracle.bmc.loganalytics.internal.http.BatchGetBasicInfoConverter;
import com.oracle.bmc.loganalytics.internal.http.CancelQueryWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsEntityCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsLogGroupCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeScheduledTaskCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.CleanConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteParserConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadFileConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.DisableArchivingConverter;
import com.oracle.bmc.loganalytics.internal.http.EnableArchivingConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimatePurgeDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimateRecallDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimateReleaseDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.ExportCustomContentConverter;
import com.oracle.bmc.loganalytics.internal.http.ExportQueryResultConverter;
import com.oracle.bmc.loganalytics.internal.http.ExtractStructuredLogFieldPathsConverter;
import com.oracle.bmc.loganalytics.internal.http.ExtractStructuredLogHeaderPathsConverter;
import com.oracle.bmc.loganalytics.internal.http.FilterConverter;
import com.oracle.bmc.loganalytics.internal.http.GetAssociationSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetColumnNamesConverter;
import com.oracle.bmc.loganalytics.internal.http.GetConfigWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.GetFieldsSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLabelSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntitiesSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsLogGroupsSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.GetNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.GetParserConverter;
import com.oracle.bmc.loganalytics.internal.http.GetParserSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetQueryResultConverter;
import com.oracle.bmc.loganalytics.internal.http.GetQueryWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.GetSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.GetSourceSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageUsageConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetUploadConverter;
import com.oracle.bmc.loganalytics.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.ImportCustomContentConverter;
import com.oracle.bmc.loganalytics.internal.http.ListAssociatedEntitiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListConfigWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListEntityAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListEntitySourceAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListFieldsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelPrioritiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelSourceDetailsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsEntitiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsEntityTypesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsLogGroupsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsObjectCollectionRulesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLookupsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListMetaSourceTypesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListNamespacesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParserFunctionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParserMetaPluginsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParsersConverter;
import com.oracle.bmc.loganalytics.internal.http.ListQueryWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListRecalledDataConverter;
import com.oracle.bmc.loganalytics.internal.http.ListScheduledTasksConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceExtendedFieldDefinitionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceLabelOperatorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceMetaFunctionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourcePatternsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourcesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListStorageWorkRequestErrorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListStorageWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSupportedCharEncodingsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSupportedTimezonesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadFilesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadWarningsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWarningsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.OffboardNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.OnboardNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.ParseQueryConverter;
import com.oracle.bmc.loganalytics.internal.http.PauseScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.PurgeStorageDataConverter;
import com.oracle.bmc.loganalytics.internal.http.PutQueryWorkRequestBackgroundConverter;
import com.oracle.bmc.loganalytics.internal.http.QueryConverter;
import com.oracle.bmc.loganalytics.internal.http.RecallArchivedDataConverter;
import com.oracle.bmc.loganalytics.internal.http.RegisterLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.ReleaseRecalledDataConverter;
import com.oracle.bmc.loganalytics.internal.http.RemoveEntityAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ResumeScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.RunConverter;
import com.oracle.bmc.loganalytics.internal.http.SuggestConverter;
import com.oracle.bmc.loganalytics.internal.http.SuppressWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.TestParserConverter;
import com.oracle.bmc.loganalytics.internal.http.UnsuppressWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLookupDataConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateStorageConverter;
import com.oracle.bmc.loganalytics.internal.http.UploadLogFileConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertParserConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateAssociationParametersConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateFileConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceExtendedFieldDetailsConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceMappingConverter;
import com.oracle.bmc.loganalytics.requests.AddEntityAssociationRequest;
import com.oracle.bmc.loganalytics.requests.AppendLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.BatchGetBasicInfoRequest;
import com.oracle.bmc.loganalytics.requests.CancelQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsEntityCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsLogGroupCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeScheduledTaskCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.CleanRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.CreateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.DeleteFieldRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLabelRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLookupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteParserRequest;
import com.oracle.bmc.loganalytics.requests.DeleteScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteSourceRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadFileRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadWarningRequest;
import com.oracle.bmc.loganalytics.requests.DisableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.EnableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.EstimatePurgeDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateRecallDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateReleaseDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.ExportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ExportQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogFieldPathsRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogHeaderPathsRequest;
import com.oracle.bmc.loganalytics.requests.FilterRequest;
import com.oracle.bmc.loganalytics.requests.GetAssociationSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetColumnNamesRequest;
import com.oracle.bmc.loganalytics.requests.GetConfigWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntitiesSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.GetLookupRequest;
import com.oracle.bmc.loganalytics.requests.GetNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.GetParserRequest;
import com.oracle.bmc.loganalytics.requests.GetParserSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageUsageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetUploadRequest;
import com.oracle.bmc.loganalytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ImportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ListAssociatedEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListConfigWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListEntitySourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListFieldsRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelPrioritiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelSourceDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntityTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsLogGroupsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsObjectCollectionRulesRequest;
import com.oracle.bmc.loganalytics.requests.ListLookupsRequest;
import com.oracle.bmc.loganalytics.requests.ListMetaSourceTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListNamespacesRequest;
import com.oracle.bmc.loganalytics.requests.ListParserFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListParserMetaPluginsRequest;
import com.oracle.bmc.loganalytics.requests.ListParsersRequest;
import com.oracle.bmc.loganalytics.requests.ListQueryWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.ListScheduledTasksRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceExtendedFieldDefinitionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceLabelOperatorsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceMetaFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcePatternsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcesRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedCharEncodingsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedTimezonesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadFilesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadsRequest;
import com.oracle.bmc.loganalytics.requests.ListWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.OffboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.OnboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.ParseQueryRequest;
import com.oracle.bmc.loganalytics.requests.PauseScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.PurgeStorageDataRequest;
import com.oracle.bmc.loganalytics.requests.PutQueryWorkRequestBackgroundRequest;
import com.oracle.bmc.loganalytics.requests.QueryRequest;
import com.oracle.bmc.loganalytics.requests.RecallArchivedDataRequest;
import com.oracle.bmc.loganalytics.requests.RegisterLookupRequest;
import com.oracle.bmc.loganalytics.requests.ReleaseRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.RemoveEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ResumeScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.RunRequest;
import com.oracle.bmc.loganalytics.requests.SuggestRequest;
import com.oracle.bmc.loganalytics.requests.SuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.TestParserRequest;
import com.oracle.bmc.loganalytics.requests.UnsuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupRequest;
import com.oracle.bmc.loganalytics.requests.UpdateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.UpdateStorageRequest;
import com.oracle.bmc.loganalytics.requests.UploadLogFileRequest;
import com.oracle.bmc.loganalytics.requests.UpsertAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.UpsertFieldRequest;
import com.oracle.bmc.loganalytics.requests.UpsertLabelRequest;
import com.oracle.bmc.loganalytics.requests.UpsertParserRequest;
import com.oracle.bmc.loganalytics.requests.UpsertSourceRequest;
import com.oracle.bmc.loganalytics.requests.ValidateAssociationParametersRequest;
import com.oracle.bmc.loganalytics.requests.ValidateFileRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceExtendedFieldDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceMappingRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceRequest;
import com.oracle.bmc.loganalytics.responses.AddEntityAssociationResponse;
import com.oracle.bmc.loganalytics.responses.AppendLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.BatchGetBasicInfoResponse;
import com.oracle.bmc.loganalytics.responses.CancelQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsEntityCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsLogGroupCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeScheduledTaskCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.CleanResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.CreateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.DeleteFieldResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLabelResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLookupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteParserResponse;
import com.oracle.bmc.loganalytics.responses.DeleteScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteSourceResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadFileResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadWarningResponse;
import com.oracle.bmc.loganalytics.responses.DisableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.EnableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.EstimatePurgeDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateRecallDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateReleaseDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.ExportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ExportQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogFieldPathsResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogHeaderPathsResponse;
import com.oracle.bmc.loganalytics.responses.FilterResponse;
import com.oracle.bmc.loganalytics.responses.GetAssociationSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetColumnNamesResponse;
import com.oracle.bmc.loganalytics.responses.GetConfigWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntitiesSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.GetLookupResponse;
import com.oracle.bmc.loganalytics.responses.GetNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.GetParserResponse;
import com.oracle.bmc.loganalytics.responses.GetParserSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageUsageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetUploadResponse;
import com.oracle.bmc.loganalytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ImportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ListAssociatedEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListConfigWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListEntitySourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListFieldsResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelPrioritiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelSourceDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntityTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsLogGroupsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsObjectCollectionRulesResponse;
import com.oracle.bmc.loganalytics.responses.ListLookupsResponse;
import com.oracle.bmc.loganalytics.responses.ListMetaSourceTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListNamespacesResponse;
import com.oracle.bmc.loganalytics.responses.ListParserFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListParserMetaPluginsResponse;
import com.oracle.bmc.loganalytics.responses.ListParsersResponse;
import com.oracle.bmc.loganalytics.responses.ListQueryWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.ListScheduledTasksResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceExtendedFieldDefinitionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceLabelOperatorsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceMetaFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcePatternsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcesResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedCharEncodingsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedTimezonesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadFilesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadsResponse;
import com.oracle.bmc.loganalytics.responses.ListWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.OffboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.OnboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.ParseQueryResponse;
import com.oracle.bmc.loganalytics.responses.PauseScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.PurgeStorageDataResponse;
import com.oracle.bmc.loganalytics.responses.PutQueryWorkRequestBackgroundResponse;
import com.oracle.bmc.loganalytics.responses.QueryResponse;
import com.oracle.bmc.loganalytics.responses.RecallArchivedDataResponse;
import com.oracle.bmc.loganalytics.responses.RegisterLookupResponse;
import com.oracle.bmc.loganalytics.responses.ReleaseRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.RemoveEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ResumeScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.RunResponse;
import com.oracle.bmc.loganalytics.responses.SuggestResponse;
import com.oracle.bmc.loganalytics.responses.SuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.TestParserResponse;
import com.oracle.bmc.loganalytics.responses.UnsuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupResponse;
import com.oracle.bmc.loganalytics.responses.UpdateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.UpdateStorageResponse;
import com.oracle.bmc.loganalytics.responses.UploadLogFileResponse;
import com.oracle.bmc.loganalytics.responses.UpsertAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.UpsertFieldResponse;
import com.oracle.bmc.loganalytics.responses.UpsertLabelResponse;
import com.oracle.bmc.loganalytics.responses.UpsertParserResponse;
import com.oracle.bmc.loganalytics.responses.UpsertSourceResponse;
import com.oracle.bmc.loganalytics.responses.ValidateAssociationParametersResponse;
import com.oracle.bmc.loganalytics.responses.ValidateFileResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceExtendedFieldDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceMappingResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyticsAsyncClient
implements LogAnalyticsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(LogAnalyticsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://loganalytics.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public LogAnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LogAnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LogAnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LogAnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LogAnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LogAnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LogAnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public LogAnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddEntityAssociationResponse> addEntityAssociation(AddEntityAssociationRequest request, AsyncHandler<AddEntityAssociationRequest, AddEntityAssociationResponse> handler) {
        LOG.trace("Called async addEntityAssociation");
        AddEntityAssociationRequest interceptedRequest = AddEntityAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddEntityAssociationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AddEntityAssociationResponse> transformer = AddEntityAssociationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddEntityAssociationRequest, AddEntityAssociationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddEntityAssociationRequest, AddEntityAssociationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AppendLookupDataResponse> appendLookupData(AppendLookupDataRequest request, AsyncHandler<AppendLookupDataRequest, AppendLookupDataResponse> handler) {
        LOG.trace("Called async appendLookupData");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (AppendLookupDataRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)AppendLookupDataRequest.builder());
        }
        final AppendLookupDataRequest interceptedRequest = AppendLookupDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AppendLookupDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AppendLookupDataResponse> transformer = AppendLookupDataConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AppendLookupDataRequest, AppendLookupDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getAppendLookupFileBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchGetBasicInfoResponse> batchGetBasicInfo(BatchGetBasicInfoRequest request, AsyncHandler<BatchGetBasicInfoRequest, BatchGetBasicInfoResponse> handler) {
        LOG.trace("Called async batchGetBasicInfo");
        BatchGetBasicInfoRequest interceptedRequest = BatchGetBasicInfoConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchGetBasicInfoConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, BatchGetBasicInfoResponse> transformer = BatchGetBasicInfoConverter.fromResponse();
        AsyncHandler<BatchGetBasicInfoRequest, BatchGetBasicInfoResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchGetBasicInfoRequest, BatchGetBasicInfoResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelQueryWorkRequestResponse> cancelQueryWorkRequest(CancelQueryWorkRequestRequest request, AsyncHandler<CancelQueryWorkRequestRequest, CancelQueryWorkRequestResponse> handler) {
        LOG.trace("Called async cancelQueryWorkRequest");
        CancelQueryWorkRequestRequest interceptedRequest = CancelQueryWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelQueryWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelQueryWorkRequestResponse> transformer = CancelQueryWorkRequestConverter.fromResponse();
        AsyncHandler<CancelQueryWorkRequestRequest, CancelQueryWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelQueryWorkRequestRequest, CancelQueryWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeLogAnalyticsEntityCompartmentResponse> changeLogAnalyticsEntityCompartment(ChangeLogAnalyticsEntityCompartmentRequest request, AsyncHandler<ChangeLogAnalyticsEntityCompartmentRequest, ChangeLogAnalyticsEntityCompartmentResponse> handler) {
        LOG.trace("Called async changeLogAnalyticsEntityCompartment");
        ChangeLogAnalyticsEntityCompartmentRequest interceptedRequest = ChangeLogAnalyticsEntityCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsEntityCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeLogAnalyticsEntityCompartmentResponse> transformer = ChangeLogAnalyticsEntityCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeLogAnalyticsEntityCompartmentRequest, ChangeLogAnalyticsEntityCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogAnalyticsEntityCompartmentRequest, ChangeLogAnalyticsEntityCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeLogAnalyticsLogGroupCompartmentResponse> changeLogAnalyticsLogGroupCompartment(ChangeLogAnalyticsLogGroupCompartmentRequest request, AsyncHandler<ChangeLogAnalyticsLogGroupCompartmentRequest, ChangeLogAnalyticsLogGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeLogAnalyticsLogGroupCompartment");
        ChangeLogAnalyticsLogGroupCompartmentRequest interceptedRequest = ChangeLogAnalyticsLogGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsLogGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeLogAnalyticsLogGroupCompartmentResponse> transformer = ChangeLogAnalyticsLogGroupCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeLogAnalyticsLogGroupCompartmentRequest, ChangeLogAnalyticsLogGroupCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogAnalyticsLogGroupCompartmentRequest, ChangeLogAnalyticsLogGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse> changeLogAnalyticsObjectCollectionRuleCompartment(ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest request, AsyncHandler<ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse> handler) {
        LOG.trace("Called async changeLogAnalyticsObjectCollectionRuleCompartment");
        ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest interceptedRequest = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse> transformer = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.fromResponse();
        AsyncHandler<ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeScheduledTaskCompartmentResponse> changeScheduledTaskCompartment(ChangeScheduledTaskCompartmentRequest request, AsyncHandler<ChangeScheduledTaskCompartmentRequest, ChangeScheduledTaskCompartmentResponse> handler) {
        LOG.trace("Called async changeScheduledTaskCompartment");
        ChangeScheduledTaskCompartmentRequest interceptedRequest = ChangeScheduledTaskCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledTaskCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeScheduledTaskCompartmentResponse> transformer = ChangeScheduledTaskCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeScheduledTaskCompartmentRequest, ChangeScheduledTaskCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeScheduledTaskCompartmentRequest, ChangeScheduledTaskCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CleanResponse> clean(CleanRequest request, AsyncHandler<CleanRequest, CleanResponse> handler) {
        LOG.trace("Called async clean");
        CleanRequest interceptedRequest = CleanConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CleanConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CleanResponse> transformer = CleanConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CleanRequest, CleanResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CleanRequest, CleanResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogAnalyticsEntityResponse> createLogAnalyticsEntity(CreateLogAnalyticsEntityRequest request, AsyncHandler<CreateLogAnalyticsEntityRequest, CreateLogAnalyticsEntityResponse> handler) {
        LOG.trace("Called async createLogAnalyticsEntity");
        CreateLogAnalyticsEntityRequest interceptedRequest = CreateLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateLogAnalyticsEntityResponse> transformer = CreateLogAnalyticsEntityConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogAnalyticsEntityRequest, CreateLogAnalyticsEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogAnalyticsEntityRequest, CreateLogAnalyticsEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogAnalyticsEntityTypeResponse> createLogAnalyticsEntityType(CreateLogAnalyticsEntityTypeRequest request, AsyncHandler<CreateLogAnalyticsEntityTypeRequest, CreateLogAnalyticsEntityTypeResponse> handler) {
        LOG.trace("Called async createLogAnalyticsEntityType");
        CreateLogAnalyticsEntityTypeRequest interceptedRequest = CreateLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateLogAnalyticsEntityTypeResponse> transformer = CreateLogAnalyticsEntityTypeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogAnalyticsEntityTypeRequest, CreateLogAnalyticsEntityTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogAnalyticsEntityTypeRequest, CreateLogAnalyticsEntityTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogAnalyticsLogGroupResponse> createLogAnalyticsLogGroup(CreateLogAnalyticsLogGroupRequest request, AsyncHandler<CreateLogAnalyticsLogGroupRequest, CreateLogAnalyticsLogGroupResponse> handler) {
        LOG.trace("Called async createLogAnalyticsLogGroup");
        CreateLogAnalyticsLogGroupRequest interceptedRequest = CreateLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateLogAnalyticsLogGroupResponse> transformer = CreateLogAnalyticsLogGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogAnalyticsLogGroupRequest, CreateLogAnalyticsLogGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogAnalyticsLogGroupRequest, CreateLogAnalyticsLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogAnalyticsObjectCollectionRuleResponse> createLogAnalyticsObjectCollectionRule(CreateLogAnalyticsObjectCollectionRuleRequest request, AsyncHandler<CreateLogAnalyticsObjectCollectionRuleRequest, CreateLogAnalyticsObjectCollectionRuleResponse> handler) {
        LOG.trace("Called async createLogAnalyticsObjectCollectionRule");
        CreateLogAnalyticsObjectCollectionRuleRequest interceptedRequest = CreateLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateLogAnalyticsObjectCollectionRuleResponse> transformer = CreateLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        AsyncHandler<CreateLogAnalyticsObjectCollectionRuleRequest, CreateLogAnalyticsObjectCollectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogAnalyticsObjectCollectionRuleRequest, CreateLogAnalyticsObjectCollectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateScheduledTaskResponse> createScheduledTask(CreateScheduledTaskRequest request, AsyncHandler<CreateScheduledTaskRequest, CreateScheduledTaskResponse> handler) {
        LOG.trace("Called async createScheduledTask");
        CreateScheduledTaskRequest interceptedRequest = CreateScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateScheduledTaskResponse> transformer = CreateScheduledTaskConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateScheduledTaskRequest, CreateScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateScheduledTaskRequest, CreateScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAssociationsResponse> deleteAssociations(DeleteAssociationsRequest request, AsyncHandler<DeleteAssociationsRequest, DeleteAssociationsResponse> handler) {
        LOG.trace("Called async deleteAssociations");
        DeleteAssociationsRequest interceptedRequest = DeleteAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteAssociationsResponse> transformer = DeleteAssociationsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteAssociationsRequest, DeleteAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAssociationsRequest, DeleteAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFieldResponse> deleteField(DeleteFieldRequest request, AsyncHandler<DeleteFieldRequest, DeleteFieldResponse> handler) {
        LOG.trace("Called async deleteField");
        DeleteFieldRequest interceptedRequest = DeleteFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFieldConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteFieldResponse> transformer = DeleteFieldConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteFieldRequest, DeleteFieldResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFieldRequest, DeleteFieldResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLabelResponse> deleteLabel(DeleteLabelRequest request, AsyncHandler<DeleteLabelRequest, DeleteLabelResponse> handler) {
        LOG.trace("Called async deleteLabel");
        DeleteLabelRequest interceptedRequest = DeleteLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLabelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLabelResponse> transformer = DeleteLabelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteLabelRequest, DeleteLabelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLabelRequest, DeleteLabelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogAnalyticsEntityResponse> deleteLogAnalyticsEntity(DeleteLogAnalyticsEntityRequest request, AsyncHandler<DeleteLogAnalyticsEntityRequest, DeleteLogAnalyticsEntityResponse> handler) {
        LOG.trace("Called async deleteLogAnalyticsEntity");
        DeleteLogAnalyticsEntityRequest interceptedRequest = DeleteLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLogAnalyticsEntityResponse> transformer = DeleteLogAnalyticsEntityConverter.fromResponse();
        AsyncHandler<DeleteLogAnalyticsEntityRequest, DeleteLogAnalyticsEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogAnalyticsEntityRequest, DeleteLogAnalyticsEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogAnalyticsEntityTypeResponse> deleteLogAnalyticsEntityType(DeleteLogAnalyticsEntityTypeRequest request, AsyncHandler<DeleteLogAnalyticsEntityTypeRequest, DeleteLogAnalyticsEntityTypeResponse> handler) {
        LOG.trace("Called async deleteLogAnalyticsEntityType");
        DeleteLogAnalyticsEntityTypeRequest interceptedRequest = DeleteLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLogAnalyticsEntityTypeResponse> transformer = DeleteLogAnalyticsEntityTypeConverter.fromResponse();
        AsyncHandler<DeleteLogAnalyticsEntityTypeRequest, DeleteLogAnalyticsEntityTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogAnalyticsEntityTypeRequest, DeleteLogAnalyticsEntityTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogAnalyticsLogGroupResponse> deleteLogAnalyticsLogGroup(DeleteLogAnalyticsLogGroupRequest request, AsyncHandler<DeleteLogAnalyticsLogGroupRequest, DeleteLogAnalyticsLogGroupResponse> handler) {
        LOG.trace("Called async deleteLogAnalyticsLogGroup");
        DeleteLogAnalyticsLogGroupRequest interceptedRequest = DeleteLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLogAnalyticsLogGroupResponse> transformer = DeleteLogAnalyticsLogGroupConverter.fromResponse();
        AsyncHandler<DeleteLogAnalyticsLogGroupRequest, DeleteLogAnalyticsLogGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogAnalyticsLogGroupRequest, DeleteLogAnalyticsLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogAnalyticsObjectCollectionRuleResponse> deleteLogAnalyticsObjectCollectionRule(DeleteLogAnalyticsObjectCollectionRuleRequest request, AsyncHandler<DeleteLogAnalyticsObjectCollectionRuleRequest, DeleteLogAnalyticsObjectCollectionRuleResponse> handler) {
        LOG.trace("Called async deleteLogAnalyticsObjectCollectionRule");
        DeleteLogAnalyticsObjectCollectionRuleRequest interceptedRequest = DeleteLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLogAnalyticsObjectCollectionRuleResponse> transformer = DeleteLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        AsyncHandler<DeleteLogAnalyticsObjectCollectionRuleRequest, DeleteLogAnalyticsObjectCollectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogAnalyticsObjectCollectionRuleRequest, DeleteLogAnalyticsObjectCollectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLookupResponse> deleteLookup(DeleteLookupRequest request, AsyncHandler<DeleteLookupRequest, DeleteLookupResponse> handler) {
        LOG.trace("Called async deleteLookup");
        DeleteLookupRequest interceptedRequest = DeleteLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLookupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteLookupResponse> transformer = DeleteLookupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteLookupRequest, DeleteLookupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLookupRequest, DeleteLookupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteParserResponse> deleteParser(DeleteParserRequest request, AsyncHandler<DeleteParserRequest, DeleteParserResponse> handler) {
        LOG.trace("Called async deleteParser");
        DeleteParserRequest interceptedRequest = DeleteParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteParserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteParserResponse> transformer = DeleteParserConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteParserRequest, DeleteParserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteParserRequest, DeleteParserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteScheduledTaskResponse> deleteScheduledTask(DeleteScheduledTaskRequest request, AsyncHandler<DeleteScheduledTaskRequest, DeleteScheduledTaskResponse> handler) {
        LOG.trace("Called async deleteScheduledTask");
        DeleteScheduledTaskRequest interceptedRequest = DeleteScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteScheduledTaskResponse> transformer = DeleteScheduledTaskConverter.fromResponse();
        AsyncHandler<DeleteScheduledTaskRequest, DeleteScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteScheduledTaskRequest, DeleteScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSourceResponse> deleteSource(DeleteSourceRequest request, AsyncHandler<DeleteSourceRequest, DeleteSourceResponse> handler) {
        LOG.trace("Called async deleteSource");
        DeleteSourceRequest interceptedRequest = DeleteSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteSourceResponse> transformer = DeleteSourceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteSourceRequest, DeleteSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSourceRequest, DeleteSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteUploadResponse> deleteUpload(DeleteUploadRequest request, AsyncHandler<DeleteUploadRequest, DeleteUploadResponse> handler) {
        LOG.trace("Called async deleteUpload");
        DeleteUploadRequest interceptedRequest = DeleteUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteUploadResponse> transformer = DeleteUploadConverter.fromResponse();
        AsyncHandler<DeleteUploadRequest, DeleteUploadResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteUploadRequest, DeleteUploadResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteUploadFileResponse> deleteUploadFile(DeleteUploadFileRequest request, AsyncHandler<DeleteUploadFileRequest, DeleteUploadFileResponse> handler) {
        LOG.trace("Called async deleteUploadFile");
        DeleteUploadFileRequest interceptedRequest = DeleteUploadFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadFileConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteUploadFileResponse> transformer = DeleteUploadFileConverter.fromResponse();
        AsyncHandler<DeleteUploadFileRequest, DeleteUploadFileResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteUploadFileRequest, DeleteUploadFileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteUploadWarningResponse> deleteUploadWarning(DeleteUploadWarningRequest request, AsyncHandler<DeleteUploadWarningRequest, DeleteUploadWarningResponse> handler) {
        LOG.trace("Called async deleteUploadWarning");
        DeleteUploadWarningRequest interceptedRequest = DeleteUploadWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadWarningConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteUploadWarningResponse> transformer = DeleteUploadWarningConverter.fromResponse();
        AsyncHandler<DeleteUploadWarningRequest, DeleteUploadWarningResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteUploadWarningRequest, DeleteUploadWarningResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DisableArchivingResponse> disableArchiving(DisableArchivingRequest request, AsyncHandler<DisableArchivingRequest, DisableArchivingResponse> handler) {
        LOG.trace("Called async disableArchiving");
        DisableArchivingRequest interceptedRequest = DisableArchivingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableArchivingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DisableArchivingResponse> transformer = DisableArchivingConverter.fromResponse();
        AsyncHandler<DisableArchivingRequest, DisableArchivingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DisableArchivingRequest, DisableArchivingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EnableArchivingResponse> enableArchiving(EnableArchivingRequest request, AsyncHandler<EnableArchivingRequest, EnableArchivingResponse> handler) {
        LOG.trace("Called async enableArchiving");
        EnableArchivingRequest interceptedRequest = EnableArchivingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableArchivingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, EnableArchivingResponse> transformer = EnableArchivingConverter.fromResponse();
        AsyncHandler<EnableArchivingRequest, EnableArchivingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EnableArchivingRequest, EnableArchivingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EstimatePurgeDataSizeResponse> estimatePurgeDataSize(EstimatePurgeDataSizeRequest request, AsyncHandler<EstimatePurgeDataSizeRequest, EstimatePurgeDataSizeResponse> handler) {
        LOG.trace("Called async estimatePurgeDataSize");
        EstimatePurgeDataSizeRequest interceptedRequest = EstimatePurgeDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimatePurgeDataSizeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, EstimatePurgeDataSizeResponse> transformer = EstimatePurgeDataSizeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<EstimatePurgeDataSizeRequest, EstimatePurgeDataSizeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EstimatePurgeDataSizeRequest, EstimatePurgeDataSizeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EstimateRecallDataSizeResponse> estimateRecallDataSize(EstimateRecallDataSizeRequest request, AsyncHandler<EstimateRecallDataSizeRequest, EstimateRecallDataSizeResponse> handler) {
        LOG.trace("Called async estimateRecallDataSize");
        EstimateRecallDataSizeRequest interceptedRequest = EstimateRecallDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimateRecallDataSizeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, EstimateRecallDataSizeResponse> transformer = EstimateRecallDataSizeConverter.fromResponse();
        AsyncHandler<EstimateRecallDataSizeRequest, EstimateRecallDataSizeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EstimateRecallDataSizeRequest, EstimateRecallDataSizeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EstimateReleaseDataSizeResponse> estimateReleaseDataSize(EstimateReleaseDataSizeRequest request, AsyncHandler<EstimateReleaseDataSizeRequest, EstimateReleaseDataSizeResponse> handler) {
        LOG.trace("Called async estimateReleaseDataSize");
        EstimateReleaseDataSizeRequest interceptedRequest = EstimateReleaseDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimateReleaseDataSizeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, EstimateReleaseDataSizeResponse> transformer = EstimateReleaseDataSizeConverter.fromResponse();
        AsyncHandler<EstimateReleaseDataSizeRequest, EstimateReleaseDataSizeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EstimateReleaseDataSizeRequest, EstimateReleaseDataSizeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExportCustomContentResponse> exportCustomContent(ExportCustomContentRequest request, AsyncHandler<ExportCustomContentRequest, ExportCustomContentResponse> handler) {
        LOG.trace("Called async exportCustomContent");
        ExportCustomContentRequest interceptedRequest = ExportCustomContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportCustomContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExportCustomContentResponse> transformer = ExportCustomContentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExportCustomContentRequest, ExportCustomContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExportCustomContentRequest, ExportCustomContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExportQueryResultResponse> exportQueryResult(ExportQueryResultRequest request, AsyncHandler<ExportQueryResultRequest, ExportQueryResultResponse> handler) {
        LOG.trace("Called async exportQueryResult");
        ExportQueryResultRequest interceptedRequest = ExportQueryResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportQueryResultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExportQueryResultResponse> transformer = ExportQueryResultConverter.fromResponse();
        AsyncHandler<ExportQueryResultRequest, ExportQueryResultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExportQueryResultRequest, ExportQueryResultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExtractStructuredLogFieldPathsResponse> extractStructuredLogFieldPaths(ExtractStructuredLogFieldPathsRequest request, AsyncHandler<ExtractStructuredLogFieldPathsRequest, ExtractStructuredLogFieldPathsResponse> handler) {
        LOG.trace("Called async extractStructuredLogFieldPaths");
        ExtractStructuredLogFieldPathsRequest interceptedRequest = ExtractStructuredLogFieldPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExtractStructuredLogFieldPathsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExtractStructuredLogFieldPathsResponse> transformer = ExtractStructuredLogFieldPathsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExtractStructuredLogFieldPathsRequest, ExtractStructuredLogFieldPathsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExtractStructuredLogFieldPathsRequest, ExtractStructuredLogFieldPathsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ExtractStructuredLogHeaderPathsResponse> extractStructuredLogHeaderPaths(ExtractStructuredLogHeaderPathsRequest request, AsyncHandler<ExtractStructuredLogHeaderPathsRequest, ExtractStructuredLogHeaderPathsResponse> handler) {
        LOG.trace("Called async extractStructuredLogHeaderPaths");
        ExtractStructuredLogHeaderPathsRequest interceptedRequest = ExtractStructuredLogHeaderPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExtractStructuredLogHeaderPathsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ExtractStructuredLogHeaderPathsResponse> transformer = ExtractStructuredLogHeaderPathsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ExtractStructuredLogHeaderPathsRequest, ExtractStructuredLogHeaderPathsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ExtractStructuredLogHeaderPathsRequest, ExtractStructuredLogHeaderPathsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<FilterResponse> filter(FilterRequest request, AsyncHandler<FilterRequest, FilterResponse> handler) {
        LOG.trace("Called async filter");
        FilterRequest interceptedRequest = FilterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = FilterConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, FilterResponse> transformer = FilterConverter.fromResponse();
        AsyncHandler<FilterRequest, FilterResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<FilterRequest, FilterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAssociationSummaryResponse> getAssociationSummary(GetAssociationSummaryRequest request, AsyncHandler<GetAssociationSummaryRequest, GetAssociationSummaryResponse> handler) {
        LOG.trace("Called async getAssociationSummary");
        GetAssociationSummaryRequest interceptedRequest = GetAssociationSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAssociationSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetAssociationSummaryResponse> transformer = GetAssociationSummaryConverter.fromResponse();
        AsyncHandler<GetAssociationSummaryRequest, GetAssociationSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAssociationSummaryRequest, GetAssociationSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetColumnNamesResponse> getColumnNames(GetColumnNamesRequest request, AsyncHandler<GetColumnNamesRequest, GetColumnNamesResponse> handler) {
        LOG.trace("Called async getColumnNames");
        GetColumnNamesRequest interceptedRequest = GetColumnNamesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetColumnNamesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetColumnNamesResponse> transformer = GetColumnNamesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GetColumnNamesRequest, GetColumnNamesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetColumnNamesRequest, GetColumnNamesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConfigWorkRequestResponse> getConfigWorkRequest(GetConfigWorkRequestRequest request, AsyncHandler<GetConfigWorkRequestRequest, GetConfigWorkRequestResponse> handler) {
        LOG.trace("Called async getConfigWorkRequest");
        GetConfigWorkRequestRequest interceptedRequest = GetConfigWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConfigWorkRequestResponse> transformer = GetConfigWorkRequestConverter.fromResponse();
        AsyncHandler<GetConfigWorkRequestRequest, GetConfigWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConfigWorkRequestRequest, GetConfigWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFieldResponse> getField(GetFieldRequest request, AsyncHandler<GetFieldRequest, GetFieldResponse> handler) {
        LOG.trace("Called async getField");
        GetFieldRequest interceptedRequest = GetFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFieldConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFieldResponse> transformer = GetFieldConverter.fromResponse();
        AsyncHandler<GetFieldRequest, GetFieldResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFieldRequest, GetFieldResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFieldsSummaryResponse> getFieldsSummary(GetFieldsSummaryRequest request, AsyncHandler<GetFieldsSummaryRequest, GetFieldsSummaryResponse> handler) {
        LOG.trace("Called async getFieldsSummary");
        GetFieldsSummaryRequest interceptedRequest = GetFieldsSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFieldsSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFieldsSummaryResponse> transformer = GetFieldsSummaryConverter.fromResponse();
        AsyncHandler<GetFieldsSummaryRequest, GetFieldsSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFieldsSummaryRequest, GetFieldsSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLabelResponse> getLabel(GetLabelRequest request, AsyncHandler<GetLabelRequest, GetLabelResponse> handler) {
        LOG.trace("Called async getLabel");
        GetLabelRequest interceptedRequest = GetLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLabelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLabelResponse> transformer = GetLabelConverter.fromResponse();
        AsyncHandler<GetLabelRequest, GetLabelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLabelRequest, GetLabelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLabelSummaryResponse> getLabelSummary(GetLabelSummaryRequest request, AsyncHandler<GetLabelSummaryRequest, GetLabelSummaryResponse> handler) {
        LOG.trace("Called async getLabelSummary");
        GetLabelSummaryRequest interceptedRequest = GetLabelSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLabelSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLabelSummaryResponse> transformer = GetLabelSummaryConverter.fromResponse();
        AsyncHandler<GetLabelSummaryRequest, GetLabelSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLabelSummaryRequest, GetLabelSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsEntitiesSummaryResponse> getLogAnalyticsEntitiesSummary(GetLogAnalyticsEntitiesSummaryRequest request, AsyncHandler<GetLogAnalyticsEntitiesSummaryRequest, GetLogAnalyticsEntitiesSummaryResponse> handler) {
        LOG.trace("Called async getLogAnalyticsEntitiesSummary");
        GetLogAnalyticsEntitiesSummaryRequest interceptedRequest = GetLogAnalyticsEntitiesSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntitiesSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsEntitiesSummaryResponse> transformer = GetLogAnalyticsEntitiesSummaryConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsEntitiesSummaryRequest, GetLogAnalyticsEntitiesSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsEntitiesSummaryRequest, GetLogAnalyticsEntitiesSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsEntityResponse> getLogAnalyticsEntity(GetLogAnalyticsEntityRequest request, AsyncHandler<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> handler) {
        LOG.trace("Called async getLogAnalyticsEntity");
        GetLogAnalyticsEntityRequest interceptedRequest = GetLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsEntityResponse> transformer = GetLogAnalyticsEntityConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsEntityTypeResponse> getLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request, AsyncHandler<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> handler) {
        LOG.trace("Called async getLogAnalyticsEntityType");
        GetLogAnalyticsEntityTypeRequest interceptedRequest = GetLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsEntityTypeResponse> transformer = GetLogAnalyticsEntityTypeConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsLogGroupResponse> getLogAnalyticsLogGroup(GetLogAnalyticsLogGroupRequest request, AsyncHandler<GetLogAnalyticsLogGroupRequest, GetLogAnalyticsLogGroupResponse> handler) {
        LOG.trace("Called async getLogAnalyticsLogGroup");
        GetLogAnalyticsLogGroupRequest interceptedRequest = GetLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsLogGroupResponse> transformer = GetLogAnalyticsLogGroupConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsLogGroupRequest, GetLogAnalyticsLogGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsLogGroupRequest, GetLogAnalyticsLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsLogGroupsSummaryResponse> getLogAnalyticsLogGroupsSummary(GetLogAnalyticsLogGroupsSummaryRequest request, AsyncHandler<GetLogAnalyticsLogGroupsSummaryRequest, GetLogAnalyticsLogGroupsSummaryResponse> handler) {
        LOG.trace("Called async getLogAnalyticsLogGroupsSummary");
        GetLogAnalyticsLogGroupsSummaryRequest interceptedRequest = GetLogAnalyticsLogGroupsSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsLogGroupsSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsLogGroupsSummaryResponse> transformer = GetLogAnalyticsLogGroupsSummaryConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsLogGroupsSummaryRequest, GetLogAnalyticsLogGroupsSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsLogGroupsSummaryRequest, GetLogAnalyticsLogGroupsSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogAnalyticsObjectCollectionRuleResponse> getLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request, AsyncHandler<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> handler) {
        LOG.trace("Called async getLogAnalyticsObjectCollectionRule");
        GetLogAnalyticsObjectCollectionRuleRequest interceptedRequest = GetLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLogAnalyticsObjectCollectionRuleResponse> transformer = GetLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        AsyncHandler<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLookupResponse> getLookup(GetLookupRequest request, AsyncHandler<GetLookupRequest, GetLookupResponse> handler) {
        LOG.trace("Called async getLookup");
        GetLookupRequest interceptedRequest = GetLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLookupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetLookupResponse> transformer = GetLookupConverter.fromResponse();
        AsyncHandler<GetLookupRequest, GetLookupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLookupRequest, GetLookupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNamespaceResponse> getNamespace(GetNamespaceRequest request, AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handler) {
        LOG.trace("Called async getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNamespaceRequest, GetNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetParserResponse> getParser(GetParserRequest request, AsyncHandler<GetParserRequest, GetParserResponse> handler) {
        LOG.trace("Called async getParser");
        GetParserRequest interceptedRequest = GetParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetParserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetParserResponse> transformer = GetParserConverter.fromResponse();
        AsyncHandler<GetParserRequest, GetParserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetParserRequest, GetParserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetParserSummaryResponse> getParserSummary(GetParserSummaryRequest request, AsyncHandler<GetParserSummaryRequest, GetParserSummaryResponse> handler) {
        LOG.trace("Called async getParserSummary");
        GetParserSummaryRequest interceptedRequest = GetParserSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetParserSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetParserSummaryResponse> transformer = GetParserSummaryConverter.fromResponse();
        AsyncHandler<GetParserSummaryRequest, GetParserSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetParserSummaryRequest, GetParserSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetQueryResultResponse> getQueryResult(GetQueryResultRequest request, AsyncHandler<GetQueryResultRequest, GetQueryResultResponse> handler) {
        LOG.trace("Called async getQueryResult");
        GetQueryResultRequest interceptedRequest = GetQueryResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryResultConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetQueryResultResponse> transformer = GetQueryResultConverter.fromResponse();
        AsyncHandler<GetQueryResultRequest, GetQueryResultResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetQueryResultRequest, GetQueryResultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetQueryWorkRequestResponse> getQueryWorkRequest(GetQueryWorkRequestRequest request, AsyncHandler<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse> handler) {
        LOG.trace("Called async getQueryWorkRequest");
        GetQueryWorkRequestRequest interceptedRequest = GetQueryWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetQueryWorkRequestResponse> transformer = GetQueryWorkRequestConverter.fromResponse();
        AsyncHandler<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetScheduledTaskResponse> getScheduledTask(GetScheduledTaskRequest request, AsyncHandler<GetScheduledTaskRequest, GetScheduledTaskResponse> handler) {
        LOG.trace("Called async getScheduledTask");
        GetScheduledTaskRequest interceptedRequest = GetScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetScheduledTaskResponse> transformer = GetScheduledTaskConverter.fromResponse();
        AsyncHandler<GetScheduledTaskRequest, GetScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetScheduledTaskRequest, GetScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSourceResponse> getSource(GetSourceRequest request, AsyncHandler<GetSourceRequest, GetSourceResponse> handler) {
        LOG.trace("Called async getSource");
        GetSourceRequest interceptedRequest = GetSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetSourceResponse> transformer = GetSourceConverter.fromResponse();
        AsyncHandler<GetSourceRequest, GetSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSourceRequest, GetSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSourceSummaryResponse> getSourceSummary(GetSourceSummaryRequest request, AsyncHandler<GetSourceSummaryRequest, GetSourceSummaryResponse> handler) {
        LOG.trace("Called async getSourceSummary");
        GetSourceSummaryRequest interceptedRequest = GetSourceSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceSummaryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetSourceSummaryResponse> transformer = GetSourceSummaryConverter.fromResponse();
        AsyncHandler<GetSourceSummaryRequest, GetSourceSummaryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSourceSummaryRequest, GetSourceSummaryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStorageResponse> getStorage(GetStorageRequest request, AsyncHandler<GetStorageRequest, GetStorageResponse> handler) {
        LOG.trace("Called async getStorage");
        GetStorageRequest interceptedRequest = GetStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetStorageResponse> transformer = GetStorageConverter.fromResponse();
        AsyncHandler<GetStorageRequest, GetStorageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStorageRequest, GetStorageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStorageUsageResponse> getStorageUsage(GetStorageUsageRequest request, AsyncHandler<GetStorageUsageRequest, GetStorageUsageResponse> handler) {
        LOG.trace("Called async getStorageUsage");
        GetStorageUsageRequest interceptedRequest = GetStorageUsageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageUsageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetStorageUsageResponse> transformer = GetStorageUsageConverter.fromResponse();
        AsyncHandler<GetStorageUsageRequest, GetStorageUsageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStorageUsageRequest, GetStorageUsageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStorageWorkRequestResponse> getStorageWorkRequest(GetStorageWorkRequestRequest request, AsyncHandler<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse> handler) {
        LOG.trace("Called async getStorageWorkRequest");
        GetStorageWorkRequestRequest interceptedRequest = GetStorageWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetStorageWorkRequestResponse> transformer = GetStorageWorkRequestConverter.fromResponse();
        AsyncHandler<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUploadResponse> getUpload(GetUploadRequest request, AsyncHandler<GetUploadRequest, GetUploadResponse> handler) {
        LOG.trace("Called async getUpload");
        GetUploadRequest interceptedRequest = GetUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUploadConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetUploadResponse> transformer = GetUploadConverter.fromResponse();
        AsyncHandler<GetUploadRequest, GetUploadResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUploadRequest, GetUploadResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ImportCustomContentResponse> importCustomContent(ImportCustomContentRequest request, AsyncHandler<ImportCustomContentRequest, ImportCustomContentResponse> handler) {
        LOG.trace("Called async importCustomContent");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (ImportCustomContentRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)ImportCustomContentRequest.builder());
        }
        final ImportCustomContentRequest interceptedRequest = ImportCustomContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportCustomContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ImportCustomContentResponse> transformer = ImportCustomContentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ImportCustomContentRequest, ImportCustomContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getImportCustomContentFileBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAssociatedEntitiesResponse> listAssociatedEntities(ListAssociatedEntitiesRequest request, AsyncHandler<ListAssociatedEntitiesRequest, ListAssociatedEntitiesResponse> handler) {
        LOG.trace("Called async listAssociatedEntities");
        ListAssociatedEntitiesRequest interceptedRequest = ListAssociatedEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAssociatedEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAssociatedEntitiesResponse> transformer = ListAssociatedEntitiesConverter.fromResponse();
        AsyncHandler<ListAssociatedEntitiesRequest, ListAssociatedEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAssociatedEntitiesRequest, ListAssociatedEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConfigWorkRequestsResponse> listConfigWorkRequests(ListConfigWorkRequestsRequest request, AsyncHandler<ListConfigWorkRequestsRequest, ListConfigWorkRequestsResponse> handler) {
        LOG.trace("Called async listConfigWorkRequests");
        ListConfigWorkRequestsRequest interceptedRequest = ListConfigWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConfigWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConfigWorkRequestsResponse> transformer = ListConfigWorkRequestsConverter.fromResponse();
        AsyncHandler<ListConfigWorkRequestsRequest, ListConfigWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConfigWorkRequestsRequest, ListConfigWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEntityAssociationsResponse> listEntityAssociations(ListEntityAssociationsRequest request, AsyncHandler<ListEntityAssociationsRequest, ListEntityAssociationsResponse> handler) {
        LOG.trace("Called async listEntityAssociations");
        ListEntityAssociationsRequest interceptedRequest = ListEntityAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntityAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListEntityAssociationsResponse> transformer = ListEntityAssociationsConverter.fromResponse();
        AsyncHandler<ListEntityAssociationsRequest, ListEntityAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEntityAssociationsRequest, ListEntityAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEntitySourceAssociationsResponse> listEntitySourceAssociations(ListEntitySourceAssociationsRequest request, AsyncHandler<ListEntitySourceAssociationsRequest, ListEntitySourceAssociationsResponse> handler) {
        LOG.trace("Called async listEntitySourceAssociations");
        ListEntitySourceAssociationsRequest interceptedRequest = ListEntitySourceAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntitySourceAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListEntitySourceAssociationsResponse> transformer = ListEntitySourceAssociationsConverter.fromResponse();
        AsyncHandler<ListEntitySourceAssociationsRequest, ListEntitySourceAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEntitySourceAssociationsRequest, ListEntitySourceAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFieldsResponse> listFields(ListFieldsRequest request, AsyncHandler<ListFieldsRequest, ListFieldsResponse> handler) {
        LOG.trace("Called async listFields");
        ListFieldsRequest interceptedRequest = ListFieldsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFieldsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListFieldsResponse> transformer = ListFieldsConverter.fromResponse();
        AsyncHandler<ListFieldsRequest, ListFieldsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFieldsRequest, ListFieldsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLabelPrioritiesResponse> listLabelPriorities(ListLabelPrioritiesRequest request, AsyncHandler<ListLabelPrioritiesRequest, ListLabelPrioritiesResponse> handler) {
        LOG.trace("Called async listLabelPriorities");
        ListLabelPrioritiesRequest interceptedRequest = ListLabelPrioritiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelPrioritiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLabelPrioritiesResponse> transformer = ListLabelPrioritiesConverter.fromResponse();
        AsyncHandler<ListLabelPrioritiesRequest, ListLabelPrioritiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLabelPrioritiesRequest, ListLabelPrioritiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLabelSourceDetailsResponse> listLabelSourceDetails(ListLabelSourceDetailsRequest request, AsyncHandler<ListLabelSourceDetailsRequest, ListLabelSourceDetailsResponse> handler) {
        LOG.trace("Called async listLabelSourceDetails");
        ListLabelSourceDetailsRequest interceptedRequest = ListLabelSourceDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelSourceDetailsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLabelSourceDetailsResponse> transformer = ListLabelSourceDetailsConverter.fromResponse();
        AsyncHandler<ListLabelSourceDetailsRequest, ListLabelSourceDetailsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLabelSourceDetailsRequest, ListLabelSourceDetailsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLabelsResponse> listLabels(ListLabelsRequest request, AsyncHandler<ListLabelsRequest, ListLabelsResponse> handler) {
        LOG.trace("Called async listLabels");
        ListLabelsRequest interceptedRequest = ListLabelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLabelsResponse> transformer = ListLabelsConverter.fromResponse();
        AsyncHandler<ListLabelsRequest, ListLabelsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLabelsRequest, ListLabelsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogAnalyticsEntitiesResponse> listLogAnalyticsEntities(ListLogAnalyticsEntitiesRequest request, AsyncHandler<ListLogAnalyticsEntitiesRequest, ListLogAnalyticsEntitiesResponse> handler) {
        LOG.trace("Called async listLogAnalyticsEntities");
        ListLogAnalyticsEntitiesRequest interceptedRequest = ListLogAnalyticsEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLogAnalyticsEntitiesResponse> transformer = ListLogAnalyticsEntitiesConverter.fromResponse();
        AsyncHandler<ListLogAnalyticsEntitiesRequest, ListLogAnalyticsEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogAnalyticsEntitiesRequest, ListLogAnalyticsEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogAnalyticsEntityTypesResponse> listLogAnalyticsEntityTypes(ListLogAnalyticsEntityTypesRequest request, AsyncHandler<ListLogAnalyticsEntityTypesRequest, ListLogAnalyticsEntityTypesResponse> handler) {
        LOG.trace("Called async listLogAnalyticsEntityTypes");
        ListLogAnalyticsEntityTypesRequest interceptedRequest = ListLogAnalyticsEntityTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsEntityTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLogAnalyticsEntityTypesResponse> transformer = ListLogAnalyticsEntityTypesConverter.fromResponse();
        AsyncHandler<ListLogAnalyticsEntityTypesRequest, ListLogAnalyticsEntityTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogAnalyticsEntityTypesRequest, ListLogAnalyticsEntityTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogAnalyticsLogGroupsResponse> listLogAnalyticsLogGroups(ListLogAnalyticsLogGroupsRequest request, AsyncHandler<ListLogAnalyticsLogGroupsRequest, ListLogAnalyticsLogGroupsResponse> handler) {
        LOG.trace("Called async listLogAnalyticsLogGroups");
        ListLogAnalyticsLogGroupsRequest interceptedRequest = ListLogAnalyticsLogGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsLogGroupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLogAnalyticsLogGroupsResponse> transformer = ListLogAnalyticsLogGroupsConverter.fromResponse();
        AsyncHandler<ListLogAnalyticsLogGroupsRequest, ListLogAnalyticsLogGroupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogAnalyticsLogGroupsRequest, ListLogAnalyticsLogGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogAnalyticsObjectCollectionRulesResponse> listLogAnalyticsObjectCollectionRules(ListLogAnalyticsObjectCollectionRulesRequest request, AsyncHandler<ListLogAnalyticsObjectCollectionRulesRequest, ListLogAnalyticsObjectCollectionRulesResponse> handler) {
        LOG.trace("Called async listLogAnalyticsObjectCollectionRules");
        ListLogAnalyticsObjectCollectionRulesRequest interceptedRequest = ListLogAnalyticsObjectCollectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsObjectCollectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLogAnalyticsObjectCollectionRulesResponse> transformer = ListLogAnalyticsObjectCollectionRulesConverter.fromResponse();
        AsyncHandler<ListLogAnalyticsObjectCollectionRulesRequest, ListLogAnalyticsObjectCollectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogAnalyticsObjectCollectionRulesRequest, ListLogAnalyticsObjectCollectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLookupsResponse> listLookups(ListLookupsRequest request, AsyncHandler<ListLookupsRequest, ListLookupsResponse> handler) {
        LOG.trace("Called async listLookups");
        ListLookupsRequest interceptedRequest = ListLookupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLookupsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListLookupsResponse> transformer = ListLookupsConverter.fromResponse();
        AsyncHandler<ListLookupsRequest, ListLookupsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLookupsRequest, ListLookupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMetaSourceTypesResponse> listMetaSourceTypes(ListMetaSourceTypesRequest request, AsyncHandler<ListMetaSourceTypesRequest, ListMetaSourceTypesResponse> handler) {
        LOG.trace("Called async listMetaSourceTypes");
        ListMetaSourceTypesRequest interceptedRequest = ListMetaSourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMetaSourceTypesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListMetaSourceTypesResponse> transformer = ListMetaSourceTypesConverter.fromResponse();
        AsyncHandler<ListMetaSourceTypesRequest, ListMetaSourceTypesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMetaSourceTypesRequest, ListMetaSourceTypesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNamespacesResponse> listNamespaces(ListNamespacesRequest request, AsyncHandler<ListNamespacesRequest, ListNamespacesResponse> handler) {
        LOG.trace("Called async listNamespaces");
        ListNamespacesRequest interceptedRequest = ListNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNamespacesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListNamespacesResponse> transformer = ListNamespacesConverter.fromResponse();
        AsyncHandler<ListNamespacesRequest, ListNamespacesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNamespacesRequest, ListNamespacesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListParserFunctionsResponse> listParserFunctions(ListParserFunctionsRequest request, AsyncHandler<ListParserFunctionsRequest, ListParserFunctionsResponse> handler) {
        LOG.trace("Called async listParserFunctions");
        ListParserFunctionsRequest interceptedRequest = ListParserFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParserFunctionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListParserFunctionsResponse> transformer = ListParserFunctionsConverter.fromResponse();
        AsyncHandler<ListParserFunctionsRequest, ListParserFunctionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListParserFunctionsRequest, ListParserFunctionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListParserMetaPluginsResponse> listParserMetaPlugins(ListParserMetaPluginsRequest request, AsyncHandler<ListParserMetaPluginsRequest, ListParserMetaPluginsResponse> handler) {
        LOG.trace("Called async listParserMetaPlugins");
        ListParserMetaPluginsRequest interceptedRequest = ListParserMetaPluginsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParserMetaPluginsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListParserMetaPluginsResponse> transformer = ListParserMetaPluginsConverter.fromResponse();
        AsyncHandler<ListParserMetaPluginsRequest, ListParserMetaPluginsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListParserMetaPluginsRequest, ListParserMetaPluginsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListParsersResponse> listParsers(ListParsersRequest request, AsyncHandler<ListParsersRequest, ListParsersResponse> handler) {
        LOG.trace("Called async listParsers");
        ListParsersRequest interceptedRequest = ListParsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParsersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListParsersResponse> transformer = ListParsersConverter.fromResponse();
        AsyncHandler<ListParsersRequest, ListParsersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListParsersRequest, ListParsersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListQueryWorkRequestsResponse> listQueryWorkRequests(ListQueryWorkRequestsRequest request, AsyncHandler<ListQueryWorkRequestsRequest, ListQueryWorkRequestsResponse> handler) {
        LOG.trace("Called async listQueryWorkRequests");
        ListQueryWorkRequestsRequest interceptedRequest = ListQueryWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListQueryWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListQueryWorkRequestsResponse> transformer = ListQueryWorkRequestsConverter.fromResponse();
        AsyncHandler<ListQueryWorkRequestsRequest, ListQueryWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListQueryWorkRequestsRequest, ListQueryWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecalledDataResponse> listRecalledData(ListRecalledDataRequest request, AsyncHandler<ListRecalledDataRequest, ListRecalledDataResponse> handler) {
        LOG.trace("Called async listRecalledData");
        ListRecalledDataRequest interceptedRequest = ListRecalledDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecalledDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRecalledDataResponse> transformer = ListRecalledDataConverter.fromResponse();
        AsyncHandler<ListRecalledDataRequest, ListRecalledDataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecalledDataRequest, ListRecalledDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListScheduledTasksResponse> listScheduledTasks(ListScheduledTasksRequest request, AsyncHandler<ListScheduledTasksRequest, ListScheduledTasksResponse> handler) {
        LOG.trace("Called async listScheduledTasks");
        ListScheduledTasksRequest interceptedRequest = ListScheduledTasksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledTasksConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListScheduledTasksResponse> transformer = ListScheduledTasksConverter.fromResponse();
        AsyncHandler<ListScheduledTasksRequest, ListScheduledTasksResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListScheduledTasksRequest, ListScheduledTasksResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourceAssociationsResponse> listSourceAssociations(ListSourceAssociationsRequest request, AsyncHandler<ListSourceAssociationsRequest, ListSourceAssociationsResponse> handler) {
        LOG.trace("Called async listSourceAssociations");
        ListSourceAssociationsRequest interceptedRequest = ListSourceAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourceAssociationsResponse> transformer = ListSourceAssociationsConverter.fromResponse();
        AsyncHandler<ListSourceAssociationsRequest, ListSourceAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourceAssociationsRequest, ListSourceAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourceExtendedFieldDefinitionsResponse> listSourceExtendedFieldDefinitions(ListSourceExtendedFieldDefinitionsRequest request, AsyncHandler<ListSourceExtendedFieldDefinitionsRequest, ListSourceExtendedFieldDefinitionsResponse> handler) {
        LOG.trace("Called async listSourceExtendedFieldDefinitions");
        ListSourceExtendedFieldDefinitionsRequest interceptedRequest = ListSourceExtendedFieldDefinitionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceExtendedFieldDefinitionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourceExtendedFieldDefinitionsResponse> transformer = ListSourceExtendedFieldDefinitionsConverter.fromResponse();
        AsyncHandler<ListSourceExtendedFieldDefinitionsRequest, ListSourceExtendedFieldDefinitionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourceExtendedFieldDefinitionsRequest, ListSourceExtendedFieldDefinitionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourceLabelOperatorsResponse> listSourceLabelOperators(ListSourceLabelOperatorsRequest request, AsyncHandler<ListSourceLabelOperatorsRequest, ListSourceLabelOperatorsResponse> handler) {
        LOG.trace("Called async listSourceLabelOperators");
        ListSourceLabelOperatorsRequest interceptedRequest = ListSourceLabelOperatorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceLabelOperatorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourceLabelOperatorsResponse> transformer = ListSourceLabelOperatorsConverter.fromResponse();
        AsyncHandler<ListSourceLabelOperatorsRequest, ListSourceLabelOperatorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourceLabelOperatorsRequest, ListSourceLabelOperatorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourceMetaFunctionsResponse> listSourceMetaFunctions(ListSourceMetaFunctionsRequest request, AsyncHandler<ListSourceMetaFunctionsRequest, ListSourceMetaFunctionsResponse> handler) {
        LOG.trace("Called async listSourceMetaFunctions");
        ListSourceMetaFunctionsRequest interceptedRequest = ListSourceMetaFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceMetaFunctionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourceMetaFunctionsResponse> transformer = ListSourceMetaFunctionsConverter.fromResponse();
        AsyncHandler<ListSourceMetaFunctionsRequest, ListSourceMetaFunctionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourceMetaFunctionsRequest, ListSourceMetaFunctionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourcePatternsResponse> listSourcePatterns(ListSourcePatternsRequest request, AsyncHandler<ListSourcePatternsRequest, ListSourcePatternsResponse> handler) {
        LOG.trace("Called async listSourcePatterns");
        ListSourcePatternsRequest interceptedRequest = ListSourcePatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcePatternsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourcePatternsResponse> transformer = ListSourcePatternsConverter.fromResponse();
        AsyncHandler<ListSourcePatternsRequest, ListSourcePatternsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourcePatternsRequest, ListSourcePatternsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSourcesResponse> listSources(ListSourcesRequest request, AsyncHandler<ListSourcesRequest, ListSourcesResponse> handler) {
        LOG.trace("Called async listSources");
        ListSourcesRequest interceptedRequest = ListSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSourcesResponse> transformer = ListSourcesConverter.fromResponse();
        AsyncHandler<ListSourcesRequest, ListSourcesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSourcesRequest, ListSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStorageWorkRequestErrorsResponse> listStorageWorkRequestErrors(ListStorageWorkRequestErrorsRequest request, AsyncHandler<ListStorageWorkRequestErrorsRequest, ListStorageWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listStorageWorkRequestErrors");
        ListStorageWorkRequestErrorsRequest interceptedRequest = ListStorageWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStorageWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListStorageWorkRequestErrorsResponse> transformer = ListStorageWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListStorageWorkRequestErrorsRequest, ListStorageWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStorageWorkRequestErrorsRequest, ListStorageWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStorageWorkRequestsResponse> listStorageWorkRequests(ListStorageWorkRequestsRequest request, AsyncHandler<ListStorageWorkRequestsRequest, ListStorageWorkRequestsResponse> handler) {
        LOG.trace("Called async listStorageWorkRequests");
        ListStorageWorkRequestsRequest interceptedRequest = ListStorageWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStorageWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListStorageWorkRequestsResponse> transformer = ListStorageWorkRequestsConverter.fromResponse();
        AsyncHandler<ListStorageWorkRequestsRequest, ListStorageWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStorageWorkRequestsRequest, ListStorageWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSupportedCharEncodingsResponse> listSupportedCharEncodings(ListSupportedCharEncodingsRequest request, AsyncHandler<ListSupportedCharEncodingsRequest, ListSupportedCharEncodingsResponse> handler) {
        LOG.trace("Called async listSupportedCharEncodings");
        ListSupportedCharEncodingsRequest interceptedRequest = ListSupportedCharEncodingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSupportedCharEncodingsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSupportedCharEncodingsResponse> transformer = ListSupportedCharEncodingsConverter.fromResponse();
        AsyncHandler<ListSupportedCharEncodingsRequest, ListSupportedCharEncodingsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSupportedCharEncodingsRequest, ListSupportedCharEncodingsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSupportedTimezonesResponse> listSupportedTimezones(ListSupportedTimezonesRequest request, AsyncHandler<ListSupportedTimezonesRequest, ListSupportedTimezonesResponse> handler) {
        LOG.trace("Called async listSupportedTimezones");
        ListSupportedTimezonesRequest interceptedRequest = ListSupportedTimezonesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSupportedTimezonesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSupportedTimezonesResponse> transformer = ListSupportedTimezonesConverter.fromResponse();
        AsyncHandler<ListSupportedTimezonesRequest, ListSupportedTimezonesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSupportedTimezonesRequest, ListSupportedTimezonesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUploadFilesResponse> listUploadFiles(ListUploadFilesRequest request, AsyncHandler<ListUploadFilesRequest, ListUploadFilesResponse> handler) {
        LOG.trace("Called async listUploadFiles");
        ListUploadFilesRequest interceptedRequest = ListUploadFilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadFilesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListUploadFilesResponse> transformer = ListUploadFilesConverter.fromResponse();
        AsyncHandler<ListUploadFilesRequest, ListUploadFilesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUploadFilesRequest, ListUploadFilesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUploadWarningsResponse> listUploadWarnings(ListUploadWarningsRequest request, AsyncHandler<ListUploadWarningsRequest, ListUploadWarningsResponse> handler) {
        LOG.trace("Called async listUploadWarnings");
        ListUploadWarningsRequest interceptedRequest = ListUploadWarningsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadWarningsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListUploadWarningsResponse> transformer = ListUploadWarningsConverter.fromResponse();
        AsyncHandler<ListUploadWarningsRequest, ListUploadWarningsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUploadWarningsRequest, ListUploadWarningsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUploadsResponse> listUploads(ListUploadsRequest request, AsyncHandler<ListUploadsRequest, ListUploadsResponse> handler) {
        LOG.trace("Called async listUploads");
        ListUploadsRequest interceptedRequest = ListUploadsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListUploadsResponse> transformer = ListUploadsConverter.fromResponse();
        AsyncHandler<ListUploadsRequest, ListUploadsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUploadsRequest, ListUploadsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWarningsResponse> listWarnings(ListWarningsRequest request, AsyncHandler<ListWarningsRequest, ListWarningsResponse> handler) {
        LOG.trace("Called async listWarnings");
        ListWarningsRequest interceptedRequest = ListWarningsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWarningsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWarningsResponse> transformer = ListWarningsConverter.fromResponse();
        AsyncHandler<ListWarningsRequest, ListWarningsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWarningsRequest, ListWarningsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<OffboardNamespaceResponse> offboardNamespace(OffboardNamespaceRequest request, AsyncHandler<OffboardNamespaceRequest, OffboardNamespaceResponse> handler) {
        LOG.trace("Called async offboardNamespace");
        OffboardNamespaceRequest interceptedRequest = OffboardNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = OffboardNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, OffboardNamespaceResponse> transformer = OffboardNamespaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<OffboardNamespaceRequest, OffboardNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<OffboardNamespaceRequest, OffboardNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<OnboardNamespaceResponse> onboardNamespace(OnboardNamespaceRequest request, AsyncHandler<OnboardNamespaceRequest, OnboardNamespaceResponse> handler) {
        LOG.trace("Called async onboardNamespace");
        OnboardNamespaceRequest interceptedRequest = OnboardNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = OnboardNamespaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, OnboardNamespaceResponse> transformer = OnboardNamespaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<OnboardNamespaceRequest, OnboardNamespaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<OnboardNamespaceRequest, OnboardNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ParseQueryResponse> parseQuery(ParseQueryRequest request, AsyncHandler<ParseQueryRequest, ParseQueryResponse> handler) {
        LOG.trace("Called async parseQuery");
        ParseQueryRequest interceptedRequest = ParseQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ParseQueryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ParseQueryResponse> transformer = ParseQueryConverter.fromResponse();
        AsyncHandler<ParseQueryRequest, ParseQueryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ParseQueryRequest, ParseQueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PauseScheduledTaskResponse> pauseScheduledTask(PauseScheduledTaskRequest request, AsyncHandler<PauseScheduledTaskRequest, PauseScheduledTaskResponse> handler) {
        LOG.trace("Called async pauseScheduledTask");
        PauseScheduledTaskRequest interceptedRequest = PauseScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PauseScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PauseScheduledTaskResponse> transformer = PauseScheduledTaskConverter.fromResponse();
        AsyncHandler<PauseScheduledTaskRequest, PauseScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PauseScheduledTaskRequest, PauseScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PurgeStorageDataResponse> purgeStorageData(PurgeStorageDataRequest request, AsyncHandler<PurgeStorageDataRequest, PurgeStorageDataResponse> handler) {
        LOG.trace("Called async purgeStorageData");
        PurgeStorageDataRequest interceptedRequest = PurgeStorageDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PurgeStorageDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PurgeStorageDataResponse> transformer = PurgeStorageDataConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<PurgeStorageDataRequest, PurgeStorageDataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PurgeStorageDataRequest, PurgeStorageDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PutQueryWorkRequestBackgroundResponse> putQueryWorkRequestBackground(PutQueryWorkRequestBackgroundRequest request, AsyncHandler<PutQueryWorkRequestBackgroundRequest, PutQueryWorkRequestBackgroundResponse> handler) {
        LOG.trace("Called async putQueryWorkRequestBackground");
        PutQueryWorkRequestBackgroundRequest interceptedRequest = PutQueryWorkRequestBackgroundConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutQueryWorkRequestBackgroundConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PutQueryWorkRequestBackgroundResponse> transformer = PutQueryWorkRequestBackgroundConverter.fromResponse();
        AsyncHandler<PutQueryWorkRequestBackgroundRequest, PutQueryWorkRequestBackgroundResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PutQueryWorkRequestBackgroundRequest, PutQueryWorkRequestBackgroundResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<QueryResponse> query(QueryRequest request, AsyncHandler<QueryRequest, QueryResponse> handler) {
        LOG.trace("Called async query");
        QueryRequest interceptedRequest = QueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = QueryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, QueryResponse> transformer = QueryConverter.fromResponse();
        AsyncHandler<QueryRequest, QueryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<QueryRequest, QueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RecallArchivedDataResponse> recallArchivedData(RecallArchivedDataRequest request, AsyncHandler<RecallArchivedDataRequest, RecallArchivedDataResponse> handler) {
        LOG.trace("Called async recallArchivedData");
        RecallArchivedDataRequest interceptedRequest = RecallArchivedDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecallArchivedDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RecallArchivedDataResponse> transformer = RecallArchivedDataConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RecallArchivedDataRequest, RecallArchivedDataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RecallArchivedDataRequest, RecallArchivedDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RegisterLookupResponse> registerLookup(RegisterLookupRequest request, AsyncHandler<RegisterLookupRequest, RegisterLookupResponse> handler) {
        LOG.trace("Called async registerLookup");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (RegisterLookupRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)RegisterLookupRequest.builder());
        }
        final RegisterLookupRequest interceptedRequest = RegisterLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RegisterLookupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RegisterLookupResponse> transformer = RegisterLookupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RegisterLookupRequest, RegisterLookupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getRegisterLookupContentFileBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ReleaseRecalledDataResponse> releaseRecalledData(ReleaseRecalledDataRequest request, AsyncHandler<ReleaseRecalledDataRequest, ReleaseRecalledDataResponse> handler) {
        LOG.trace("Called async releaseRecalledData");
        ReleaseRecalledDataRequest interceptedRequest = ReleaseRecalledDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReleaseRecalledDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ReleaseRecalledDataResponse> transformer = ReleaseRecalledDataConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ReleaseRecalledDataRequest, ReleaseRecalledDataResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ReleaseRecalledDataRequest, ReleaseRecalledDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveEntityAssociationsResponse> removeEntityAssociations(RemoveEntityAssociationsRequest request, AsyncHandler<RemoveEntityAssociationsRequest, RemoveEntityAssociationsResponse> handler) {
        LOG.trace("Called async removeEntityAssociations");
        RemoveEntityAssociationsRequest interceptedRequest = RemoveEntityAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveEntityAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RemoveEntityAssociationsResponse> transformer = RemoveEntityAssociationsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveEntityAssociationsRequest, RemoveEntityAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveEntityAssociationsRequest, RemoveEntityAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ResumeScheduledTaskResponse> resumeScheduledTask(ResumeScheduledTaskRequest request, AsyncHandler<ResumeScheduledTaskRequest, ResumeScheduledTaskResponse> handler) {
        LOG.trace("Called async resumeScheduledTask");
        ResumeScheduledTaskRequest interceptedRequest = ResumeScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResumeScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ResumeScheduledTaskResponse> transformer = ResumeScheduledTaskConverter.fromResponse();
        AsyncHandler<ResumeScheduledTaskRequest, ResumeScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ResumeScheduledTaskRequest, ResumeScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RunResponse> run(RunRequest request, AsyncHandler<RunRequest, RunResponse> handler) {
        LOG.trace("Called async run");
        RunRequest interceptedRequest = RunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, RunResponse> transformer = RunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RunRequest, RunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RunRequest, RunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SuggestResponse> suggest(SuggestRequest request, AsyncHandler<SuggestRequest, SuggestResponse> handler) {
        LOG.trace("Called async suggest");
        SuggestRequest interceptedRequest = SuggestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SuggestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, SuggestResponse> transformer = SuggestConverter.fromResponse();
        AsyncHandler<SuggestRequest, SuggestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SuggestRequest, SuggestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SuppressWarningResponse> suppressWarning(SuppressWarningRequest request, AsyncHandler<SuppressWarningRequest, SuppressWarningResponse> handler) {
        LOG.trace("Called async suppressWarning");
        SuppressWarningRequest interceptedRequest = SuppressWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SuppressWarningConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, SuppressWarningResponse> transformer = SuppressWarningConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<SuppressWarningRequest, SuppressWarningResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SuppressWarningRequest, SuppressWarningResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<TestParserResponse> testParser(TestParserRequest request, AsyncHandler<TestParserRequest, TestParserResponse> handler) {
        LOG.trace("Called async testParser");
        TestParserRequest interceptedRequest = TestParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TestParserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, TestParserResponse> transformer = TestParserConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<TestParserRequest, TestParserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<TestParserRequest, TestParserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UnsuppressWarningResponse> unsuppressWarning(UnsuppressWarningRequest request, AsyncHandler<UnsuppressWarningRequest, UnsuppressWarningResponse> handler) {
        LOG.trace("Called async unsuppressWarning");
        UnsuppressWarningRequest interceptedRequest = UnsuppressWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UnsuppressWarningConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UnsuppressWarningResponse> transformer = UnsuppressWarningConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UnsuppressWarningRequest, UnsuppressWarningResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UnsuppressWarningRequest, UnsuppressWarningResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogAnalyticsEntityResponse> updateLogAnalyticsEntity(UpdateLogAnalyticsEntityRequest request, AsyncHandler<UpdateLogAnalyticsEntityRequest, UpdateLogAnalyticsEntityResponse> handler) {
        LOG.trace("Called async updateLogAnalyticsEntity");
        UpdateLogAnalyticsEntityRequest interceptedRequest = UpdateLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLogAnalyticsEntityResponse> transformer = UpdateLogAnalyticsEntityConverter.fromResponse();
        AsyncHandler<UpdateLogAnalyticsEntityRequest, UpdateLogAnalyticsEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogAnalyticsEntityRequest, UpdateLogAnalyticsEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogAnalyticsEntityTypeResponse> updateLogAnalyticsEntityType(UpdateLogAnalyticsEntityTypeRequest request, AsyncHandler<UpdateLogAnalyticsEntityTypeRequest, UpdateLogAnalyticsEntityTypeResponse> handler) {
        LOG.trace("Called async updateLogAnalyticsEntityType");
        UpdateLogAnalyticsEntityTypeRequest interceptedRequest = UpdateLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLogAnalyticsEntityTypeResponse> transformer = UpdateLogAnalyticsEntityTypeConverter.fromResponse();
        AsyncHandler<UpdateLogAnalyticsEntityTypeRequest, UpdateLogAnalyticsEntityTypeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogAnalyticsEntityTypeRequest, UpdateLogAnalyticsEntityTypeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogAnalyticsLogGroupResponse> updateLogAnalyticsLogGroup(UpdateLogAnalyticsLogGroupRequest request, AsyncHandler<UpdateLogAnalyticsLogGroupRequest, UpdateLogAnalyticsLogGroupResponse> handler) {
        LOG.trace("Called async updateLogAnalyticsLogGroup");
        UpdateLogAnalyticsLogGroupRequest interceptedRequest = UpdateLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLogAnalyticsLogGroupResponse> transformer = UpdateLogAnalyticsLogGroupConverter.fromResponse();
        AsyncHandler<UpdateLogAnalyticsLogGroupRequest, UpdateLogAnalyticsLogGroupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogAnalyticsLogGroupRequest, UpdateLogAnalyticsLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogAnalyticsObjectCollectionRuleResponse> updateLogAnalyticsObjectCollectionRule(UpdateLogAnalyticsObjectCollectionRuleRequest request, AsyncHandler<UpdateLogAnalyticsObjectCollectionRuleRequest, UpdateLogAnalyticsObjectCollectionRuleResponse> handler) {
        LOG.trace("Called async updateLogAnalyticsObjectCollectionRule");
        UpdateLogAnalyticsObjectCollectionRuleRequest interceptedRequest = UpdateLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLogAnalyticsObjectCollectionRuleResponse> transformer = UpdateLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        AsyncHandler<UpdateLogAnalyticsObjectCollectionRuleRequest, UpdateLogAnalyticsObjectCollectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogAnalyticsObjectCollectionRuleRequest, UpdateLogAnalyticsObjectCollectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLookupResponse> updateLookup(UpdateLookupRequest request, AsyncHandler<UpdateLookupRequest, UpdateLookupResponse> handler) {
        LOG.trace("Called async updateLookup");
        UpdateLookupRequest interceptedRequest = UpdateLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLookupConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLookupResponse> transformer = UpdateLookupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateLookupRequest, UpdateLookupResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLookupRequest, UpdateLookupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLookupDataResponse> updateLookupData(UpdateLookupDataRequest request, AsyncHandler<UpdateLookupDataRequest, UpdateLookupDataResponse> handler) {
        LOG.trace("Called async updateLookupData");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (UpdateLookupDataRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UpdateLookupDataRequest.builder());
        }
        final UpdateLookupDataRequest interceptedRequest = UpdateLookupDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLookupDataConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateLookupDataResponse> transformer = UpdateLookupDataConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLookupDataRequest, UpdateLookupDataResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUpdateLookupFileBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateScheduledTaskResponse> updateScheduledTask(UpdateScheduledTaskRequest request, AsyncHandler<UpdateScheduledTaskRequest, UpdateScheduledTaskResponse> handler) {
        LOG.trace("Called async updateScheduledTask");
        UpdateScheduledTaskRequest interceptedRequest = UpdateScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateScheduledTaskResponse> transformer = UpdateScheduledTaskConverter.fromResponse();
        AsyncHandler<UpdateScheduledTaskRequest, UpdateScheduledTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateScheduledTaskRequest, UpdateScheduledTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStorageResponse> updateStorage(UpdateStorageRequest request, AsyncHandler<UpdateStorageRequest, UpdateStorageResponse> handler) {
        LOG.trace("Called async updateStorage");
        UpdateStorageRequest interceptedRequest = UpdateStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStorageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateStorageResponse> transformer = UpdateStorageConverter.fromResponse();
        AsyncHandler<UpdateStorageRequest, UpdateStorageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStorageRequest, UpdateStorageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UploadLogFileResponse> uploadLogFile(UploadLogFileRequest request, AsyncHandler<UploadLogFileRequest, UploadLogFileResponse> handler) {
        LOG.trace("Called async uploadLogFile");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (UploadLogFileRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UploadLogFileRequest.builder());
        }
        final UploadLogFileRequest interceptedRequest = UploadLogFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadLogFileConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UploadLogFileResponse> transformer = UploadLogFileConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UploadLogFileRequest, UploadLogFileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUploadLogFileBody(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpsertAssociationsResponse> upsertAssociations(UpsertAssociationsRequest request, AsyncHandler<UpsertAssociationsRequest, UpsertAssociationsResponse> handler) {
        LOG.trace("Called async upsertAssociations");
        UpsertAssociationsRequest interceptedRequest = UpsertAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertAssociationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpsertAssociationsResponse> transformer = UpsertAssociationsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpsertAssociationsRequest, UpsertAssociationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpsertAssociationsRequest, UpsertAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpsertFieldResponse> upsertField(UpsertFieldRequest request, AsyncHandler<UpsertFieldRequest, UpsertFieldResponse> handler) {
        LOG.trace("Called async upsertField");
        UpsertFieldRequest interceptedRequest = UpsertFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertFieldConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpsertFieldResponse> transformer = UpsertFieldConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpsertFieldRequest, UpsertFieldResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpsertFieldRequest, UpsertFieldResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpsertLabelResponse> upsertLabel(UpsertLabelRequest request, AsyncHandler<UpsertLabelRequest, UpsertLabelResponse> handler) {
        LOG.trace("Called async upsertLabel");
        UpsertLabelRequest interceptedRequest = UpsertLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertLabelConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpsertLabelResponse> transformer = UpsertLabelConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpsertLabelRequest, UpsertLabelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpsertLabelRequest, UpsertLabelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpsertParserResponse> upsertParser(UpsertParserRequest request, AsyncHandler<UpsertParserRequest, UpsertParserResponse> handler) {
        LOG.trace("Called async upsertParser");
        UpsertParserRequest interceptedRequest = UpsertParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertParserConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpsertParserResponse> transformer = UpsertParserConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpsertParserRequest, UpsertParserResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpsertParserRequest, UpsertParserResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpsertSourceResponse> upsertSource(UpsertSourceRequest request, AsyncHandler<UpsertSourceRequest, UpsertSourceResponse> handler) {
        LOG.trace("Called async upsertSource");
        UpsertSourceRequest interceptedRequest = UpsertSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpsertSourceResponse> transformer = UpsertSourceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpsertSourceRequest, UpsertSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpsertSourceRequest, UpsertSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateAssociationParametersResponse> validateAssociationParameters(ValidateAssociationParametersRequest request, AsyncHandler<ValidateAssociationParametersRequest, ValidateAssociationParametersResponse> handler) {
        LOG.trace("Called async validateAssociationParameters");
        ValidateAssociationParametersRequest interceptedRequest = ValidateAssociationParametersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateAssociationParametersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateAssociationParametersResponse> transformer = ValidateAssociationParametersConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ValidateAssociationParametersRequest, ValidateAssociationParametersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateAssociationParametersRequest, ValidateAssociationParametersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateFileResponse> validateFile(ValidateFileRequest request, AsyncHandler<ValidateFileRequest, ValidateFileResponse> handler) {
        LOG.trace("Called async validateFile");
        ValidateFileRequest interceptedRequest = ValidateFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateFileConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateFileResponse> transformer = ValidateFileConverter.fromResponse();
        AsyncHandler<ValidateFileRequest, ValidateFileResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateFileRequest, ValidateFileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateSourceResponse> validateSource(ValidateSourceRequest request, AsyncHandler<ValidateSourceRequest, ValidateSourceResponse> handler) {
        LOG.trace("Called async validateSource");
        ValidateSourceRequest interceptedRequest = ValidateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateSourceResponse> transformer = ValidateSourceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ValidateSourceRequest, ValidateSourceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateSourceRequest, ValidateSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateSourceExtendedFieldDetailsResponse> validateSourceExtendedFieldDetails(ValidateSourceExtendedFieldDetailsRequest request, AsyncHandler<ValidateSourceExtendedFieldDetailsRequest, ValidateSourceExtendedFieldDetailsResponse> handler) {
        LOG.trace("Called async validateSourceExtendedFieldDetails");
        ValidateSourceExtendedFieldDetailsRequest interceptedRequest = ValidateSourceExtendedFieldDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceExtendedFieldDetailsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateSourceExtendedFieldDetailsResponse> transformer = ValidateSourceExtendedFieldDetailsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ValidateSourceExtendedFieldDetailsRequest, ValidateSourceExtendedFieldDetailsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateSourceExtendedFieldDetailsRequest, ValidateSourceExtendedFieldDetailsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ValidateSourceMappingResponse> validateSourceMapping(ValidateSourceMappingRequest request, AsyncHandler<ValidateSourceMappingRequest, ValidateSourceMappingResponse> handler) {
        LOG.trace("Called async validateSourceMapping");
        ValidateSourceMappingRequest interceptedRequest = ValidateSourceMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceMappingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ValidateSourceMappingResponse> transformer = ValidateSourceMappingConverter.fromResponse();
        AsyncHandler<ValidateSourceMappingRequest, ValidateSourceMappingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ValidateSourceMappingRequest, ValidateSourceMappingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LogAnalyticsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LogAnalyticsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LogAnalyticsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

