/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.loganalytics.LogAnalytics;
import com.oracle.bmc.loganalytics.LogAnalyticsPaginators;
import com.oracle.bmc.loganalytics.LogAnalyticsWaiters;
import com.oracle.bmc.loganalytics.internal.http.AddEntityAssociationConverter;
import com.oracle.bmc.loganalytics.internal.http.AppendLookupDataConverter;
import com.oracle.bmc.loganalytics.internal.http.BatchGetBasicInfoConverter;
import com.oracle.bmc.loganalytics.internal.http.CancelQueryWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsEntityCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsLogGroupCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.ChangeScheduledTaskCompartmentConverter;
import com.oracle.bmc.loganalytics.internal.http.CleanConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.CreateScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteParserConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadFileConverter;
import com.oracle.bmc.loganalytics.internal.http.DeleteUploadWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.DisableArchivingConverter;
import com.oracle.bmc.loganalytics.internal.http.EnableArchivingConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimatePurgeDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimateRecallDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.EstimateReleaseDataSizeConverter;
import com.oracle.bmc.loganalytics.internal.http.ExportCustomContentConverter;
import com.oracle.bmc.loganalytics.internal.http.ExportQueryResultConverter;
import com.oracle.bmc.loganalytics.internal.http.ExtractStructuredLogFieldPathsConverter;
import com.oracle.bmc.loganalytics.internal.http.ExtractStructuredLogHeaderPathsConverter;
import com.oracle.bmc.loganalytics.internal.http.FilterConverter;
import com.oracle.bmc.loganalytics.internal.http.GetAssociationSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetColumnNamesConverter;
import com.oracle.bmc.loganalytics.internal.http.GetConfigWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.GetFieldsSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLabelSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntitiesSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsLogGroupsSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.GetLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.GetNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.GetParserConverter;
import com.oracle.bmc.loganalytics.internal.http.GetParserSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetQueryResultConverter;
import com.oracle.bmc.loganalytics.internal.http.GetQueryWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.GetSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.GetSourceSummaryConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageUsageConverter;
import com.oracle.bmc.loganalytics.internal.http.GetStorageWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.GetUploadConverter;
import com.oracle.bmc.loganalytics.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.loganalytics.internal.http.ImportCustomContentConverter;
import com.oracle.bmc.loganalytics.internal.http.ListAssociatedEntitiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListConfigWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListEntityAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListEntitySourceAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListFieldsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelPrioritiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelSourceDetailsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLabelsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsEntitiesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsEntityTypesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsLogGroupsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLogAnalyticsObjectCollectionRulesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListLookupsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListMetaSourceTypesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListNamespacesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParserFunctionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParserMetaPluginsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListParsersConverter;
import com.oracle.bmc.loganalytics.internal.http.ListQueryWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListRecalledDataConverter;
import com.oracle.bmc.loganalytics.internal.http.ListScheduledTasksConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceExtendedFieldDefinitionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceLabelOperatorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourceMetaFunctionsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourcePatternsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSourcesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListStorageWorkRequestErrorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListStorageWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSupportedCharEncodingsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListSupportedTimezonesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadFilesConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadWarningsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListUploadsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWarningsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.loganalytics.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.loganalytics.internal.http.OffboardNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.OnboardNamespaceConverter;
import com.oracle.bmc.loganalytics.internal.http.ParseQueryConverter;
import com.oracle.bmc.loganalytics.internal.http.PauseScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.PurgeStorageDataConverter;
import com.oracle.bmc.loganalytics.internal.http.PutQueryWorkRequestBackgroundConverter;
import com.oracle.bmc.loganalytics.internal.http.QueryConverter;
import com.oracle.bmc.loganalytics.internal.http.RecallArchivedDataConverter;
import com.oracle.bmc.loganalytics.internal.http.RegisterLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.ReleaseRecalledDataConverter;
import com.oracle.bmc.loganalytics.internal.http.RemoveEntityAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.ResumeScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.RunConverter;
import com.oracle.bmc.loganalytics.internal.http.SuggestConverter;
import com.oracle.bmc.loganalytics.internal.http.SuppressWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.TestParserConverter;
import com.oracle.bmc.loganalytics.internal.http.UnsuppressWarningConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsEntityConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsEntityTypeConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsLogGroupConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLogAnalyticsObjectCollectionRuleConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLookupConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateLookupDataConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateScheduledTaskConverter;
import com.oracle.bmc.loganalytics.internal.http.UpdateStorageConverter;
import com.oracle.bmc.loganalytics.internal.http.UploadLogFileConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertAssociationsConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertFieldConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertLabelConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertParserConverter;
import com.oracle.bmc.loganalytics.internal.http.UpsertSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateAssociationParametersConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateFileConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceExtendedFieldDetailsConverter;
import com.oracle.bmc.loganalytics.internal.http.ValidateSourceMappingConverter;
import com.oracle.bmc.loganalytics.requests.AddEntityAssociationRequest;
import com.oracle.bmc.loganalytics.requests.AppendLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.BatchGetBasicInfoRequest;
import com.oracle.bmc.loganalytics.requests.CancelQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsEntityCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsLogGroupCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.ChangeScheduledTaskCompartmentRequest;
import com.oracle.bmc.loganalytics.requests.CleanRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.CreateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.CreateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.DeleteFieldRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLabelRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.DeleteLookupRequest;
import com.oracle.bmc.loganalytics.requests.DeleteParserRequest;
import com.oracle.bmc.loganalytics.requests.DeleteScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.DeleteSourceRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadFileRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadRequest;
import com.oracle.bmc.loganalytics.requests.DeleteUploadWarningRequest;
import com.oracle.bmc.loganalytics.requests.DisableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.EnableArchivingRequest;
import com.oracle.bmc.loganalytics.requests.EstimatePurgeDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateRecallDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.EstimateReleaseDataSizeRequest;
import com.oracle.bmc.loganalytics.requests.ExportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ExportQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogFieldPathsRequest;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogHeaderPathsRequest;
import com.oracle.bmc.loganalytics.requests.FilterRequest;
import com.oracle.bmc.loganalytics.requests.GetAssociationSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetColumnNamesRequest;
import com.oracle.bmc.loganalytics.requests.GetConfigWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldRequest;
import com.oracle.bmc.loganalytics.requests.GetFieldsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelRequest;
import com.oracle.bmc.loganalytics.requests.GetLabelSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntitiesSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsLogGroupsSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.GetLookupRequest;
import com.oracle.bmc.loganalytics.requests.GetNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.GetParserRequest;
import com.oracle.bmc.loganalytics.requests.GetParserSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryResultRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceRequest;
import com.oracle.bmc.loganalytics.requests.GetSourceSummaryRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageUsageRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetUploadRequest;
import com.oracle.bmc.loganalytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.ImportCustomContentRequest;
import com.oracle.bmc.loganalytics.requests.ListAssociatedEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListConfigWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListEntitySourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListFieldsRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelPrioritiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelSourceDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ListLabelsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntitiesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntityTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsLogGroupsRequest;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsObjectCollectionRulesRequest;
import com.oracle.bmc.loganalytics.requests.ListLookupsRequest;
import com.oracle.bmc.loganalytics.requests.ListMetaSourceTypesRequest;
import com.oracle.bmc.loganalytics.requests.ListNamespacesRequest;
import com.oracle.bmc.loganalytics.requests.ListParserFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListParserMetaPluginsRequest;
import com.oracle.bmc.loganalytics.requests.ListParsersRequest;
import com.oracle.bmc.loganalytics.requests.ListQueryWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.ListScheduledTasksRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceExtendedFieldDefinitionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceLabelOperatorsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourceMetaFunctionsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcePatternsRequest;
import com.oracle.bmc.loganalytics.requests.ListSourcesRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListStorageWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedCharEncodingsRequest;
import com.oracle.bmc.loganalytics.requests.ListSupportedTimezonesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadFilesRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListUploadsRequest;
import com.oracle.bmc.loganalytics.requests.ListWarningsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.loganalytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loganalytics.requests.OffboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.OnboardNamespaceRequest;
import com.oracle.bmc.loganalytics.requests.ParseQueryRequest;
import com.oracle.bmc.loganalytics.requests.PauseScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.PurgeStorageDataRequest;
import com.oracle.bmc.loganalytics.requests.PutQueryWorkRequestBackgroundRequest;
import com.oracle.bmc.loganalytics.requests.QueryRequest;
import com.oracle.bmc.loganalytics.requests.RecallArchivedDataRequest;
import com.oracle.bmc.loganalytics.requests.RegisterLookupRequest;
import com.oracle.bmc.loganalytics.requests.ReleaseRecalledDataRequest;
import com.oracle.bmc.loganalytics.requests.RemoveEntityAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.ResumeScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.RunRequest;
import com.oracle.bmc.loganalytics.requests.SuggestRequest;
import com.oracle.bmc.loganalytics.requests.SuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.TestParserRequest;
import com.oracle.bmc.loganalytics.requests.UnsuppressWarningRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsLogGroupRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupDataRequest;
import com.oracle.bmc.loganalytics.requests.UpdateLookupRequest;
import com.oracle.bmc.loganalytics.requests.UpdateScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.UpdateStorageRequest;
import com.oracle.bmc.loganalytics.requests.UploadLogFileRequest;
import com.oracle.bmc.loganalytics.requests.UpsertAssociationsRequest;
import com.oracle.bmc.loganalytics.requests.UpsertFieldRequest;
import com.oracle.bmc.loganalytics.requests.UpsertLabelRequest;
import com.oracle.bmc.loganalytics.requests.UpsertParserRequest;
import com.oracle.bmc.loganalytics.requests.UpsertSourceRequest;
import com.oracle.bmc.loganalytics.requests.ValidateAssociationParametersRequest;
import com.oracle.bmc.loganalytics.requests.ValidateFileRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceExtendedFieldDetailsRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceMappingRequest;
import com.oracle.bmc.loganalytics.requests.ValidateSourceRequest;
import com.oracle.bmc.loganalytics.responses.AddEntityAssociationResponse;
import com.oracle.bmc.loganalytics.responses.AppendLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.BatchGetBasicInfoResponse;
import com.oracle.bmc.loganalytics.responses.CancelQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsEntityCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsLogGroupCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.ChangeScheduledTaskCompartmentResponse;
import com.oracle.bmc.loganalytics.responses.CleanResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.CreateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.CreateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.DeleteFieldResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLabelResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.DeleteLookupResponse;
import com.oracle.bmc.loganalytics.responses.DeleteParserResponse;
import com.oracle.bmc.loganalytics.responses.DeleteScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.DeleteSourceResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadFileResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadResponse;
import com.oracle.bmc.loganalytics.responses.DeleteUploadWarningResponse;
import com.oracle.bmc.loganalytics.responses.DisableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.EnableArchivingResponse;
import com.oracle.bmc.loganalytics.responses.EstimatePurgeDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateRecallDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.EstimateReleaseDataSizeResponse;
import com.oracle.bmc.loganalytics.responses.ExportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ExportQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogFieldPathsResponse;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogHeaderPathsResponse;
import com.oracle.bmc.loganalytics.responses.FilterResponse;
import com.oracle.bmc.loganalytics.responses.GetAssociationSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetColumnNamesResponse;
import com.oracle.bmc.loganalytics.responses.GetConfigWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldResponse;
import com.oracle.bmc.loganalytics.responses.GetFieldsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelResponse;
import com.oracle.bmc.loganalytics.responses.GetLabelSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntitiesSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsLogGroupsSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.GetLookupResponse;
import com.oracle.bmc.loganalytics.responses.GetNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.GetParserResponse;
import com.oracle.bmc.loganalytics.responses.GetParserSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryResultResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceResponse;
import com.oracle.bmc.loganalytics.responses.GetSourceSummaryResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageUsageResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetUploadResponse;
import com.oracle.bmc.loganalytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.ImportCustomContentResponse;
import com.oracle.bmc.loganalytics.responses.ListAssociatedEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListConfigWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListEntitySourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListFieldsResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelPrioritiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelSourceDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ListLabelsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntitiesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntityTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsLogGroupsResponse;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsObjectCollectionRulesResponse;
import com.oracle.bmc.loganalytics.responses.ListLookupsResponse;
import com.oracle.bmc.loganalytics.responses.ListMetaSourceTypesResponse;
import com.oracle.bmc.loganalytics.responses.ListNamespacesResponse;
import com.oracle.bmc.loganalytics.responses.ListParserFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListParserMetaPluginsResponse;
import com.oracle.bmc.loganalytics.responses.ListParsersResponse;
import com.oracle.bmc.loganalytics.responses.ListQueryWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.ListScheduledTasksResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceExtendedFieldDefinitionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceLabelOperatorsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourceMetaFunctionsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcePatternsResponse;
import com.oracle.bmc.loganalytics.responses.ListSourcesResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListStorageWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedCharEncodingsResponse;
import com.oracle.bmc.loganalytics.responses.ListSupportedTimezonesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadFilesResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListUploadsResponse;
import com.oracle.bmc.loganalytics.responses.ListWarningsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.loganalytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.loganalytics.responses.OffboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.OnboardNamespaceResponse;
import com.oracle.bmc.loganalytics.responses.ParseQueryResponse;
import com.oracle.bmc.loganalytics.responses.PauseScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.PurgeStorageDataResponse;
import com.oracle.bmc.loganalytics.responses.PutQueryWorkRequestBackgroundResponse;
import com.oracle.bmc.loganalytics.responses.QueryResponse;
import com.oracle.bmc.loganalytics.responses.RecallArchivedDataResponse;
import com.oracle.bmc.loganalytics.responses.RegisterLookupResponse;
import com.oracle.bmc.loganalytics.responses.ReleaseRecalledDataResponse;
import com.oracle.bmc.loganalytics.responses.RemoveEntityAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.ResumeScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.RunResponse;
import com.oracle.bmc.loganalytics.responses.SuggestResponse;
import com.oracle.bmc.loganalytics.responses.SuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.TestParserResponse;
import com.oracle.bmc.loganalytics.responses.UnsuppressWarningResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsLogGroupResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupDataResponse;
import com.oracle.bmc.loganalytics.responses.UpdateLookupResponse;
import com.oracle.bmc.loganalytics.responses.UpdateScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.UpdateStorageResponse;
import com.oracle.bmc.loganalytics.responses.UploadLogFileResponse;
import com.oracle.bmc.loganalytics.responses.UpsertAssociationsResponse;
import com.oracle.bmc.loganalytics.responses.UpsertFieldResponse;
import com.oracle.bmc.loganalytics.responses.UpsertLabelResponse;
import com.oracle.bmc.loganalytics.responses.UpsertParserResponse;
import com.oracle.bmc.loganalytics.responses.UpsertSourceResponse;
import com.oracle.bmc.loganalytics.responses.ValidateAssociationParametersResponse;
import com.oracle.bmc.loganalytics.responses.ValidateFileResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceExtendedFieldDetailsResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceMappingResponse;
import com.oracle.bmc.loganalytics.responses.ValidateSourceResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyticsClient
implements LogAnalytics {
    private static final Logger LOG = LoggerFactory.getLogger(LogAnalyticsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://loganalytics.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final LogAnalyticsWaiters waiters;
    private final LogAnalyticsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LogAnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected LogAnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LogAnalytics-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new LogAnalyticsWaiters(executorService, this);
        this.paginators = new LogAnalyticsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddEntityAssociationResponse addEntityAssociation(AddEntityAssociationRequest request) {
        LOG.trace("Called addEntityAssociation");
        AddEntityAssociationRequest interceptedRequest = AddEntityAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddEntityAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddEntityAssociationResponse> transformer = AddEntityAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddEntityAssociationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddEntityAssociationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddEntityAssociationDetails(), (BmcRequest)retriedRequest);
                return (AddEntityAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppendLookupDataResponse appendLookupData(AppendLookupDataRequest request) {
        LOG.trace("Called appendLookupData");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (AppendLookupDataRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)AppendLookupDataRequest.builder());
            }
            AppendLookupDataRequest interceptedRequest = AppendLookupDataConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = AppendLookupDataConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, AppendLookupDataResponse> transformer = AppendLookupDataConverter.fromResponse();
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            AppendLookupDataResponse appendLookupDataResponse = (AppendLookupDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (AppendLookupDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getAppendLookupFileBody(), (BmcRequest)retriedRequest);
                        return (AppendLookupDataResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getAppendLookupFileBody(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return appendLookupDataResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getAppendLookupFileBody());
        }
    }

    @Override
    public BatchGetBasicInfoResponse batchGetBasicInfo(BatchGetBasicInfoRequest request) {
        LOG.trace("Called batchGetBasicInfo");
        BatchGetBasicInfoRequest interceptedRequest = BatchGetBasicInfoConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchGetBasicInfoConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BatchGetBasicInfoResponse> transformer = BatchGetBasicInfoConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (BatchGetBasicInfoResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchGetBasicInfoResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBasicDetails(), (BmcRequest)retriedRequest);
                return (BatchGetBasicInfoResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CancelQueryWorkRequestResponse cancelQueryWorkRequest(CancelQueryWorkRequestRequest request) {
        LOG.trace("Called cancelQueryWorkRequest");
        CancelQueryWorkRequestRequest interceptedRequest = CancelQueryWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelQueryWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelQueryWorkRequestResponse> transformer = CancelQueryWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CancelQueryWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelQueryWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelQueryWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLogAnalyticsEntityCompartmentResponse changeLogAnalyticsEntityCompartment(ChangeLogAnalyticsEntityCompartmentRequest request) {
        LOG.trace("Called changeLogAnalyticsEntityCompartment");
        ChangeLogAnalyticsEntityCompartmentRequest interceptedRequest = ChangeLogAnalyticsEntityCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsEntityCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogAnalyticsEntityCompartmentResponse> transformer = ChangeLogAnalyticsEntityCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeLogAnalyticsEntityCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogAnalyticsEntityCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogAnalyticsEntityCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogAnalyticsEntityCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLogAnalyticsLogGroupCompartmentResponse changeLogAnalyticsLogGroupCompartment(ChangeLogAnalyticsLogGroupCompartmentRequest request) {
        LOG.trace("Called changeLogAnalyticsLogGroupCompartment");
        ChangeLogAnalyticsLogGroupCompartmentRequest interceptedRequest = ChangeLogAnalyticsLogGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsLogGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogAnalyticsLogGroupCompartmentResponse> transformer = ChangeLogAnalyticsLogGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeLogAnalyticsLogGroupCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogAnalyticsLogGroupCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogAnalyticsLogGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogAnalyticsLogGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse changeLogAnalyticsObjectCollectionRuleCompartment(ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest request) {
        LOG.trace("Called changeLogAnalyticsObjectCollectionRuleCompartment");
        ChangeLogAnalyticsObjectCollectionRuleCompartmentRequest interceptedRequest = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse> transformer = ChangeLogAnalyticsObjectCollectionRuleCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeLogAnalyticsObjectCollectionRuleCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeLogAnalyticsObjectCollectionRuleCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeScheduledTaskCompartmentResponse changeScheduledTaskCompartment(ChangeScheduledTaskCompartmentRequest request) {
        LOG.trace("Called changeScheduledTaskCompartment");
        ChangeScheduledTaskCompartmentRequest interceptedRequest = ChangeScheduledTaskCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledTaskCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeScheduledTaskCompartmentResponse> transformer = ChangeScheduledTaskCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeScheduledTaskCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeScheduledTaskCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeScheduledTaskCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeScheduledTaskCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CleanResponse clean(CleanRequest request) {
        LOG.trace("Called clean");
        CleanRequest interceptedRequest = CleanConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CleanConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CleanResponse> transformer = CleanConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CleanResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CleanResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CleanResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogAnalyticsEntityResponse createLogAnalyticsEntity(CreateLogAnalyticsEntityRequest request) {
        LOG.trace("Called createLogAnalyticsEntity");
        CreateLogAnalyticsEntityRequest interceptedRequest = CreateLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogAnalyticsEntityResponse> transformer = CreateLogAnalyticsEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogAnalyticsEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogAnalyticsEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogAnalyticsEntityDetails(), (BmcRequest)retriedRequest);
                return (CreateLogAnalyticsEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogAnalyticsEntityTypeResponse createLogAnalyticsEntityType(CreateLogAnalyticsEntityTypeRequest request) {
        LOG.trace("Called createLogAnalyticsEntityType");
        CreateLogAnalyticsEntityTypeRequest interceptedRequest = CreateLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogAnalyticsEntityTypeResponse> transformer = CreateLogAnalyticsEntityTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogAnalyticsEntityTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogAnalyticsEntityTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogAnalyticsEntityTypeDetails(), (BmcRequest)retriedRequest);
                return (CreateLogAnalyticsEntityTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogAnalyticsLogGroupResponse createLogAnalyticsLogGroup(CreateLogAnalyticsLogGroupRequest request) {
        LOG.trace("Called createLogAnalyticsLogGroup");
        CreateLogAnalyticsLogGroupRequest interceptedRequest = CreateLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogAnalyticsLogGroupResponse> transformer = CreateLogAnalyticsLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateLogAnalyticsLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogAnalyticsLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogAnalyticsLogGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateLogAnalyticsLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLogAnalyticsObjectCollectionRuleResponse createLogAnalyticsObjectCollectionRule(CreateLogAnalyticsObjectCollectionRuleRequest request) {
        LOG.trace("Called createLogAnalyticsObjectCollectionRule");
        CreateLogAnalyticsObjectCollectionRuleRequest interceptedRequest = CreateLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogAnalyticsObjectCollectionRuleResponse> transformer = CreateLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateLogAnalyticsObjectCollectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateLogAnalyticsObjectCollectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateLogAnalyticsObjectCollectionRuleDetails(), (BmcRequest)retriedRequest);
                return (CreateLogAnalyticsObjectCollectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateScheduledTaskResponse createScheduledTask(CreateScheduledTaskRequest request) {
        LOG.trace("Called createScheduledTask");
        CreateScheduledTaskRequest interceptedRequest = CreateScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateScheduledTaskResponse> transformer = CreateScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateScheduledTaskDetails(), (BmcRequest)retriedRequest);
                return (CreateScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAssociationsResponse deleteAssociations(DeleteAssociationsRequest request) {
        LOG.trace("Called deleteAssociations");
        DeleteAssociationsRequest interceptedRequest = DeleteAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAssociationsResponse> transformer = DeleteAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDeleteLogAnalyticsAssociationDetails(), (BmcRequest)retriedRequest);
                return (DeleteAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteFieldResponse deleteField(DeleteFieldRequest request) {
        LOG.trace("Called deleteField");
        DeleteFieldRequest interceptedRequest = DeleteFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFieldConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteFieldResponse> transformer = DeleteFieldConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteFieldResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteFieldResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteFieldResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLabelResponse deleteLabel(DeleteLabelRequest request) {
        LOG.trace("Called deleteLabel");
        DeleteLabelRequest interceptedRequest = DeleteLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLabelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLabelResponse> transformer = DeleteLabelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteLabelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLabelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLabelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogAnalyticsEntityResponse deleteLogAnalyticsEntity(DeleteLogAnalyticsEntityRequest request) {
        LOG.trace("Called deleteLogAnalyticsEntity");
        DeleteLogAnalyticsEntityRequest interceptedRequest = DeleteLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogAnalyticsEntityResponse> transformer = DeleteLogAnalyticsEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogAnalyticsEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogAnalyticsEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogAnalyticsEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogAnalyticsEntityTypeResponse deleteLogAnalyticsEntityType(DeleteLogAnalyticsEntityTypeRequest request) {
        LOG.trace("Called deleteLogAnalyticsEntityType");
        DeleteLogAnalyticsEntityTypeRequest interceptedRequest = DeleteLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogAnalyticsEntityTypeResponse> transformer = DeleteLogAnalyticsEntityTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogAnalyticsEntityTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogAnalyticsEntityTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogAnalyticsEntityTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogAnalyticsLogGroupResponse deleteLogAnalyticsLogGroup(DeleteLogAnalyticsLogGroupRequest request) {
        LOG.trace("Called deleteLogAnalyticsLogGroup");
        DeleteLogAnalyticsLogGroupRequest interceptedRequest = DeleteLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogAnalyticsLogGroupResponse> transformer = DeleteLogAnalyticsLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogAnalyticsLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogAnalyticsLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogAnalyticsLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLogAnalyticsObjectCollectionRuleResponse deleteLogAnalyticsObjectCollectionRule(DeleteLogAnalyticsObjectCollectionRuleRequest request) {
        LOG.trace("Called deleteLogAnalyticsObjectCollectionRule");
        DeleteLogAnalyticsObjectCollectionRuleRequest interceptedRequest = DeleteLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogAnalyticsObjectCollectionRuleResponse> transformer = DeleteLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteLogAnalyticsObjectCollectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLogAnalyticsObjectCollectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLogAnalyticsObjectCollectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLookupResponse deleteLookup(DeleteLookupRequest request) {
        LOG.trace("Called deleteLookup");
        DeleteLookupRequest interceptedRequest = DeleteLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLookupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLookupResponse> transformer = DeleteLookupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteLookupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteLookupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteLookupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteParserResponse deleteParser(DeleteParserRequest request) {
        LOG.trace("Called deleteParser");
        DeleteParserRequest interceptedRequest = DeleteParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteParserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteParserResponse> transformer = DeleteParserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteParserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteParserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteParserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteScheduledTaskResponse deleteScheduledTask(DeleteScheduledTaskRequest request) {
        LOG.trace("Called deleteScheduledTask");
        DeleteScheduledTaskRequest interceptedRequest = DeleteScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteScheduledTaskResponse> transformer = DeleteScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSourceResponse deleteSource(DeleteSourceRequest request) {
        LOG.trace("Called deleteSource");
        DeleteSourceRequest interceptedRequest = DeleteSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSourceResponse> transformer = DeleteSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteUploadResponse deleteUpload(DeleteUploadRequest request) {
        LOG.trace("Called deleteUpload");
        DeleteUploadRequest interceptedRequest = DeleteUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUploadResponse> transformer = DeleteUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteUploadResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteUploadResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteUploadResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteUploadFileResponse deleteUploadFile(DeleteUploadFileRequest request) {
        LOG.trace("Called deleteUploadFile");
        DeleteUploadFileRequest interceptedRequest = DeleteUploadFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUploadFileResponse> transformer = DeleteUploadFileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteUploadFileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteUploadFileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteUploadFileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteUploadWarningResponse deleteUploadWarning(DeleteUploadWarningRequest request) {
        LOG.trace("Called deleteUploadWarning");
        DeleteUploadWarningRequest interceptedRequest = DeleteUploadWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUploadWarningConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUploadWarningResponse> transformer = DeleteUploadWarningConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteUploadWarningResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteUploadWarningResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteUploadWarningResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DisableArchivingResponse disableArchiving(DisableArchivingRequest request) {
        LOG.trace("Called disableArchiving");
        DisableArchivingRequest interceptedRequest = DisableArchivingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableArchivingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DisableArchivingResponse> transformer = DisableArchivingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DisableArchivingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DisableArchivingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DisableArchivingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EnableArchivingResponse enableArchiving(EnableArchivingRequest request) {
        LOG.trace("Called enableArchiving");
        EnableArchivingRequest interceptedRequest = EnableArchivingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableArchivingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableArchivingResponse> transformer = EnableArchivingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (EnableArchivingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EnableArchivingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (EnableArchivingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EstimatePurgeDataSizeResponse estimatePurgeDataSize(EstimatePurgeDataSizeRequest request) {
        LOG.trace("Called estimatePurgeDataSize");
        EstimatePurgeDataSizeRequest interceptedRequest = EstimatePurgeDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimatePurgeDataSizeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EstimatePurgeDataSizeResponse> transformer = EstimatePurgeDataSizeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (EstimatePurgeDataSizeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EstimatePurgeDataSizeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getEstimatePurgeDataSizeDetails(), (BmcRequest)retriedRequest);
                return (EstimatePurgeDataSizeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EstimateRecallDataSizeResponse estimateRecallDataSize(EstimateRecallDataSizeRequest request) {
        LOG.trace("Called estimateRecallDataSize");
        EstimateRecallDataSizeRequest interceptedRequest = EstimateRecallDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimateRecallDataSizeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EstimateRecallDataSizeResponse> transformer = EstimateRecallDataSizeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (EstimateRecallDataSizeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EstimateRecallDataSizeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getEstimateRecallDataSizeDetails(), (BmcRequest)retriedRequest);
                return (EstimateRecallDataSizeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EstimateReleaseDataSizeResponse estimateReleaseDataSize(EstimateReleaseDataSizeRequest request) {
        LOG.trace("Called estimateReleaseDataSize");
        EstimateReleaseDataSizeRequest interceptedRequest = EstimateReleaseDataSizeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EstimateReleaseDataSizeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EstimateReleaseDataSizeResponse> transformer = EstimateReleaseDataSizeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (EstimateReleaseDataSizeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EstimateReleaseDataSizeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getEstimateReleaseDataSizeDetails(), (BmcRequest)retriedRequest);
                return (EstimateReleaseDataSizeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExportCustomContentResponse exportCustomContent(ExportCustomContentRequest request) {
        LOG.trace("Called exportCustomContent");
        ExportCustomContentRequest interceptedRequest = ExportCustomContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportCustomContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportCustomContentResponse> transformer = ExportCustomContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExportCustomContentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExportCustomContentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getExportCustomContentDetails(), (BmcRequest)retriedRequest);
                return (ExportCustomContentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExportQueryResultResponse exportQueryResult(ExportQueryResultRequest request) {
        LOG.trace("Called exportQueryResult");
        ExportQueryResultRequest interceptedRequest = ExportQueryResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportQueryResultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportQueryResultResponse> transformer = ExportQueryResultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ExportQueryResultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExportQueryResultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getExportDetails(), (BmcRequest)retriedRequest);
                return (ExportQueryResultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExtractStructuredLogFieldPathsResponse extractStructuredLogFieldPaths(ExtractStructuredLogFieldPathsRequest request) {
        LOG.trace("Called extractStructuredLogFieldPaths");
        ExtractStructuredLogFieldPathsRequest interceptedRequest = ExtractStructuredLogFieldPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExtractStructuredLogFieldPathsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExtractStructuredLogFieldPathsResponse> transformer = ExtractStructuredLogFieldPathsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExtractStructuredLogFieldPathsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExtractStructuredLogFieldPathsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getLoganParserDetails(), (BmcRequest)retriedRequest);
                return (ExtractStructuredLogFieldPathsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExtractStructuredLogHeaderPathsResponse extractStructuredLogHeaderPaths(ExtractStructuredLogHeaderPathsRequest request) {
        LOG.trace("Called extractStructuredLogHeaderPaths");
        ExtractStructuredLogHeaderPathsRequest interceptedRequest = ExtractStructuredLogHeaderPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExtractStructuredLogHeaderPathsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExtractStructuredLogHeaderPathsResponse> transformer = ExtractStructuredLogHeaderPathsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ExtractStructuredLogHeaderPathsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ExtractStructuredLogHeaderPathsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getLoganParserDetails(), (BmcRequest)retriedRequest);
                return (ExtractStructuredLogHeaderPathsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public FilterResponse filter(FilterRequest request) {
        LOG.trace("Called filter");
        FilterRequest interceptedRequest = FilterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = FilterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, FilterResponse> transformer = FilterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (FilterResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (FilterResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getFilterDetails(), (BmcRequest)retriedRequest);
                return (FilterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAssociationSummaryResponse getAssociationSummary(GetAssociationSummaryRequest request) {
        LOG.trace("Called getAssociationSummary");
        GetAssociationSummaryRequest interceptedRequest = GetAssociationSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAssociationSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAssociationSummaryResponse> transformer = GetAssociationSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAssociationSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAssociationSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAssociationSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetColumnNamesResponse getColumnNames(GetColumnNamesRequest request) {
        LOG.trace("Called getColumnNames");
        GetColumnNamesRequest interceptedRequest = GetColumnNamesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetColumnNamesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetColumnNamesResponse> transformer = GetColumnNamesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GetColumnNamesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetColumnNamesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetColumnNamesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConfigWorkRequestResponse getConfigWorkRequest(GetConfigWorkRequestRequest request) {
        LOG.trace("Called getConfigWorkRequest");
        GetConfigWorkRequestRequest interceptedRequest = GetConfigWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfigWorkRequestResponse> transformer = GetConfigWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConfigWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConfigWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConfigWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFieldResponse getField(GetFieldRequest request) {
        LOG.trace("Called getField");
        GetFieldRequest interceptedRequest = GetFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFieldConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFieldResponse> transformer = GetFieldConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetFieldResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFieldResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFieldResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFieldsSummaryResponse getFieldsSummary(GetFieldsSummaryRequest request) {
        LOG.trace("Called getFieldsSummary");
        GetFieldsSummaryRequest interceptedRequest = GetFieldsSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFieldsSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFieldsSummaryResponse> transformer = GetFieldsSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetFieldsSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetFieldsSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetFieldsSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLabelResponse getLabel(GetLabelRequest request) {
        LOG.trace("Called getLabel");
        GetLabelRequest interceptedRequest = GetLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLabelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLabelResponse> transformer = GetLabelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLabelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLabelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLabelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLabelSummaryResponse getLabelSummary(GetLabelSummaryRequest request) {
        LOG.trace("Called getLabelSummary");
        GetLabelSummaryRequest interceptedRequest = GetLabelSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLabelSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLabelSummaryResponse> transformer = GetLabelSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLabelSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLabelSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLabelSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsEntitiesSummaryResponse getLogAnalyticsEntitiesSummary(GetLogAnalyticsEntitiesSummaryRequest request) {
        LOG.trace("Called getLogAnalyticsEntitiesSummary");
        GetLogAnalyticsEntitiesSummaryRequest interceptedRequest = GetLogAnalyticsEntitiesSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntitiesSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsEntitiesSummaryResponse> transformer = GetLogAnalyticsEntitiesSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsEntitiesSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsEntitiesSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsEntitiesSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsEntityResponse getLogAnalyticsEntity(GetLogAnalyticsEntityRequest request) {
        LOG.trace("Called getLogAnalyticsEntity");
        GetLogAnalyticsEntityRequest interceptedRequest = GetLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsEntityResponse> transformer = GetLogAnalyticsEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsEntityTypeResponse getLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request) {
        LOG.trace("Called getLogAnalyticsEntityType");
        GetLogAnalyticsEntityTypeRequest interceptedRequest = GetLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsEntityTypeResponse> transformer = GetLogAnalyticsEntityTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsEntityTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsEntityTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsEntityTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsLogGroupResponse getLogAnalyticsLogGroup(GetLogAnalyticsLogGroupRequest request) {
        LOG.trace("Called getLogAnalyticsLogGroup");
        GetLogAnalyticsLogGroupRequest interceptedRequest = GetLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsLogGroupResponse> transformer = GetLogAnalyticsLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsLogGroupsSummaryResponse getLogAnalyticsLogGroupsSummary(GetLogAnalyticsLogGroupsSummaryRequest request) {
        LOG.trace("Called getLogAnalyticsLogGroupsSummary");
        GetLogAnalyticsLogGroupsSummaryRequest interceptedRequest = GetLogAnalyticsLogGroupsSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsLogGroupsSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsLogGroupsSummaryResponse> transformer = GetLogAnalyticsLogGroupsSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsLogGroupsSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsLogGroupsSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsLogGroupsSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLogAnalyticsObjectCollectionRuleResponse getLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request) {
        LOG.trace("Called getLogAnalyticsObjectCollectionRule");
        GetLogAnalyticsObjectCollectionRuleRequest interceptedRequest = GetLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogAnalyticsObjectCollectionRuleResponse> transformer = GetLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLogAnalyticsObjectCollectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLogAnalyticsObjectCollectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLogAnalyticsObjectCollectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLookupResponse getLookup(GetLookupRequest request) {
        LOG.trace("Called getLookup");
        GetLookupRequest interceptedRequest = GetLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLookupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLookupResponse> transformer = GetLookupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetLookupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetLookupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetLookupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        LOG.trace("Called getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetParserResponse getParser(GetParserRequest request) {
        LOG.trace("Called getParser");
        GetParserRequest interceptedRequest = GetParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetParserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetParserResponse> transformer = GetParserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetParserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetParserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetParserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetParserSummaryResponse getParserSummary(GetParserSummaryRequest request) {
        LOG.trace("Called getParserSummary");
        GetParserSummaryRequest interceptedRequest = GetParserSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetParserSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetParserSummaryResponse> transformer = GetParserSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetParserSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetParserSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetParserSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetQueryResultResponse getQueryResult(GetQueryResultRequest request) {
        LOG.trace("Called getQueryResult");
        GetQueryResultRequest interceptedRequest = GetQueryResultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryResultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetQueryResultResponse> transformer = GetQueryResultConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetQueryResultResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetQueryResultResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetQueryResultResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetQueryWorkRequestResponse getQueryWorkRequest(GetQueryWorkRequestRequest request) {
        LOG.trace("Called getQueryWorkRequest");
        GetQueryWorkRequestRequest interceptedRequest = GetQueryWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetQueryWorkRequestResponse> transformer = GetQueryWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetQueryWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetQueryWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetQueryWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetScheduledTaskResponse getScheduledTask(GetScheduledTaskRequest request) {
        LOG.trace("Called getScheduledTask");
        GetScheduledTaskRequest interceptedRequest = GetScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetScheduledTaskResponse> transformer = GetScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSourceResponse getSource(GetSourceRequest request) {
        LOG.trace("Called getSource");
        GetSourceRequest interceptedRequest = GetSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSourceResponse> transformer = GetSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSourceSummaryResponse getSourceSummary(GetSourceSummaryRequest request) {
        LOG.trace("Called getSourceSummary");
        GetSourceSummaryRequest interceptedRequest = GetSourceSummaryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSourceSummaryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSourceSummaryResponse> transformer = GetSourceSummaryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSourceSummaryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSourceSummaryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSourceSummaryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStorageResponse getStorage(GetStorageRequest request) {
        LOG.trace("Called getStorage");
        GetStorageRequest interceptedRequest = GetStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStorageResponse> transformer = GetStorageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStorageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStorageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStorageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStorageUsageResponse getStorageUsage(GetStorageUsageRequest request) {
        LOG.trace("Called getStorageUsage");
        GetStorageUsageRequest interceptedRequest = GetStorageUsageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageUsageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStorageUsageResponse> transformer = GetStorageUsageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStorageUsageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStorageUsageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStorageUsageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStorageWorkRequestResponse getStorageWorkRequest(GetStorageWorkRequestRequest request) {
        LOG.trace("Called getStorageWorkRequest");
        GetStorageWorkRequestRequest interceptedRequest = GetStorageWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStorageWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStorageWorkRequestResponse> transformer = GetStorageWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStorageWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStorageWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStorageWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUploadResponse getUpload(GetUploadRequest request) {
        LOG.trace("Called getUpload");
        GetUploadRequest interceptedRequest = GetUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUploadResponse> transformer = GetUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetUploadResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetUploadResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetUploadResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCustomContentResponse importCustomContent(ImportCustomContentRequest request) {
        LOG.trace("Called importCustomContent");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (ImportCustomContentRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)ImportCustomContentRequest.builder());
            }
            ImportCustomContentRequest interceptedRequest = ImportCustomContentConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = ImportCustomContentConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, ImportCustomContentResponse> transformer = ImportCustomContentConverter.fromResponse();
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            ImportCustomContentResponse importCustomContentResponse = (ImportCustomContentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (ImportCustomContentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getImportCustomContentFileBody(), (BmcRequest)retriedRequest);
                        return (ImportCustomContentResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getImportCustomContentFileBody(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return importCustomContentResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getImportCustomContentFileBody());
        }
    }

    @Override
    public ListAssociatedEntitiesResponse listAssociatedEntities(ListAssociatedEntitiesRequest request) {
        LOG.trace("Called listAssociatedEntities");
        ListAssociatedEntitiesRequest interceptedRequest = ListAssociatedEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAssociatedEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAssociatedEntitiesResponse> transformer = ListAssociatedEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAssociatedEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAssociatedEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAssociatedEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConfigWorkRequestsResponse listConfigWorkRequests(ListConfigWorkRequestsRequest request) {
        LOG.trace("Called listConfigWorkRequests");
        ListConfigWorkRequestsRequest interceptedRequest = ListConfigWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConfigWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConfigWorkRequestsResponse> transformer = ListConfigWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConfigWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConfigWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConfigWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEntityAssociationsResponse listEntityAssociations(ListEntityAssociationsRequest request) {
        LOG.trace("Called listEntityAssociations");
        ListEntityAssociationsRequest interceptedRequest = ListEntityAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntityAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEntityAssociationsResponse> transformer = ListEntityAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEntityAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEntityAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEntityAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEntitySourceAssociationsResponse listEntitySourceAssociations(ListEntitySourceAssociationsRequest request) {
        LOG.trace("Called listEntitySourceAssociations");
        ListEntitySourceAssociationsRequest interceptedRequest = ListEntitySourceAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEntitySourceAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEntitySourceAssociationsResponse> transformer = ListEntitySourceAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEntitySourceAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEntitySourceAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEntitySourceAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFieldsResponse listFields(ListFieldsRequest request) {
        LOG.trace("Called listFields");
        ListFieldsRequest interceptedRequest = ListFieldsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFieldsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFieldsResponse> transformer = ListFieldsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListFieldsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFieldsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFieldsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLabelPrioritiesResponse listLabelPriorities(ListLabelPrioritiesRequest request) {
        LOG.trace("Called listLabelPriorities");
        ListLabelPrioritiesRequest interceptedRequest = ListLabelPrioritiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelPrioritiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLabelPrioritiesResponse> transformer = ListLabelPrioritiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLabelPrioritiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLabelPrioritiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLabelPrioritiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLabelSourceDetailsResponse listLabelSourceDetails(ListLabelSourceDetailsRequest request) {
        LOG.trace("Called listLabelSourceDetails");
        ListLabelSourceDetailsRequest interceptedRequest = ListLabelSourceDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelSourceDetailsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLabelSourceDetailsResponse> transformer = ListLabelSourceDetailsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLabelSourceDetailsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLabelSourceDetailsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLabelSourceDetailsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLabelsResponse listLabels(ListLabelsRequest request) {
        LOG.trace("Called listLabels");
        ListLabelsRequest interceptedRequest = ListLabelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLabelsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLabelsResponse> transformer = ListLabelsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLabelsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLabelsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLabelsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogAnalyticsEntitiesResponse listLogAnalyticsEntities(ListLogAnalyticsEntitiesRequest request) {
        LOG.trace("Called listLogAnalyticsEntities");
        ListLogAnalyticsEntitiesRequest interceptedRequest = ListLogAnalyticsEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsEntitiesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogAnalyticsEntitiesResponse> transformer = ListLogAnalyticsEntitiesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogAnalyticsEntitiesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogAnalyticsEntitiesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogAnalyticsEntitiesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogAnalyticsEntityTypesResponse listLogAnalyticsEntityTypes(ListLogAnalyticsEntityTypesRequest request) {
        LOG.trace("Called listLogAnalyticsEntityTypes");
        ListLogAnalyticsEntityTypesRequest interceptedRequest = ListLogAnalyticsEntityTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsEntityTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogAnalyticsEntityTypesResponse> transformer = ListLogAnalyticsEntityTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogAnalyticsEntityTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogAnalyticsEntityTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogAnalyticsEntityTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogAnalyticsLogGroupsResponse listLogAnalyticsLogGroups(ListLogAnalyticsLogGroupsRequest request) {
        LOG.trace("Called listLogAnalyticsLogGroups");
        ListLogAnalyticsLogGroupsRequest interceptedRequest = ListLogAnalyticsLogGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsLogGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogAnalyticsLogGroupsResponse> transformer = ListLogAnalyticsLogGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogAnalyticsLogGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogAnalyticsLogGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogAnalyticsLogGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLogAnalyticsObjectCollectionRulesResponse listLogAnalyticsObjectCollectionRules(ListLogAnalyticsObjectCollectionRulesRequest request) {
        LOG.trace("Called listLogAnalyticsObjectCollectionRules");
        ListLogAnalyticsObjectCollectionRulesRequest interceptedRequest = ListLogAnalyticsObjectCollectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogAnalyticsObjectCollectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogAnalyticsObjectCollectionRulesResponse> transformer = ListLogAnalyticsObjectCollectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLogAnalyticsObjectCollectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLogAnalyticsObjectCollectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLogAnalyticsObjectCollectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLookupsResponse listLookups(ListLookupsRequest request) {
        LOG.trace("Called listLookups");
        ListLookupsRequest interceptedRequest = ListLookupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLookupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLookupsResponse> transformer = ListLookupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListLookupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListLookupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListLookupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMetaSourceTypesResponse listMetaSourceTypes(ListMetaSourceTypesRequest request) {
        LOG.trace("Called listMetaSourceTypes");
        ListMetaSourceTypesRequest interceptedRequest = ListMetaSourceTypesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMetaSourceTypesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMetaSourceTypesResponse> transformer = ListMetaSourceTypesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListMetaSourceTypesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMetaSourceTypesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMetaSourceTypesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        LOG.trace("Called listNamespaces");
        ListNamespacesRequest interceptedRequest = ListNamespacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNamespacesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNamespacesResponse> transformer = ListNamespacesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListNamespacesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNamespacesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNamespacesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListParserFunctionsResponse listParserFunctions(ListParserFunctionsRequest request) {
        LOG.trace("Called listParserFunctions");
        ListParserFunctionsRequest interceptedRequest = ListParserFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParserFunctionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListParserFunctionsResponse> transformer = ListParserFunctionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListParserFunctionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListParserFunctionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListParserFunctionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListParserMetaPluginsResponse listParserMetaPlugins(ListParserMetaPluginsRequest request) {
        LOG.trace("Called listParserMetaPlugins");
        ListParserMetaPluginsRequest interceptedRequest = ListParserMetaPluginsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParserMetaPluginsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListParserMetaPluginsResponse> transformer = ListParserMetaPluginsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListParserMetaPluginsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListParserMetaPluginsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListParserMetaPluginsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListParsersResponse listParsers(ListParsersRequest request) {
        LOG.trace("Called listParsers");
        ListParsersRequest interceptedRequest = ListParsersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListParsersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListParsersResponse> transformer = ListParsersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListParsersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListParsersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListParsersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListQueryWorkRequestsResponse listQueryWorkRequests(ListQueryWorkRequestsRequest request) {
        LOG.trace("Called listQueryWorkRequests");
        ListQueryWorkRequestsRequest interceptedRequest = ListQueryWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListQueryWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListQueryWorkRequestsResponse> transformer = ListQueryWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListQueryWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListQueryWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListQueryWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRecalledDataResponse listRecalledData(ListRecalledDataRequest request) {
        LOG.trace("Called listRecalledData");
        ListRecalledDataRequest interceptedRequest = ListRecalledDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecalledDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecalledDataResponse> transformer = ListRecalledDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRecalledDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRecalledDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRecalledDataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListScheduledTasksResponse listScheduledTasks(ListScheduledTasksRequest request) {
        LOG.trace("Called listScheduledTasks");
        ListScheduledTasksRequest interceptedRequest = ListScheduledTasksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledTasksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListScheduledTasksResponse> transformer = ListScheduledTasksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListScheduledTasksResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListScheduledTasksResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListScheduledTasksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourceAssociationsResponse listSourceAssociations(ListSourceAssociationsRequest request) {
        LOG.trace("Called listSourceAssociations");
        ListSourceAssociationsRequest interceptedRequest = ListSourceAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceAssociationsResponse> transformer = ListSourceAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourceAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourceAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourceAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourceExtendedFieldDefinitionsResponse listSourceExtendedFieldDefinitions(ListSourceExtendedFieldDefinitionsRequest request) {
        LOG.trace("Called listSourceExtendedFieldDefinitions");
        ListSourceExtendedFieldDefinitionsRequest interceptedRequest = ListSourceExtendedFieldDefinitionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceExtendedFieldDefinitionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceExtendedFieldDefinitionsResponse> transformer = ListSourceExtendedFieldDefinitionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourceExtendedFieldDefinitionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourceExtendedFieldDefinitionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourceExtendedFieldDefinitionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourceLabelOperatorsResponse listSourceLabelOperators(ListSourceLabelOperatorsRequest request) {
        LOG.trace("Called listSourceLabelOperators");
        ListSourceLabelOperatorsRequest interceptedRequest = ListSourceLabelOperatorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceLabelOperatorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceLabelOperatorsResponse> transformer = ListSourceLabelOperatorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourceLabelOperatorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourceLabelOperatorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourceLabelOperatorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourceMetaFunctionsResponse listSourceMetaFunctions(ListSourceMetaFunctionsRequest request) {
        LOG.trace("Called listSourceMetaFunctions");
        ListSourceMetaFunctionsRequest interceptedRequest = ListSourceMetaFunctionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourceMetaFunctionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourceMetaFunctionsResponse> transformer = ListSourceMetaFunctionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourceMetaFunctionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourceMetaFunctionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourceMetaFunctionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourcePatternsResponse listSourcePatterns(ListSourcePatternsRequest request) {
        LOG.trace("Called listSourcePatterns");
        ListSourcePatternsRequest interceptedRequest = ListSourcePatternsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcePatternsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourcePatternsResponse> transformer = ListSourcePatternsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourcePatternsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourcePatternsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourcePatternsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSourcesResponse listSources(ListSourcesRequest request) {
        LOG.trace("Called listSources");
        ListSourcesRequest interceptedRequest = ListSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSourcesResponse> transformer = ListSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSourcesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSourcesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSourcesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStorageWorkRequestErrorsResponse listStorageWorkRequestErrors(ListStorageWorkRequestErrorsRequest request) {
        LOG.trace("Called listStorageWorkRequestErrors");
        ListStorageWorkRequestErrorsRequest interceptedRequest = ListStorageWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStorageWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStorageWorkRequestErrorsResponse> transformer = ListStorageWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStorageWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStorageWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStorageWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStorageWorkRequestsResponse listStorageWorkRequests(ListStorageWorkRequestsRequest request) {
        LOG.trace("Called listStorageWorkRequests");
        ListStorageWorkRequestsRequest interceptedRequest = ListStorageWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStorageWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStorageWorkRequestsResponse> transformer = ListStorageWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStorageWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStorageWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStorageWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSupportedCharEncodingsResponse listSupportedCharEncodings(ListSupportedCharEncodingsRequest request) {
        LOG.trace("Called listSupportedCharEncodings");
        ListSupportedCharEncodingsRequest interceptedRequest = ListSupportedCharEncodingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSupportedCharEncodingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSupportedCharEncodingsResponse> transformer = ListSupportedCharEncodingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSupportedCharEncodingsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSupportedCharEncodingsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSupportedCharEncodingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSupportedTimezonesResponse listSupportedTimezones(ListSupportedTimezonesRequest request) {
        LOG.trace("Called listSupportedTimezones");
        ListSupportedTimezonesRequest interceptedRequest = ListSupportedTimezonesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSupportedTimezonesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSupportedTimezonesResponse> transformer = ListSupportedTimezonesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSupportedTimezonesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSupportedTimezonesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSupportedTimezonesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUploadFilesResponse listUploadFiles(ListUploadFilesRequest request) {
        LOG.trace("Called listUploadFiles");
        ListUploadFilesRequest interceptedRequest = ListUploadFilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadFilesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUploadFilesResponse> transformer = ListUploadFilesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUploadFilesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUploadFilesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUploadFilesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUploadWarningsResponse listUploadWarnings(ListUploadWarningsRequest request) {
        LOG.trace("Called listUploadWarnings");
        ListUploadWarningsRequest interceptedRequest = ListUploadWarningsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadWarningsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUploadWarningsResponse> transformer = ListUploadWarningsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUploadWarningsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUploadWarningsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUploadWarningsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListUploadsResponse listUploads(ListUploadsRequest request) {
        LOG.trace("Called listUploads");
        ListUploadsRequest interceptedRequest = ListUploadsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUploadsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUploadsResponse> transformer = ListUploadsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListUploadsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUploadsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUploadsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWarningsResponse listWarnings(ListWarningsRequest request) {
        LOG.trace("Called listWarnings");
        ListWarningsRequest interceptedRequest = ListWarningsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWarningsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWarningsResponse> transformer = ListWarningsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWarningsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWarningsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWarningsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public OffboardNamespaceResponse offboardNamespace(OffboardNamespaceRequest request) {
        LOG.trace("Called offboardNamespace");
        OffboardNamespaceRequest interceptedRequest = OffboardNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = OffboardNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, OffboardNamespaceResponse> transformer = OffboardNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (OffboardNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (OffboardNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (OffboardNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public OnboardNamespaceResponse onboardNamespace(OnboardNamespaceRequest request) {
        LOG.trace("Called onboardNamespace");
        OnboardNamespaceRequest interceptedRequest = OnboardNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = OnboardNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, OnboardNamespaceResponse> transformer = OnboardNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (OnboardNamespaceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (OnboardNamespaceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (OnboardNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ParseQueryResponse parseQuery(ParseQueryRequest request) {
        LOG.trace("Called parseQuery");
        ParseQueryRequest interceptedRequest = ParseQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ParseQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ParseQueryResponse> transformer = ParseQueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ParseQueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ParseQueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getParseQueryDetails(), (BmcRequest)retriedRequest);
                return (ParseQueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PauseScheduledTaskResponse pauseScheduledTask(PauseScheduledTaskRequest request) {
        LOG.trace("Called pauseScheduledTask");
        PauseScheduledTaskRequest interceptedRequest = PauseScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PauseScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PauseScheduledTaskResponse> transformer = PauseScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PauseScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PauseScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (PauseScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PurgeStorageDataResponse purgeStorageData(PurgeStorageDataRequest request) {
        LOG.trace("Called purgeStorageData");
        PurgeStorageDataRequest interceptedRequest = PurgeStorageDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PurgeStorageDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PurgeStorageDataResponse> transformer = PurgeStorageDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (PurgeStorageDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PurgeStorageDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getPurgeStorageDataDetails(), (BmcRequest)retriedRequest);
                return (PurgeStorageDataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PutQueryWorkRequestBackgroundResponse putQueryWorkRequestBackground(PutQueryWorkRequestBackgroundRequest request) {
        LOG.trace("Called putQueryWorkRequestBackground");
        PutQueryWorkRequestBackgroundRequest interceptedRequest = PutQueryWorkRequestBackgroundConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutQueryWorkRequestBackgroundConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PutQueryWorkRequestBackgroundResponse> transformer = PutQueryWorkRequestBackgroundConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PutQueryWorkRequestBackgroundResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PutQueryWorkRequestBackgroundResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (BmcRequest)retriedRequest);
                return (PutQueryWorkRequestBackgroundResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public QueryResponse query(QueryRequest request) {
        LOG.trace("Called query");
        QueryRequest interceptedRequest = QueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = QueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, QueryResponse> transformer = QueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (QueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (QueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getQueryDetails(), (BmcRequest)retriedRequest);
                return (QueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RecallArchivedDataResponse recallArchivedData(RecallArchivedDataRequest request) {
        LOG.trace("Called recallArchivedData");
        RecallArchivedDataRequest interceptedRequest = RecallArchivedDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RecallArchivedDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RecallArchivedDataResponse> transformer = RecallArchivedDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RecallArchivedDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RecallArchivedDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRecallArchivedDataDetails(), (BmcRequest)retriedRequest);
                return (RecallArchivedDataResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterLookupResponse registerLookup(RegisterLookupRequest request) {
        LOG.trace("Called registerLookup");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (RegisterLookupRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)RegisterLookupRequest.builder());
            }
            RegisterLookupRequest interceptedRequest = RegisterLookupConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = RegisterLookupConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, RegisterLookupResponse> transformer = RegisterLookupConverter.fromResponse();
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RegisterLookupResponse registerLookupResponse = (RegisterLookupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (RegisterLookupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getRegisterLookupContentFileBody(), (BmcRequest)retriedRequest);
                        return (RegisterLookupResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getRegisterLookupContentFileBody(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return registerLookupResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getRegisterLookupContentFileBody());
        }
    }

    @Override
    public ReleaseRecalledDataResponse releaseRecalledData(ReleaseRecalledDataRequest request) {
        LOG.trace("Called releaseRecalledData");
        ReleaseRecalledDataRequest interceptedRequest = ReleaseRecalledDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReleaseRecalledDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ReleaseRecalledDataResponse> transformer = ReleaseRecalledDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ReleaseRecalledDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ReleaseRecalledDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getReleaseRecalledDataDetails(), (BmcRequest)retriedRequest);
                return (ReleaseRecalledDataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveEntityAssociationsResponse removeEntityAssociations(RemoveEntityAssociationsRequest request) {
        LOG.trace("Called removeEntityAssociations");
        RemoveEntityAssociationsRequest interceptedRequest = RemoveEntityAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveEntityAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveEntityAssociationsResponse> transformer = RemoveEntityAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveEntityAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveEntityAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemoveEntityAssociationsDetails(), (BmcRequest)retriedRequest);
                return (RemoveEntityAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResumeScheduledTaskResponse resumeScheduledTask(ResumeScheduledTaskRequest request) {
        LOG.trace("Called resumeScheduledTask");
        ResumeScheduledTaskRequest interceptedRequest = ResumeScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResumeScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ResumeScheduledTaskResponse> transformer = ResumeScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ResumeScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ResumeScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ResumeScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RunResponse run(RunRequest request) {
        LOG.trace("Called run");
        RunRequest interceptedRequest = RunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RunResponse> transformer = RunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SuggestResponse suggest(SuggestRequest request) {
        LOG.trace("Called suggest");
        SuggestRequest interceptedRequest = SuggestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SuggestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SuggestResponse> transformer = SuggestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SuggestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SuggestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getSuggestDetails(), (BmcRequest)retriedRequest);
                return (SuggestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SuppressWarningResponse suppressWarning(SuppressWarningRequest request) {
        LOG.trace("Called suppressWarning");
        SuppressWarningRequest interceptedRequest = SuppressWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SuppressWarningConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SuppressWarningResponse> transformer = SuppressWarningConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (SuppressWarningResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SuppressWarningResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getWarningReferenceDetails(), (BmcRequest)retriedRequest);
                return (SuppressWarningResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TestParserResponse testParser(TestParserRequest request) {
        LOG.trace("Called testParser");
        TestParserRequest interceptedRequest = TestParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TestParserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TestParserResponse> transformer = TestParserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (TestParserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (TestParserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getTestParserPayloadDetails(), (BmcRequest)retriedRequest);
                return (TestParserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UnsuppressWarningResponse unsuppressWarning(UnsuppressWarningRequest request) {
        LOG.trace("Called unsuppressWarning");
        UnsuppressWarningRequest interceptedRequest = UnsuppressWarningConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UnsuppressWarningConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UnsuppressWarningResponse> transformer = UnsuppressWarningConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UnsuppressWarningResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UnsuppressWarningResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getWarningReferenceDetails(), (BmcRequest)retriedRequest);
                return (UnsuppressWarningResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogAnalyticsEntityResponse updateLogAnalyticsEntity(UpdateLogAnalyticsEntityRequest request) {
        LOG.trace("Called updateLogAnalyticsEntity");
        UpdateLogAnalyticsEntityRequest interceptedRequest = UpdateLogAnalyticsEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsEntityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogAnalyticsEntityResponse> transformer = UpdateLogAnalyticsEntityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogAnalyticsEntityResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogAnalyticsEntityResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogAnalyticsEntityDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogAnalyticsEntityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogAnalyticsEntityTypeResponse updateLogAnalyticsEntityType(UpdateLogAnalyticsEntityTypeRequest request) {
        LOG.trace("Called updateLogAnalyticsEntityType");
        UpdateLogAnalyticsEntityTypeRequest interceptedRequest = UpdateLogAnalyticsEntityTypeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsEntityTypeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogAnalyticsEntityTypeResponse> transformer = UpdateLogAnalyticsEntityTypeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogAnalyticsEntityTypeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogAnalyticsEntityTypeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogAnalyticsEntityTypeDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogAnalyticsEntityTypeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogAnalyticsLogGroupResponse updateLogAnalyticsLogGroup(UpdateLogAnalyticsLogGroupRequest request) {
        LOG.trace("Called updateLogAnalyticsLogGroup");
        UpdateLogAnalyticsLogGroupRequest interceptedRequest = UpdateLogAnalyticsLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogAnalyticsLogGroupResponse> transformer = UpdateLogAnalyticsLogGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogAnalyticsLogGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogAnalyticsLogGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogAnalyticsLogGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogAnalyticsLogGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLogAnalyticsObjectCollectionRuleResponse updateLogAnalyticsObjectCollectionRule(UpdateLogAnalyticsObjectCollectionRuleRequest request) {
        LOG.trace("Called updateLogAnalyticsObjectCollectionRule");
        UpdateLogAnalyticsObjectCollectionRuleRequest interceptedRequest = UpdateLogAnalyticsObjectCollectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogAnalyticsObjectCollectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogAnalyticsObjectCollectionRuleResponse> transformer = UpdateLogAnalyticsObjectCollectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateLogAnalyticsObjectCollectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLogAnalyticsObjectCollectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLogAnalyticsObjectCollectionRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateLogAnalyticsObjectCollectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLookupResponse updateLookup(UpdateLookupRequest request) {
        LOG.trace("Called updateLookup");
        UpdateLookupRequest interceptedRequest = UpdateLookupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLookupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLookupResponse> transformer = UpdateLookupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateLookupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateLookupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateLookupMetadataDetails(), (BmcRequest)retriedRequest);
                return (UpdateLookupResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLookupDataResponse updateLookupData(UpdateLookupDataRequest request) {
        LOG.trace("Called updateLookupData");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (UpdateLookupDataRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UpdateLookupDataRequest.builder());
            }
            UpdateLookupDataRequest interceptedRequest = UpdateLookupDataConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = UpdateLookupDataConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, UpdateLookupDataResponse> transformer = UpdateLookupDataConverter.fromResponse();
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            UpdateLookupDataResponse updateLookupDataResponse = (UpdateLookupDataResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (UpdateLookupDataResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getUpdateLookupFileBody(), (BmcRequest)retriedRequest);
                        return (UpdateLookupDataResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUpdateLookupFileBody(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return updateLookupDataResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getUpdateLookupFileBody());
        }
    }

    @Override
    public UpdateScheduledTaskResponse updateScheduledTask(UpdateScheduledTaskRequest request) {
        LOG.trace("Called updateScheduledTask");
        UpdateScheduledTaskRequest interceptedRequest = UpdateScheduledTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledTaskConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateScheduledTaskResponse> transformer = UpdateScheduledTaskConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateScheduledTaskResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateScheduledTaskResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateScheduledTaskDetails(), (BmcRequest)retriedRequest);
                return (UpdateScheduledTaskResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStorageResponse updateStorage(UpdateStorageRequest request) {
        LOG.trace("Called updateStorage");
        UpdateStorageRequest interceptedRequest = UpdateStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStorageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStorageResponse> transformer = UpdateStorageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateStorageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStorageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStorageDetails(), (BmcRequest)retriedRequest);
                return (UpdateStorageResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadLogFileResponse uploadLogFile(UploadLogFileRequest request) {
        LOG.trace("Called uploadLogFile");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (UploadLogFileRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UploadLogFileRequest.builder());
            }
            UploadLogFileRequest interceptedRequest = UploadLogFileConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = UploadLogFileConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, UploadLogFileResponse> transformer = UploadLogFileConverter.fromResponse();
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            UploadLogFileResponse uploadLogFileResponse = (UploadLogFileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (UploadLogFileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getUploadLogFileBody(), (BmcRequest)retriedRequest);
                        return (UploadLogFileResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUploadLogFileBody(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return uploadLogFileResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getUploadLogFileBody());
        }
    }

    @Override
    public UpsertAssociationsResponse upsertAssociations(UpsertAssociationsRequest request) {
        LOG.trace("Called upsertAssociations");
        UpsertAssociationsRequest interceptedRequest = UpsertAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpsertAssociationsResponse> transformer = UpsertAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpsertAssociationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpsertAssociationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsAssociationDetails(), (BmcRequest)retriedRequest);
                return (UpsertAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpsertFieldResponse upsertField(UpsertFieldRequest request) {
        LOG.trace("Called upsertField");
        UpsertFieldRequest interceptedRequest = UpsertFieldConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertFieldConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpsertFieldResponse> transformer = UpsertFieldConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpsertFieldResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpsertFieldResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsFieldDetails(), (BmcRequest)retriedRequest);
                return (UpsertFieldResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpsertLabelResponse upsertLabel(UpsertLabelRequest request) {
        LOG.trace("Called upsertLabel");
        UpsertLabelRequest interceptedRequest = UpsertLabelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertLabelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpsertLabelResponse> transformer = UpsertLabelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpsertLabelResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpsertLabelResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsLabelDetails(), (BmcRequest)retriedRequest);
                return (UpsertLabelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpsertParserResponse upsertParser(UpsertParserRequest request) {
        LOG.trace("Called upsertParser");
        UpsertParserRequest interceptedRequest = UpsertParserConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertParserConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpsertParserResponse> transformer = UpsertParserConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpsertParserResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpsertParserResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsParserDetails(), (BmcRequest)retriedRequest);
                return (UpsertParserResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpsertSourceResponse upsertSource(UpsertSourceRequest request) {
        LOG.trace("Called upsertSource");
        UpsertSourceRequest interceptedRequest = UpsertSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpsertSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpsertSourceResponse> transformer = UpsertSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpsertSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpsertSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsSourceDetails(), (BmcRequest)retriedRequest);
                return (UpsertSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateAssociationParametersResponse validateAssociationParameters(ValidateAssociationParametersRequest request) {
        LOG.trace("Called validateAssociationParameters");
        ValidateAssociationParametersRequest interceptedRequest = ValidateAssociationParametersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateAssociationParametersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateAssociationParametersResponse> transformer = ValidateAssociationParametersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ValidateAssociationParametersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateAssociationParametersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsAssociationDetails(), (BmcRequest)retriedRequest);
                return (ValidateAssociationParametersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateFileResponse validateFile(ValidateFileRequest request) {
        LOG.trace("Called validateFile");
        ValidateFileRequest interceptedRequest = ValidateFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateFileResponse> transformer = ValidateFileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ValidateFileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateFileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ValidateFileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateSourceResponse validateSource(ValidateSourceRequest request) {
        LOG.trace("Called validateSource");
        ValidateSourceRequest interceptedRequest = ValidateSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateSourceResponse> transformer = ValidateSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ValidateSourceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateSourceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpsertLogAnalyticsSourceDetails(), (BmcRequest)retriedRequest);
                return (ValidateSourceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateSourceExtendedFieldDetailsResponse validateSourceExtendedFieldDetails(ValidateSourceExtendedFieldDetailsRequest request) {
        LOG.trace("Called validateSourceExtendedFieldDetails");
        ValidateSourceExtendedFieldDetailsRequest interceptedRequest = ValidateSourceExtendedFieldDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceExtendedFieldDetailsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateSourceExtendedFieldDetailsResponse> transformer = ValidateSourceExtendedFieldDetailsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ValidateSourceExtendedFieldDetailsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateSourceExtendedFieldDetailsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getLogAnalyticsSource(), (BmcRequest)retriedRequest);
                return (ValidateSourceExtendedFieldDetailsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateSourceMappingResponse validateSourceMapping(ValidateSourceMappingRequest request) {
        LOG.trace("Called validateSourceMapping");
        ValidateSourceMappingRequest interceptedRequest = ValidateSourceMappingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateSourceMappingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateSourceMappingResponse> transformer = ValidateSourceMappingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ValidateSourceMappingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ValidateSourceMappingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ValidateSourceMappingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LogAnalyticsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public LogAnalyticsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LogAnalyticsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public LogAnalyticsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LogAnalyticsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

