/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.requests.DeleteUploadRequest;
import com.oracle.bmc.loganalytics.responses.DeleteUploadResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteUploadConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteUploadConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteUploadRequest interceptRequest(DeleteUploadRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteUploadRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUploadReference(), (String)"uploadReference must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("uploads").path(HttpUtils.encodePathSegment((String)request.getUploadReference()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, DeleteUploadResponse> fromResponse() {
        Function<Response, DeleteUploadResponse> transformer = new Function<Response, DeleteUploadResponse>(){

            public DeleteUploadResponse apply(Response rawResponse) {
                Optional opcDeletedLogfileCountHeader;
                Optional opcDeletedLogCountHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.DeleteUploadResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteUploadResponse.Builder builder = DeleteUploadResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcDeletedLogCountHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-deleted-log-count")).isPresent()) {
                    builder.opcDeletedLogCount((Long)HeaderUtils.toValue((String)"opc-deleted-log-count", (String)((String)((List)opcDeletedLogCountHeader.get()).get(0)), Long.class));
                }
                if ((opcDeletedLogfileCountHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-deleted-logfile-count")).isPresent()) {
                    builder.opcDeletedLogfileCount((Long)HeaderUtils.toValue((String)"opc-deleted-logfile-count", (String)((String)((List)opcDeletedLogfileCountHeader.get()).get(0)), Long.class));
                }
                DeleteUploadResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

