/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.ExtractLogHeaderResults;
import com.oracle.bmc.loganalytics.requests.ExtractStructuredLogHeaderPathsRequest;
import com.oracle.bmc.loganalytics.responses.ExtractStructuredLogHeaderPathsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractStructuredLogHeaderPathsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractStructuredLogHeaderPathsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ExtractStructuredLogHeaderPathsRequest interceptRequest(ExtractStructuredLogHeaderPathsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ExtractStructuredLogHeaderPathsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getLoganParserDetails(), (String)"loganParserDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("parsers").path("actions").path("extractLogHeaderPaths");
        if (request.getParserType() != null) {
            target = target.queryParam("parserType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getParserType().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ExtractStructuredLogHeaderPathsResponse> fromResponse() {
        Function<Response, ExtractStructuredLogHeaderPathsResponse> transformer = new Function<Response, ExtractStructuredLogHeaderPathsResponse>(){

            public ExtractStructuredLogHeaderPathsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ExtractStructuredLogHeaderPathsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExtractLogHeaderResults.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ExtractStructuredLogHeaderPathsResponse.Builder builder = ExtractStructuredLogHeaderPathsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.extractLogHeaderResults((ExtractLogHeaderResults)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ExtractStructuredLogHeaderPathsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

