/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLookupCollection;
import com.oracle.bmc.loganalytics.requests.ListLookupsRequest;
import com.oracle.bmc.loganalytics.responses.ListLookupsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLookupsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListLookupsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListLookupsRequest interceptRequest(ListLookupsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListLookupsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getType()), (String)"type is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("lookups");
        if (request.getLookupDisplayText() != null) {
            target = target.queryParam("lookupDisplayText", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLookupDisplayText())});
        }
        target = target.queryParam("type", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getType().getValue())});
        if (request.getIsSystem() != null) {
            target = target.queryParam("isSystem", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsSystem().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getStatus() != null) {
            target = target.queryParam("status", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStatus().getValue())});
        }
        if (request.getIsHideSpecial() != null) {
            target = target.queryParam("isHideSpecial", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsHideSpecial())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListLookupsResponse> fromResponse() {
        Function<Response, ListLookupsResponse> transformer = new Function<Response, ListLookupsResponse>(){

            public ListLookupsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ListLookupsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsLookupCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListLookupsResponse.Builder builder = ListLookupsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsLookupCollection((LogAnalyticsLookupCollection)response.getItem());
                Optional opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page");
                if (opcPrevPageHeader.isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListLookupsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

