/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsAssociationCollection;
import com.oracle.bmc.loganalytics.requests.ListSourceAssociationsRequest;
import com.oracle.bmc.loganalytics.responses.ListSourceAssociationsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSourceAssociationsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSourceAssociationsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSourceAssociationsRequest interceptRequest(ListSourceAssociationsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSourceAssociationsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getSourceName(), (String)"sourceName is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("sourceAssociations");
        target = target.queryParam("sourceName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceName())});
        if (request.getEntityId() != null) {
            target = target.queryParam("entityId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEntityId())});
        }
        if (request.getLifeCycleState() != null) {
            target = target.queryParam("lifeCycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifeCycleState().getValue())});
        }
        if (request.getIsShowTotal() != null) {
            target = target.queryParam("isShowTotal", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsShowTotal())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListSourceAssociationsResponse> fromResponse() {
        Function<Response, ListSourceAssociationsResponse> transformer = new Function<Response, ListSourceAssociationsResponse>(){

            public ListSourceAssociationsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ListSourceAssociationsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsAssociationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListSourceAssociationsResponse.Builder builder = ListSourceAssociationsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsAssociationCollection((LogAnalyticsAssociationCollection)response.getItem());
                Optional opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page");
                if (opcPrevPageHeader.isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListSourceAssociationsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

