/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLookup;
import com.oracle.bmc.loganalytics.requests.RegisterLookupRequest;
import com.oracle.bmc.loganalytics.responses.RegisterLookupResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterLookupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterLookupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RegisterLookupRequest interceptRequest(RegisterLookupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RegisterLookupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getType()), (String)"type is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRegisterLookupContentFileBody(), (String)"registerLookupContentFileBody is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("lookups").path("actions").path("register");
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getDescription() != null) {
            target = target.queryParam("description", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDescription())});
        }
        if (request.getCharEncoding() != null) {
            target = target.queryParam("charEncoding", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCharEncoding())});
        }
        if (request.getIsHidden() != null) {
            target = target.queryParam("isHidden", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsHidden())});
        }
        target = target.queryParam("type", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getType().getValue())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RegisterLookupResponse> fromResponse() {
        Function<Response, RegisterLookupResponse> transformer = new Function<Response, RegisterLookupResponse>(){

            public RegisterLookupResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.RegisterLookupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsLookup.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RegisterLookupResponse.Builder builder = RegisterLookupResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsLookup((LogAnalyticsLookup)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RegisterLookupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

