/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.Upload;
import com.oracle.bmc.loganalytics.requests.UploadLogFileRequest;
import com.oracle.bmc.loganalytics.responses.UploadLogFileResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadLogFileConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UploadLogFileConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UploadLogFileRequest interceptRequest(UploadLogFileRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UploadLogFileRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUploadName(), (String)"uploadName is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getLogSourceName(), (String)"logSourceName is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getFilename(), (String)"filename is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getOpcMetaLoggrpid(), (String)"opcMetaLoggrpid is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUploadLogFileBody(), (String)"uploadLogFileBody is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("actions").path("uploadLogFile");
        target = target.queryParam("uploadName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUploadName())});
        target = target.queryParam("logSourceName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLogSourceName())});
        if (request.getEntityId() != null) {
            target = target.queryParam("entityId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEntityId())});
        }
        if (request.getTimezone() != null) {
            target = target.queryParam("timezone", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimezone())});
        }
        if (request.getCharEncoding() != null) {
            target = target.queryParam("charEncoding", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCharEncoding())});
        }
        if (request.getDateFormat() != null) {
            target = target.queryParam("dateFormat", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDateFormat())});
        }
        if (request.getDateYear() != null) {
            target = target.queryParam("dateYear", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDateYear())});
        }
        if (request.getInvalidateCache() != null) {
            target = target.queryParam("invalidateCache", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getInvalidateCache())});
        }
        target = target.queryParam("filename", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilename())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getContentMd5() != null) {
            ib.header("content-md5", (Object)request.getContentMd5());
        }
        if (request.getContentType() != null) {
            ib.header("content-type", (Object)request.getContentType());
        }
        ib.header("opc-meta-loggrpid", (Object)request.getOpcMetaLoggrpid());
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, UploadLogFileResponse> fromResponse() {
        Function<Response, UploadLogFileResponse> transformer = new Function<Response, UploadLogFileResponse>(){

            public UploadLogFileResponse apply(Response rawResponse) {
                Optional opcObjectIdHeader;
                Optional opcContentMd5Header;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.UploadLogFileResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Upload.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UploadLogFileResponse.Builder builder = UploadLogFileResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.upload((Upload)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcContentMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-content-md5")).isPresent()) {
                    builder.opcContentMd5((String)HeaderUtils.toValue((String)"opc-content-md5", (String)((String)((List)opcContentMd5Header.get()).get(0)), String.class));
                }
                if ((opcObjectIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-object-id")).isPresent()) {
                    builder.opcObjectId((String)HeaderUtils.toValue((String)"opc-object-id", (String)((String)((List)opcObjectIdHeader.get()).get(0)), String.class));
                }
                UploadLogFileResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

