/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSource;
import com.oracle.bmc.loganalytics.requests.UpsertSourceRequest;
import com.oracle.bmc.loganalytics.responses.UpsertSourceResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertSourceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpsertSourceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpsertSourceRequest interceptRequest(UpsertSourceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpsertSourceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpsertLogAnalyticsSourceDetails(), (String)"upsertLogAnalyticsSourceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("sources").path("actions").path("upsert");
        if (request.getCreateLikeSourceId() != null) {
            target = target.queryParam("createLikeSourceId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreateLikeSourceId())});
        }
        if (request.getIsIncremental() != null) {
            target = target.queryParam("isIncremental", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsIncremental())});
        }
        if (request.getIsIgnoreWarning() != null) {
            target = target.queryParam("isIgnoreWarning", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsIgnoreWarning())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpsertSourceResponse> fromResponse() {
        Function<Response, UpsertSourceResponse> transformer = new Function<Response, UpsertSourceResponse>(){

            public UpsertSourceResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.UpsertSourceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsSource.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpsertSourceResponse.Builder builder = UpsertSourceResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsSource((LogAnalyticsSource)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpsertSourceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

