/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Filter {
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="values")
    private final List<Object> values;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fieldName(this.fieldName).values(this.values).operator(this.operator);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        List<Object> this$values = this.getValues();
        List<Object> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        List<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Filter(fieldName=" + this.getFieldName() + ", values=" + this.getValues() + ", operator=" + (Object)((Object)this.getOperator()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"fieldName", "values", "operator"})
    @Deprecated
    public Filter(String fieldName, List<Object> values, Operator operator) {
        this.fieldName = fieldName;
        this.values = values;
        this.operator = operator;
    }

    public static enum Operator {
        Clear("CLEAR"),
        Replace("REPLACE"),
        Equals("EQUALS"),
        NotEquals("NOT_EQUALS"),
        StartsWith("STARTS_WITH"),
        DoesNotStartWith("DOES_NOT_START_WITH"),
        EndsWith("ENDS_WITH"),
        DoesNotEndWith("DOES_NOT_END_WITH"),
        Contains("CONTAINS"),
        DoesNotContain("DOES_NOT_CONTAIN"),
        IsLessThan("IS_LESS_THAN"),
        IsLessThanOrEqualTo("IS_LESS_THAN_OR_EQUAL_TO"),
        IsGreaterThan("IS_GREATER_THAN"),
        IsGreaterThanOrEqualTo("IS_GREATER_THAN_OR_EQUAL_TO"),
        IsBetween("IS_BETWEEN"),
        IsNotBetween("IS_NOT_BETWEEN"),
        AddSubquery("ADD_SUBQUERY"),
        ClearSubquery("CLEAR_SUBQUERY");

        private final String value;
        private static Map<String, Operator> map;

        private Operator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Operator: " + key);
        }

        static {
            map = new HashMap<String, Operator>();
            for (Operator v : Operator.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="values")
        private List<Object> values;
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder values(List<Object> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Filter build() {
            Filter __instance__ = new Filter(this.fieldName, this.values, this.operator);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Filter o) {
            Builder copiedBuilder = this.fieldName(o.getFieldName()).values(o.getValues()).operator(o.getOperator());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Filter.Builder(fieldName=" + this.fieldName + ", values=" + this.values + ", operator=" + (Object)((Object)this.operator) + ")";
        }
    }
}

