/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsConfigWorkRequestSummary {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="percentComplete")
    private final Long percentComplete;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).operationType(this.operationType).percentComplete(this.percentComplete).timeFinished(this.timeFinished).timeAccepted(this.timeAccepted).lifecycleState(this.lifecycleState);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Long getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogAnalyticsConfigWorkRequestSummary)) {
            return false;
        }
        LogAnalyticsConfigWorkRequestSummary other = (LogAnalyticsConfigWorkRequestSummary)o;
        Long this$percentComplete = this.getPercentComplete();
        Long other$percentComplete = other.getPercentComplete();
        if (this$percentComplete == null ? other$percentComplete != null : !((Object)this$percentComplete).equals(other$percentComplete)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        Date this$timeFinished = this.getTimeFinished();
        Date other$timeFinished = other.getTimeFinished();
        if (this$timeFinished == null ? other$timeFinished != null : !((Object)this$timeFinished).equals(other$timeFinished)) {
            return false;
        }
        Date this$timeAccepted = this.getTimeAccepted();
        Date other$timeAccepted = other.getTimeAccepted();
        if (this$timeAccepted == null ? other$timeAccepted != null : !((Object)this$timeAccepted).equals(other$timeAccepted)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $percentComplete = this.getPercentComplete();
        result = result * 59 + ($percentComplete == null ? 43 : ((Object)$percentComplete).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        Date $timeFinished = this.getTimeFinished();
        result = result * 59 + ($timeFinished == null ? 43 : ((Object)$timeFinished).hashCode());
        Date $timeAccepted = this.getTimeAccepted();
        result = result * 59 + ($timeAccepted == null ? 43 : ((Object)$timeAccepted).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "LogAnalyticsConfigWorkRequestSummary(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", percentComplete=" + this.getPercentComplete() + ", timeFinished=" + this.getTimeFinished() + ", timeAccepted=" + this.getTimeAccepted() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "operationType", "percentComplete", "timeFinished", "timeAccepted", "lifecycleState"})
    @Deprecated
    public LogAnalyticsConfigWorkRequestSummary(String id, String compartmentId, OperationType operationType, Long percentComplete, Date timeFinished, Date timeAccepted, LifecycleState lifecycleState) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.operationType = operationType;
        this.percentComplete = percentComplete;
        this.timeFinished = timeFinished;
        this.timeAccepted = timeAccepted;
        this.lifecycleState = lifecycleState;
    }

    public static enum LifecycleState {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationType {
        CreateAssociations("CREATE_ASSOCIATIONS"),
        DeleteAssociations("DELETE_ASSOCIATIONS"),
        AppendLookupData("APPEND_LOOKUP_DATA"),
        UpdateLookupData("UPDATE_LOOKUP_DATA"),
        DeleteLookup("DELETE_LOOKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="percentComplete")
        private Long percentComplete;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder percentComplete(Long percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public LogAnalyticsConfigWorkRequestSummary build() {
            LogAnalyticsConfigWorkRequestSummary __instance__ = new LogAnalyticsConfigWorkRequestSummary(this.id, this.compartmentId, this.operationType, this.percentComplete, this.timeFinished, this.timeAccepted, this.lifecycleState);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsConfigWorkRequestSummary o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).operationType(o.getOperationType()).percentComplete(o.getPercentComplete()).timeFinished(o.getTimeFinished()).timeAccepted(o.getTimeAccepted()).lifecycleState(o.getLifecycleState());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "LogAnalyticsConfigWorkRequestSummary.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", operationType=" + (Object)((Object)this.operationType) + ", percentComplete=" + this.percentComplete + ", timeFinished=" + this.timeFinished + ", timeAccepted=" + this.timeAccepted + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

