/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteFieldRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String fieldName;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"namespaceName", "fieldName", "opcRetryToken", "opcRequestId", "ifMatch"})
    DeleteFieldRequest(String namespaceName, String fieldName, String opcRetryToken, String opcRequestId, String ifMatch) {
        this.namespaceName = namespaceName;
        this.fieldName = fieldName;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteFieldRequest, Void> {
        private String namespaceName;
        private String fieldName;
        private String opcRetryToken;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteFieldRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.fieldName(o.getFieldName());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteFieldRequest build() {
            DeleteFieldRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteFieldRequest buildWithoutInvocationCallback() {
            return new DeleteFieldRequest(this.namespaceName, this.fieldName, this.opcRetryToken, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteFieldRequest.Builder(namespaceName=" + this.namespaceName + ", fieldName=" + this.fieldName + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

