/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteScheduledTaskRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String scheduledTaskId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"namespaceName", "scheduledTaskId", "opcRequestId", "ifMatch"})
    DeleteScheduledTaskRequest(String namespaceName, String scheduledTaskId, String opcRequestId, String ifMatch) {
        this.namespaceName = namespaceName;
        this.scheduledTaskId = scheduledTaskId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteScheduledTaskRequest, Void> {
        private String namespaceName;
        private String scheduledTaskId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteScheduledTaskRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteScheduledTaskRequest build() {
            DeleteScheduledTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteScheduledTaskRequest buildWithoutInvocationCallback() {
            return new DeleteScheduledTaskRequest(this.namespaceName, this.scheduledTaskId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteScheduledTaskRequest.Builder(namespaceName=" + this.namespaceName + ", scheduledTaskId=" + this.scheduledTaskId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

