/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.ExportContent;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ExportCustomContentRequest
extends BmcRequest<ExportContent> {
    private String namespaceName;
    private ExportContent exportCustomContentDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public ExportContent getBody$() {
        return this.exportCustomContentDetails;
    }

    @ConstructorProperties(value={"namespaceName", "exportCustomContentDetails", "opcRetryToken", "opcRequestId"})
    ExportCustomContentRequest(String namespaceName, ExportContent exportCustomContentDetails, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.exportCustomContentDetails = exportCustomContentDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ExportContent getExportCustomContentDetails() {
        return this.exportCustomContentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportCustomContentRequest, ExportContent> {
        private String namespaceName;
        private ExportContent exportCustomContentDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportCustomContentRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.exportCustomContentDetails(o.getExportCustomContentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportCustomContentRequest build() {
            ExportCustomContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportContent body) {
            this.exportCustomContentDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder exportCustomContentDetails(ExportContent exportCustomContentDetails) {
            this.exportCustomContentDetails = exportCustomContentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ExportCustomContentRequest buildWithoutInvocationCallback() {
            return new ExportCustomContentRequest(this.namespaceName, this.exportCustomContentDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "ExportCustomContentRequest.Builder(namespaceName=" + this.namespaceName + ", exportCustomContentDetails=" + this.exportCustomContentDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

