/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.ExportDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ExportQueryResultRequest
extends BmcRequest<ExportDetails> {
    private String namespaceName;
    private ExportDetails exportDetails;
    private String opcRequestId;

    @InternalSdk
    public ExportDetails getBody$() {
        return this.exportDetails;
    }

    @ConstructorProperties(value={"namespaceName", "exportDetails", "opcRequestId"})
    ExportQueryResultRequest(String namespaceName, ExportDetails exportDetails, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.exportDetails = exportDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ExportDetails getExportDetails() {
        return this.exportDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportQueryResultRequest, ExportDetails> {
        private String namespaceName;
        private ExportDetails exportDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportQueryResultRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.exportDetails(o.getExportDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportQueryResultRequest build() {
            ExportQueryResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportDetails body) {
            this.exportDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder exportDetails(ExportDetails exportDetails) {
            this.exportDetails = exportDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ExportQueryResultRequest buildWithoutInvocationCallback() {
            return new ExportQueryResultRequest(this.namespaceName, this.exportDetails, this.opcRequestId);
        }

        public String toString() {
            return "ExportQueryResultRequest.Builder(namespaceName=" + this.namespaceName + ", exportDetails=" + this.exportDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

