/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParser;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ExtractStructuredLogHeaderPathsRequest
extends BmcRequest<LogAnalyticsParser> {
    private String namespaceName;
    private LogAnalyticsParser loganParserDetails;
    private ParserType parserType;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public LogAnalyticsParser getBody$() {
        return this.loganParserDetails;
    }

    @ConstructorProperties(value={"namespaceName", "loganParserDetails", "parserType", "opcRetryToken", "opcRequestId"})
    ExtractStructuredLogHeaderPathsRequest(String namespaceName, LogAnalyticsParser loganParserDetails, ParserType parserType, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.loganParserDetails = loganParserDetails;
        this.parserType = parserType;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LogAnalyticsParser getLoganParserDetails() {
        return this.loganParserDetails;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ExtractStructuredLogHeaderPathsRequest, LogAnalyticsParser> {
        private String namespaceName;
        private LogAnalyticsParser loganParserDetails;
        private ParserType parserType;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExtractStructuredLogHeaderPathsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.loganParserDetails(o.getLoganParserDetails());
            this.parserType(o.getParserType());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExtractStructuredLogHeaderPathsRequest build() {
            ExtractStructuredLogHeaderPathsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LogAnalyticsParser body) {
            this.loganParserDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder loganParserDetails(LogAnalyticsParser loganParserDetails) {
            this.loganParserDetails = loganParserDetails;
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ExtractStructuredLogHeaderPathsRequest buildWithoutInvocationCallback() {
            return new ExtractStructuredLogHeaderPathsRequest(this.namespaceName, this.loganParserDetails, this.parserType, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "ExtractStructuredLogHeaderPathsRequest.Builder(namespaceName=" + this.namespaceName + ", loganParserDetails=" + this.loganParserDetails + ", parserType=" + (Object)((Object)this.parserType) + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum ParserType {
        Xml("XML"),
        Json("JSON");

        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ParserType: " + key);
        }

        static {
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

