/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetStorageWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String namespaceName;
    private String opcRequestId;

    @ConstructorProperties(value={"workRequestId", "namespaceName", "opcRequestId"})
    GetStorageWorkRequestRequest(String workRequestId, String namespaceName, String opcRequestId) {
        this.workRequestId = workRequestId;
        this.namespaceName = namespaceName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStorageWorkRequestRequest, Void> {
        private String workRequestId;
        private String namespaceName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStorageWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStorageWorkRequestRequest build() {
            GetStorageWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetStorageWorkRequestRequest buildWithoutInvocationCallback() {
            return new GetStorageWorkRequestRequest(this.workRequestId, this.namespaceName, this.opcRequestId);
        }

        public String toString() {
            return "GetStorageWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ", namespaceName=" + this.namespaceName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

