/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListFieldsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private Boolean isMatchAll;
    private String sourceIds;
    private String sourceNames;
    private ParserType parserType;
    private String parserIds;
    private String parserNames;
    private Boolean isIncludeParser;
    private String filter;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "isMatchAll", "sourceIds", "sourceNames", "parserType", "parserIds", "parserNames", "isIncludeParser", "filter", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListFieldsRequest(String namespaceName, Boolean isMatchAll, String sourceIds, String sourceNames, ParserType parserType, String parserIds, String parserNames, Boolean isIncludeParser, String filter, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.isMatchAll = isMatchAll;
        this.sourceIds = sourceIds;
        this.sourceNames = sourceNames;
        this.parserType = parserType;
        this.parserIds = parserIds;
        this.parserNames = parserNames;
        this.isIncludeParser = isIncludeParser;
        this.filter = filter;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Boolean getIsMatchAll() {
        return this.isMatchAll;
    }

    public String getSourceIds() {
        return this.sourceIds;
    }

    public String getSourceNames() {
        return this.sourceNames;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public String getParserIds() {
        return this.parserIds;
    }

    public String getParserNames() {
        return this.parserNames;
    }

    public Boolean getIsIncludeParser() {
        return this.isIncludeParser;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFieldsRequest, Void> {
        private String namespaceName;
        private Boolean isMatchAll;
        private String sourceIds;
        private String sourceNames;
        private ParserType parserType;
        private String parserIds;
        private String parserNames;
        private Boolean isIncludeParser;
        private String filter;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFieldsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.isMatchAll(o.getIsMatchAll());
            this.sourceIds(o.getSourceIds());
            this.sourceNames(o.getSourceNames());
            this.parserType(o.getParserType());
            this.parserIds(o.getParserIds());
            this.parserNames(o.getParserNames());
            this.isIncludeParser(o.getIsIncludeParser());
            this.filter(o.getFilter());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFieldsRequest build() {
            ListFieldsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder isMatchAll(Boolean isMatchAll) {
            this.isMatchAll = isMatchAll;
            return this;
        }

        public Builder sourceIds(String sourceIds) {
            this.sourceIds = sourceIds;
            return this;
        }

        public Builder sourceNames(String sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public Builder parserIds(String parserIds) {
            this.parserIds = parserIds;
            return this;
        }

        public Builder parserNames(String parserNames) {
            this.parserNames = parserNames;
            return this;
        }

        public Builder isIncludeParser(Boolean isIncludeParser) {
            this.isIncludeParser = isIncludeParser;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListFieldsRequest buildWithoutInvocationCallback() {
            return new ListFieldsRequest(this.namespaceName, this.isMatchAll, this.sourceIds, this.sourceNames, this.parserType, this.parserIds, this.parserNames, this.isIncludeParser, this.filter, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListFieldsRequest.Builder(namespaceName=" + this.namespaceName + ", isMatchAll=" + this.isMatchAll + ", sourceIds=" + this.sourceIds + ", sourceNames=" + this.sourceNames + ", parserType=" + (Object)((Object)this.parserType) + ", parserIds=" + this.parserIds + ", parserNames=" + this.parserNames + ", isIncludeParser=" + this.isIncludeParser + ", filter=" + this.filter + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        DataType("dataType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ParserType {
        All("ALL"),
        Regex("REGEX"),
        Xml("XML"),
        Json("JSON");

        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ParserType: " + key);
        }

        static {
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

