/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListLabelsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String labelName;
    private String labelDisplayText;
    private IsSystem isSystem;
    private LabelPriority labelPriority;
    private Boolean isCountPop;
    private Boolean isAliasPop;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private LabelSortBy labelSortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "labelName", "labelDisplayText", "isSystem", "labelPriority", "isCountPop", "isAliasPop", "limit", "page", "sortOrder", "labelSortBy", "opcRequestId"})
    ListLabelsRequest(String namespaceName, String labelName, String labelDisplayText, IsSystem isSystem, LabelPriority labelPriority, Boolean isCountPop, Boolean isAliasPop, Integer limit, String page, SortOrder sortOrder, LabelSortBy labelSortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.labelName = labelName;
        this.labelDisplayText = labelDisplayText;
        this.isSystem = isSystem;
        this.labelPriority = labelPriority;
        this.isCountPop = isCountPop;
        this.isAliasPop = isAliasPop;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.labelSortBy = labelSortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getLabelDisplayText() {
        return this.labelDisplayText;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public LabelPriority getLabelPriority() {
        return this.labelPriority;
    }

    public Boolean getIsCountPop() {
        return this.isCountPop;
    }

    public Boolean getIsAliasPop() {
        return this.isAliasPop;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LabelSortBy getLabelSortBy() {
        return this.labelSortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLabelsRequest, Void> {
        private String namespaceName;
        private String labelName;
        private String labelDisplayText;
        private IsSystem isSystem;
        private LabelPriority labelPriority;
        private Boolean isCountPop;
        private Boolean isAliasPop;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private LabelSortBy labelSortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLabelsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.labelName(o.getLabelName());
            this.labelDisplayText(o.getLabelDisplayText());
            this.isSystem(o.getIsSystem());
            this.labelPriority(o.getLabelPriority());
            this.isCountPop(o.getIsCountPop());
            this.isAliasPop(o.getIsAliasPop());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.labelSortBy(o.getLabelSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLabelsRequest build() {
            ListLabelsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        public Builder labelDisplayText(String labelDisplayText) {
            this.labelDisplayText = labelDisplayText;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder labelPriority(LabelPriority labelPriority) {
            this.labelPriority = labelPriority;
            return this;
        }

        public Builder isCountPop(Boolean isCountPop) {
            this.isCountPop = isCountPop;
            return this;
        }

        public Builder isAliasPop(Boolean isAliasPop) {
            this.isAliasPop = isAliasPop;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder labelSortBy(LabelSortBy labelSortBy) {
            this.labelSortBy = labelSortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListLabelsRequest buildWithoutInvocationCallback() {
            return new ListLabelsRequest(this.namespaceName, this.labelName, this.labelDisplayText, this.isSystem, this.labelPriority, this.isCountPop, this.isAliasPop, this.limit, this.page, this.sortOrder, this.labelSortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListLabelsRequest.Builder(namespaceName=" + this.namespaceName + ", labelName=" + this.labelName + ", labelDisplayText=" + this.labelDisplayText + ", isSystem=" + (Object)((Object)this.isSystem) + ", labelPriority=" + (Object)((Object)this.labelPriority) + ", isCountPop=" + this.isCountPop + ", isAliasPop=" + this.isAliasPop + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", labelSortBy=" + (Object)((Object)this.labelSortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum LabelSortBy {
        Name("name"),
        Priority("priority"),
        SourceUsing("sourceUsing");

        private final String value;
        private static Map<String, LabelSortBy> map;

        private LabelSortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LabelSortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LabelSortBy: " + key);
        }

        static {
            map = new HashMap<String, LabelSortBy>();
            for (LabelSortBy v : LabelSortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LabelPriority {
        None("NONE"),
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH");

        private final String value;
        private static Map<String, LabelPriority> map;

        private LabelPriority(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LabelPriority create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LabelPriority: " + key);
        }

        static {
            map = new HashMap<String, LabelPriority>();
            for (LabelPriority v : LabelPriority.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

