/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListParsersRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private Boolean isMatchAll;
    private SourceType sourceType;
    private String parserName;
    private String parserDisplayText;
    private ParserType parserType;
    private IsSystem isSystem;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "isMatchAll", "sourceType", "parserName", "parserDisplayText", "parserType", "isSystem", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListParsersRequest(String namespaceName, Boolean isMatchAll, SourceType sourceType, String parserName, String parserDisplayText, ParserType parserType, IsSystem isSystem, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.isMatchAll = isMatchAll;
        this.sourceType = sourceType;
        this.parserName = parserName;
        this.parserDisplayText = parserDisplayText;
        this.parserType = parserType;
        this.isSystem = isSystem;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Boolean getIsMatchAll() {
        return this.isMatchAll;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getParserDisplayText() {
        return this.parserDisplayText;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListParsersRequest, Void> {
        private String namespaceName;
        private Boolean isMatchAll;
        private SourceType sourceType;
        private String parserName;
        private String parserDisplayText;
        private ParserType parserType;
        private IsSystem isSystem;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListParsersRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.isMatchAll(o.getIsMatchAll());
            this.sourceType(o.getSourceType());
            this.parserName(o.getParserName());
            this.parserDisplayText(o.getParserDisplayText());
            this.parserType(o.getParserType());
            this.isSystem(o.getIsSystem());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListParsersRequest build() {
            ListParsersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder isMatchAll(Boolean isMatchAll) {
            this.isMatchAll = isMatchAll;
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder parserName(String parserName) {
            this.parserName = parserName;
            return this;
        }

        public Builder parserDisplayText(String parserDisplayText) {
            this.parserDisplayText = parserDisplayText;
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListParsersRequest buildWithoutInvocationCallback() {
            return new ListParsersRequest(this.namespaceName, this.isMatchAll, this.sourceType, this.parserName, this.parserDisplayText, this.parserType, this.isSystem, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListParsersRequest.Builder(namespaceName=" + this.namespaceName + ", isMatchAll=" + this.isMatchAll + ", sourceType=" + (Object)((Object)this.sourceType) + ", parserName=" + this.parserName + ", parserDisplayText=" + this.parserDisplayText + ", parserType=" + (Object)((Object)this.parserType) + ", isSystem=" + (Object)((Object)this.isSystem) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        Type("type"),
        SourcesCount("sourcesCount"),
        TimeUpdated("timeUpdated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ParserType {
        All("ALL"),
        Regex("REGEX"),
        Xml("XML"),
        Json("JSON");

        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ParserType: " + key);
        }

        static {
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SourceType {
        OsFile("OS_FILE"),
        Syslog("SYSLOG"),
        Odl("ODL"),
        OsWindowsSys("OS_WINDOWS_SYS");

        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SourceType: " + key);
        }

        static {
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

