/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSourcesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private String entityType;
    private String sourceDisplayText;
    private IsSystem isSystem;
    private Boolean isAutoAssociated;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Integer limit;
    private String page;
    private String name;
    private Boolean isSimplified;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "compartmentId", "entityType", "sourceDisplayText", "isSystem", "isAutoAssociated", "sortOrder", "sortBy", "limit", "page", "name", "isSimplified", "opcRequestId"})
    ListSourcesRequest(String namespaceName, String compartmentId, String entityType, String sourceDisplayText, IsSystem isSystem, Boolean isAutoAssociated, SortOrder sortOrder, SortBy sortBy, Integer limit, String page, String name, Boolean isSimplified, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.entityType = entityType;
        this.sourceDisplayText = sourceDisplayText;
        this.isSystem = isSystem;
        this.isAutoAssociated = isAutoAssociated;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.limit = limit;
        this.page = page;
        this.name = name;
        this.isSimplified = isSimplified;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getSourceDisplayText() {
        return this.sourceDisplayText;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public Boolean getIsAutoAssociated() {
        return this.isAutoAssociated;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsSimplified() {
        return this.isSimplified;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSourcesRequest, Void> {
        private String namespaceName;
        private String compartmentId;
        private String entityType;
        private String sourceDisplayText;
        private IsSystem isSystem;
        private Boolean isAutoAssociated;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Integer limit;
        private String page;
        private String name;
        private Boolean isSimplified;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSourcesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.entityType(o.getEntityType());
            this.sourceDisplayText(o.getSourceDisplayText());
            this.isSystem(o.getIsSystem());
            this.isAutoAssociated(o.getIsAutoAssociated());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.name(o.getName());
            this.isSimplified(o.getIsSimplified());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSourcesRequest build() {
            ListSourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder sourceDisplayText(String sourceDisplayText) {
            this.sourceDisplayText = sourceDisplayText;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder isAutoAssociated(Boolean isAutoAssociated) {
            this.isAutoAssociated = isAutoAssociated;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isSimplified(Boolean isSimplified) {
            this.isSimplified = isSimplified;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListSourcesRequest buildWithoutInvocationCallback() {
            return new ListSourcesRequest(this.namespaceName, this.compartmentId, this.entityType, this.sourceDisplayText, this.isSystem, this.isAutoAssociated, this.sortOrder, this.sortBy, this.limit, this.page, this.name, this.isSimplified, this.opcRequestId);
        }

        public String toString() {
            return "ListSourcesRequest.Builder(namespaceName=" + this.namespaceName + ", compartmentId=" + this.compartmentId + ", entityType=" + this.entityType + ", sourceDisplayText=" + this.sourceDisplayText + ", isSystem=" + (Object)((Object)this.isSystem) + ", isAutoAssociated=" + this.isAutoAssociated + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", limit=" + this.limit + ", page=" + this.page + ", name=" + this.name + ", isSimplified=" + this.isSimplified + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        TimeUpdated("timeUpdated"),
        AssociationCount("associationCount"),
        SourceType("sourceType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

