/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListStorageWorkRequestErrorsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String workRequestId;
    private String namespaceName;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;

    @ConstructorProperties(value={"compartmentId", "workRequestId", "namespaceName", "opcRequestId", "limit", "page", "sortOrder", "sortBy"})
    ListStorageWorkRequestErrorsRequest(String compartmentId, String workRequestId, String namespaceName, String opcRequestId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy) {
        this.compartmentId = compartmentId;
        this.workRequestId = workRequestId;
        this.namespaceName = namespaceName;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public static class Builder
    implements BmcRequest.Builder<ListStorageWorkRequestErrorsRequest, Void> {
        private String compartmentId;
        private String workRequestId;
        private String namespaceName;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListStorageWorkRequestErrorsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.workRequestId(o.getWorkRequestId());
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListStorageWorkRequestErrorsRequest build() {
            ListStorageWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public ListStorageWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListStorageWorkRequestErrorsRequest(this.compartmentId, this.workRequestId, this.namespaceName, this.opcRequestId, this.limit, this.page, this.sortOrder, this.sortBy);
        }

        public String toString() {
            return "ListStorageWorkRequestErrorsRequest.Builder(compartmentId=" + this.compartmentId + ", workRequestId=" + this.workRequestId + ", namespaceName=" + this.namespaceName + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

