/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListWarningsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private WarningState warningState;
    private String sourceName;
    private String sourcePattern;
    private String warningMessage;
    private String entityName;
    private String entityType;
    private String warningType;
    private Boolean isNoSource;
    private String startTime;
    private String endTime;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"namespaceName", "compartmentId", "warningState", "sourceName", "sourcePattern", "warningMessage", "entityName", "entityType", "warningType", "isNoSource", "startTime", "endTime", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListWarningsRequest(String namespaceName, String compartmentId, WarningState warningState, String sourceName, String sourcePattern, String warningMessage, String entityName, String entityType, String warningType, Boolean isNoSource, String startTime, String endTime, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.warningState = warningState;
        this.sourceName = sourceName;
        this.sourcePattern = sourcePattern;
        this.warningMessage = warningMessage;
        this.entityName = entityName;
        this.entityType = entityType;
        this.warningType = warningType;
        this.isNoSource = isNoSource;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public WarningState getWarningState() {
        return this.warningState;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getWarningType() {
        return this.warningType;
    }

    public Boolean getIsNoSource() {
        return this.isNoSource;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWarningsRequest, Void> {
        private String namespaceName;
        private String compartmentId;
        private WarningState warningState;
        private String sourceName;
        private String sourcePattern;
        private String warningMessage;
        private String entityName;
        private String entityType;
        private String warningType;
        private Boolean isNoSource;
        private String startTime;
        private String endTime;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWarningsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.warningState(o.getWarningState());
            this.sourceName(o.getSourceName());
            this.sourcePattern(o.getSourcePattern());
            this.warningMessage(o.getWarningMessage());
            this.entityName(o.getEntityName());
            this.entityType(o.getEntityType());
            this.warningType(o.getWarningType());
            this.isNoSource(o.getIsNoSource());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWarningsRequest build() {
            ListWarningsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder warningState(WarningState warningState) {
            this.warningState = warningState;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourcePattern(String sourcePattern) {
            this.sourcePattern = sourcePattern;
            return this;
        }

        public Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder warningType(String warningType) {
            this.warningType = warningType;
            return this;
        }

        public Builder isNoSource(Boolean isNoSource) {
            this.isNoSource = isNoSource;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListWarningsRequest buildWithoutInvocationCallback() {
            return new ListWarningsRequest(this.namespaceName, this.compartmentId, this.warningState, this.sourceName, this.sourcePattern, this.warningMessage, this.entityName, this.entityType, this.warningType, this.isNoSource, this.startTime, this.endTime, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListWarningsRequest.Builder(namespaceName=" + this.namespaceName + ", compartmentId=" + this.compartmentId + ", warningState=" + (Object)((Object)this.warningState) + ", sourceName=" + this.sourceName + ", sourcePattern=" + this.sourcePattern + ", warningMessage=" + this.warningMessage + ", entityName=" + this.entityName + ", entityType=" + this.entityType + ", warningType=" + this.warningType + ", isNoSource=" + this.isNoSource + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        EntityType("EntityType"),
        SourceName("SourceName"),
        PatternText("PatternText"),
        FirstReported("FirstReported"),
        WarningMessage("WarningMessage"),
        Host("Host"),
        EntityName("EntityName"),
        InitialWarningDate("InitialWarningDate");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum WarningState {
        All("ALL"),
        Suppressed("SUPPRESSED"),
        Unsuppressed("UNSUPPRESSED");

        private final String value;
        private static Map<String, WarningState> map;

        private WarningState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WarningState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WarningState: " + key);
        }

        static {
            map = new HashMap<String, WarningState>();
            for (WarningState v : WarningState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

