/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestErrorsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String workRequestId;
    private String opcRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"namespaceName", "workRequestId", "opcRequestId", "page", "limit"})
    ListWorkRequestErrorsRequest(String namespaceName, String workRequestId, String opcRequestId, String page, Integer limit) {
        this.namespaceName = namespaceName;
        this.workRequestId = workRequestId;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestErrorsRequest, Void> {
        private String namespaceName;
        private String workRequestId;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestErrorsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.workRequestId(o.getWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestErrorsRequest build() {
            ListWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestErrorsRequest(this.namespaceName, this.workRequestId, this.opcRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListWorkRequestErrorsRequest.Builder(namespaceName=" + this.namespaceName + ", workRequestId=" + this.workRequestId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

