/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.ParseQueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ParseQueryRequest
extends BmcRequest<ParseQueryDetails> {
    private String namespaceName;
    private ParseQueryDetails parseQueryDetails;
    private String opcRequestId;

    @InternalSdk
    public ParseQueryDetails getBody$() {
        return this.parseQueryDetails;
    }

    @ConstructorProperties(value={"namespaceName", "parseQueryDetails", "opcRequestId"})
    ParseQueryRequest(String namespaceName, ParseQueryDetails parseQueryDetails, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.parseQueryDetails = parseQueryDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ParseQueryDetails getParseQueryDetails() {
        return this.parseQueryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ParseQueryRequest, ParseQueryDetails> {
        private String namespaceName;
        private ParseQueryDetails parseQueryDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ParseQueryRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.parseQueryDetails(o.getParseQueryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ParseQueryRequest build() {
            ParseQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ParseQueryDetails body) {
            this.parseQueryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder parseQueryDetails(ParseQueryDetails parseQueryDetails) {
            this.parseQueryDetails = parseQueryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ParseQueryRequest buildWithoutInvocationCallback() {
            return new ParseQueryRequest(this.namespaceName, this.parseQueryDetails, this.opcRequestId);
        }

        public String toString() {
            return "ParseQueryRequest.Builder(namespaceName=" + this.namespaceName + ", parseQueryDetails=" + this.parseQueryDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

