/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.loganalytics.model.QueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class QueryRequest
extends BmcRequest<QueryDetails> {
    private String namespaceName;
    private QueryDetails queryDetails;
    private String page;
    private String opcRequestId;
    private Integer limit;

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    @ConstructorProperties(value={"namespaceName", "queryDetails", "page", "opcRequestId", "limit"})
    QueryRequest(String namespaceName, QueryDetails queryDetails, String page, String opcRequestId, Integer limit) {
        this.namespaceName = namespaceName;
        this.queryDetails = queryDetails;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryRequest, QueryDetails> {
        private String namespaceName;
        private QueryDetails queryDetails;
        private String page;
        private String opcRequestId;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.queryDetails(o.getQueryDetails());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryRequest build() {
            QueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest buildWithoutInvocationCallback() {
            return new QueryRequest(this.namespaceName, this.queryDetails, this.page, this.opcRequestId, this.limit);
        }

        public String toString() {
            return "QueryRequest.Builder(namespaceName=" + this.namespaceName + ", queryDetails=" + this.queryDetails + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ")";
        }
    }
}

