/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class RegisterLookupRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private Type type;
    private InputStream registerLookupContentFileBody;
    private String name;
    private String description;
    private String charEncoding;
    private Boolean isHidden;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public InputStream getBody$() {
        return this.registerLookupContentFileBody;
    }

    @ConstructorProperties(value={"namespaceName", "type", "registerLookupContentFileBody", "name", "description", "charEncoding", "isHidden", "opcRetryToken", "opcRequestId"})
    RegisterLookupRequest(String namespaceName, Type type, InputStream registerLookupContentFileBody, String name, String description, String charEncoding, Boolean isHidden, String opcRetryToken, String opcRequestId) {
        this.namespaceName = namespaceName;
        this.type = type;
        this.registerLookupContentFileBody = registerLookupContentFileBody;
        this.name = name;
        this.description = description;
        this.charEncoding = charEncoding;
        this.isHidden = isHidden;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getRegisterLookupContentFileBody() {
        return this.registerLookupContentFileBody;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RegisterLookupRequest, InputStream> {
        private String namespaceName;
        private Type type;
        private InputStream registerLookupContentFileBody;
        private String name;
        private String description;
        private String charEncoding;
        private Boolean isHidden;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RegisterLookupRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.type(o.getType());
            this.registerLookupContentFileBody(o.getRegisterLookupContentFileBody());
            this.name(o.getName());
            this.description(o.getDescription());
            this.charEncoding(o.getCharEncoding());
            this.isHidden(o.getIsHidden());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RegisterLookupRequest build() {
            RegisterLookupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.registerLookupContentFileBody(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder registerLookupContentFileBody(InputStream registerLookupContentFileBody) {
            this.registerLookupContentFileBody = registerLookupContentFileBody;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder charEncoding(String charEncoding) {
            this.charEncoding = charEncoding;
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RegisterLookupRequest buildWithoutInvocationCallback() {
            return new RegisterLookupRequest(this.namespaceName, this.type, this.registerLookupContentFileBody, this.name, this.description, this.charEncoding, this.isHidden, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "RegisterLookupRequest.Builder(namespaceName=" + this.namespaceName + ", type=" + (Object)((Object)this.type) + ", registerLookupContentFileBody=" + this.registerLookupContentFileBody + ", name=" + this.name + ", description=" + this.description + ", charEncoding=" + this.charEncoding + ", isHidden=" + this.isHidden + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum Type {
        Lookup("Lookup"),
        Dictionary("Dictionary");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

