/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.logging.model.LogIncludedSearch;
import com.oracle.bmc.logging.requests.GetLogIncludedSearchRequest;
import com.oracle.bmc.logging.responses.GetLogIncludedSearchResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogIncludedSearchConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetLogIncludedSearchConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetLogIncludedSearchRequest interceptRequest(GetLogIncludedSearchRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetLogIncludedSearchRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLogIncludedSearchId(), (String)"logIncludedSearchId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200531").path("logIncludedSearch").path(HttpUtils.encodePathSegment((String)request.getLogIncludedSearchId()));
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetLogIncludedSearchResponse> fromResponse() {
        Function<Response, GetLogIncludedSearchResponse> transformer = new Function<Response, GetLogIncludedSearchResponse>(){

            public GetLogIncludedSearchResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.logging.responses.GetLogIncludedSearchResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogIncludedSearch.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetLogIncludedSearchResponse.Builder builder = GetLogIncludedSearchResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logIncludedSearch((LogIncludedSearch)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetLogIncludedSearchResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

