/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.logging.model.LogLifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListUnifiedAgentConfigurationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String logId;
    private Boolean isCompartmentIdInSubtree;
    private String groupId;
    private String displayName;
    private LogLifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "logId", "isCompartmentIdInSubtree", "groupId", "displayName", "lifecycleState", "limit", "page", "sortBy", "sortOrder", "opcRequestId"})
    ListUnifiedAgentConfigurationsRequest(String compartmentId, String logId, Boolean isCompartmentIdInSubtree, String groupId, String displayName, LogLifecycleState lifecycleState, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.logId = logId;
        this.isCompartmentIdInSubtree = isCompartmentIdInSubtree;
        this.groupId = groupId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getLogId() {
        return this.logId;
    }

    public Boolean getIsCompartmentIdInSubtree() {
        return this.isCompartmentIdInSubtree;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LogLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUnifiedAgentConfigurationsRequest, Void> {
        private String compartmentId;
        private String logId;
        private Boolean isCompartmentIdInSubtree;
        private String groupId;
        private String displayName;
        private LogLifecycleState lifecycleState;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUnifiedAgentConfigurationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.logId(o.getLogId());
            this.isCompartmentIdInSubtree(o.getIsCompartmentIdInSubtree());
            this.groupId(o.getGroupId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUnifiedAgentConfigurationsRequest build() {
            ListUnifiedAgentConfigurationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder isCompartmentIdInSubtree(Boolean isCompartmentIdInSubtree) {
            this.isCompartmentIdInSubtree = isCompartmentIdInSubtree;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(LogLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListUnifiedAgentConfigurationsRequest buildWithoutInvocationCallback() {
            return new ListUnifiedAgentConfigurationsRequest(this.compartmentId, this.logId, this.isCompartmentIdInSubtree, this.groupId, this.displayName, this.lifecycleState, this.limit, this.page, this.sortBy, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListUnifiedAgentConfigurationsRequest.Builder(compartmentId=" + this.compartmentId + ", logId=" + this.logId + ", isCompartmentIdInSubtree=" + this.isCompartmentIdInSubtree + ", groupId=" + this.groupId + ", displayName=" + this.displayName + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

